/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;

public class RawMap
extends WebMap {
    private byte[] mapContents;
    private ByteArrayOutputStream buffer;
    private InputStream stream;

    public RawMap(WMSMapContent mapContent, byte[] mapContents, String mimeType) {
        super(mapContent);
        this.mapContents = mapContents;
        this.setMimeType(mimeType);
    }

    public RawMap(WMSMapContent mapContent, ByteArrayOutputStream buff, String mimeType) {
        super(mapContent);
        this.buffer = buff;
        this.setMimeType(mimeType);
    }

    public RawMap(WMSMapContent mapContent, InputStream stream, String mimeType) {
        super(mapContent);
        this.stream = stream;
        this.setMimeType(mimeType);
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.mapContents != null) {
            out.write(this.mapContents);
        } else if (this.buffer != null) {
            this.buffer.writeTo(out);
        } else if (this.stream != null) {
            IOUtils.copy((InputStream)this.stream, (OutputStream)out);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void disposeInternal() {
        this.buffer = null;
        this.mapContents = null;
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

