/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.AbstractOpenLayersMapOutputFormat;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;

public class OpenLayers3MapOutputFormat
extends AbstractOpenLayersMapOutputFormat {
    static final String OL3_TEMPLATE_FTL = "OpenLayers3MapTemplate.ftl";
    public static final String OL3_FORMAT = "application/openlayers3";
    public static final String MIME_TYPE = "text/html; subtype=openlayers3";
    private static final Set<String> OUTPUT_FORMATS = new HashSet<String>(Arrays.asList("application/openlayers3", "text/html; subtype=openlayers3"));

    public OpenLayers3MapOutputFormat(WMS wms) {
        super(wms);
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return OUTPUT_FORMATS;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    protected String getTemplateName(WMSMapContent mapContent) {
        if (!this.browserSupportsOL3(mapContent)) {
            throw new ServiceException("OpenLayers 3 is not supported on the current browser");
        }
        return OL3_TEMPLATE_FTL;
    }

    protected boolean browserSupportsOL3(WMSMapContent mc) {
        String agent = mc.getRequest().getHttpRequestHeader("USER-AGENT");
        if (agent == null) {
            return false;
        }
        Pattern MSIE_PATTERN = Pattern.compile(".*MSIE (\\d+)\\..*");
        Matcher matcher = MSIE_PATTERN.matcher(agent);
        if (!matcher.matches()) {
            return true;
        }
        return Integer.valueOf(matcher.group(1)) > 8;
    }

    @Override
    protected String getUnits(WMSMapContent mapContent) {
        CoordinateReferenceSystem crs = mapContent.getRequest().getCrs();
        String result = crs instanceof ProjectedCRS ? "m" : "degrees";
        try {
            String unit = crs.getCoordinateSystem().getAxis(0).getUnit().toString();
            if ("ft".equals(unit) || "feets".equals(unit)) {
                result = "feet";
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error trying to determine unit of measure", e);
        }
        return result;
    }
}

