/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geoserver.wms.icons.IconPropertyExtractor;
import org.geoserver.wms.icons.MiniRule;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.Symbolizer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.IsStaticExpressionVisitor;
import org.geotools.renderer.style.ExpressionExtractor;

public final class IconPropertyInjector {
    private final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
    private final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
    private final Map<String, String> properties;

    private IconPropertyInjector(Map<String, String> properties) {
        this.properties = properties;
    }

    private List<List<MiniRule>> injectProperties(List<List<MiniRule>> ftStyles) {
        ArrayList<List<MiniRule>> result = new ArrayList<List<MiniRule>>();
        for (int ftIdx = 0; ftIdx < ftStyles.size(); ++ftIdx) {
            boolean empty = true;
            List<MiniRule> origRules = ftStyles.get(ftIdx);
            ArrayList<MiniRule> resultRules = new ArrayList<MiniRule>();
            for (int ruleIdx = 0; ruleIdx < origRules.size(); ++ruleIdx) {
                MiniRule origRule = origRules.get(ruleIdx);
                ArrayList<Symbolizer> resultSymbolizers = new ArrayList<Symbolizer>();
                for (int symbIdx = 0; symbIdx < origRule.symbolizers.size(); ++symbIdx) {
                    String key = ftIdx + "." + ruleIdx + "." + symbIdx;
                    if (!this.properties.containsKey(key)) continue;
                    Symbolizer sym = origRule.symbolizers.get(symbIdx);
                    resultSymbolizers.add((Symbolizer)this.injectPointSymbolizer(key, sym));
                    empty = false;
                }
                resultRules.add(new MiniRule(null, false, resultSymbolizers));
            }
            if (empty) continue;
            result.add(resultRules);
        }
        return result;
    }

    private boolean isStatic(Expression ex) {
        return (Boolean)ex.accept((ExpressionVisitor)IsStaticExpressionVisitor.VISITOR, null);
    }

    private boolean shouldUpdate(String key, Expression exp) {
        return exp != null && this.properties.containsKey(key) && !this.isStatic(exp);
    }

    private Expression getLiteral(String key) {
        return this.filterFactory.literal((Object)this.properties.get(key));
    }

    private PointSymbolizer injectPointSymbolizer(String key, Symbolizer original) {
        PointSymbolizer copy = this.styleFactory.createPointSymbolizer();
        Graphic graphic = IconPropertyExtractor.getGraphic(original, true);
        if (graphic != null) {
            copy.setGraphic(this.injectGraphic(key, graphic));
        }
        return copy;
    }

    private Graphic injectGraphic(String key, Graphic original) {
        ExternalGraphic[] externalGraphics;
        Mark[] marks;
        Symbol[] symbols = new Symbol[]{};
        Expression opacity = original.getOpacity();
        Expression size = original.getSize();
        Expression rotation = original.getRotation();
        if (this.shouldUpdate(key + ".opacity", opacity)) {
            opacity = this.getLiteral(key + ".opacity");
        }
        if (this.shouldUpdate(key + ".rotation", rotation)) {
            rotation = this.getLiteral(key + ".rotation");
        }
        if (this.shouldUpdate(key + ".size", size)) {
            size = this.getLiteral(key + ".size");
        }
        if (!original.graphicalSymbols().isEmpty()) {
            ArrayList<Mark> markList = new ArrayList<Mark>();
            ArrayList<ExternalGraphic> externalGraphicList = new ArrayList<ExternalGraphic>();
            for (GraphicalSymbol symbol : original.graphicalSymbols()) {
                if (symbol instanceof Mark) {
                    markList.add(this.injectMark(key, (Mark)symbol));
                    continue;
                }
                if (!(symbol instanceof ExternalGraphic)) continue;
                externalGraphicList.add(this.injectExternalGraphic(key, (ExternalGraphic)symbol));
            }
            marks = markList.toArray(new Mark[0]);
            externalGraphics = externalGraphicList.toArray(new ExternalGraphic[0]);
        } else {
            marks = new Mark[]{};
            externalGraphics = new ExternalGraphic[]{};
        }
        return this.styleFactory.createGraphic(externalGraphics, marks, symbols, opacity, size, rotation);
    }

    private ExternalGraphic injectExternalGraphic(String key, ExternalGraphic original) {
        try {
            String format = original.getFormat();
            Expression locationExpression = original.getLocation() == null ? null : ExpressionExtractor.extractCqlExpressions((String)original.getLocation().toExternalForm());
            URL location = locationExpression == null || this.isStatic(locationExpression) ? original.getLocation() : new URL(this.properties.get(key + ".url"));
            return this.styleFactory.createExternalGraphic(location, format);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Mark injectMark(String key, Mark mark) {
        Expression size = null;
        Expression rotation = null;
        Expression wellKnownName = mark.getWellKnownName() == null || this.isStatic(mark.getWellKnownName()) ? mark.getWellKnownName() : this.getLiteral(key + ".name");
        Fill fill = mark.getFill() == null ? null : this.injectFill(key + ".fill", mark.getFill());
        Stroke stroke = mark.getStroke() == null ? null : this.injectStroke(key + ".stroke", mark.getStroke());
        return this.styleFactory.createMark(wellKnownName, stroke, fill, size, rotation);
    }

    private Stroke injectStroke(String key, Stroke stroke) {
        Expression color = stroke.getColor() == null || this.isStatic(stroke.getColor()) ? stroke.getColor() : this.getLiteral(key + ".color");
        Expression dashOffset = stroke.getDashOffset() == null || this.isStatic(stroke.getDashOffset()) ? stroke.getDashOffset() : this.getLiteral(key + ".linecap");
        Expression lineCap = stroke.getLineCap() == null || this.isStatic(stroke.getDashOffset()) ? stroke.getLineCap() : this.getLiteral(key + ".linecap");
        Expression lineJoin = stroke.getLineJoin() == null || this.isStatic(stroke.getLineJoin()) ? stroke.getLineJoin() : this.getLiteral(key + ".linejoin");
        Expression opacity = stroke.getOpacity() == null || this.isStatic(stroke.getOpacity()) ? stroke.getOpacity() : this.getLiteral(key + ".opacity");
        Expression width = stroke.getWidth() == null || this.isStatic(stroke.getWidth()) ? stroke.getOpacity() : this.getLiteral(key + ".opacity");
        Graphic graphicStroke = stroke.getGraphicStroke() == null ? null : this.injectGraphic(key + ".graphic", stroke.getGraphicStroke());
        Graphic graphicFill = stroke.getGraphicFill() == null ? null : this.injectGraphic(key + ".graphic", stroke.getGraphicFill());
        return this.styleFactory.createStroke(color, width, opacity, lineJoin, lineCap, stroke.getDashArray(), dashOffset, graphicFill, graphicStroke);
    }

    private Fill injectFill(String key, Fill fill) {
        Expression backgroundColor = null;
        Expression color = fill.getColor() == null || this.isStatic(fill.getColor()) ? fill.getColor() : this.getLiteral(key + ".color");
        Expression opacity = fill.getOpacity() == null || this.isStatic(fill.getOpacity()) ? fill.getOpacity() : this.getLiteral(key + ".opacity");
        Graphic graphicFill = fill.getGraphicFill() == null ? null : this.injectGraphic(key + ".graphic", fill.getGraphicFill());
        return this.styleFactory.createFill(color, backgroundColor, opacity, graphicFill);
    }

    public static Style injectProperties(Style style, Map<String, String> properties) {
        boolean includeNonPointGraphics = Boolean.valueOf(properties.getOrDefault("npg", "false"));
        List<List<MiniRule>> ftStyles = MiniRule.minify(style, includeNonPointGraphics);
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        return MiniRule.makeStyle(factory, new IconPropertyInjector(properties).injectProperties(ftStyles));
    }
}

