/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.GetLegendGraphicKvpReader;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.map.Layer;
import org.geotools.renderer.lite.RendererUtilities;

public class LegendDecoration
extends AbstractDispatcherCallback
implements MapDecoration {
    private static int TITLE_INDENT = 5;
    private static double BETWEEN_LEGENDS_PERCENT_INDENT = 0.05;
    private final WMS wms;
    private Map<String, Expression> options;
    private ThreadLocal<List<LayerLegend>> legends = new ThreadLocal();
    private List<String> layers;
    private boolean useSldTitle;
    private Map<String, String> legendOptionsMap;
    private float opacityOption = 1.0f;

    public LegendDecoration(WMS wms) {
        this.wms = wms;
        this.layers = new ArrayList<String>();
    }

    public void finished(Request request) {
        this.legends.remove();
    }

    private <T> T remove(Map<String, Expression> options, String key, Class<T> target) {
        Expression expression = options.remove(key);
        return MapDecorationLayout.evaluate(expression, target);
    }

    private String remove(Map<String, Expression> options, String key) {
        return this.remove(options, key, String.class);
    }

    @Override
    public void loadOptions(Map<String, Expression> options) {
        Float opacity;
        String legendOptions;
        String sldTitle;
        this.options = new HashMap<String, Expression>(options);
        String layers = this.remove(this.options, "layers");
        if (layers != null) {
            String[] splittedLayers = layers.split(",");
            this.layers.addAll(Arrays.asList(splittedLayers));
        }
        if ("true".equalsIgnoreCase(sldTitle = this.remove(this.options, "sldTitle")) || "on".equalsIgnoreCase(sldTitle)) {
            this.useSldTitle = true;
        }
        if ((legendOptions = this.remove(this.options, "legend_options")) != null && !legendOptions.isEmpty()) {
            String[] splittedLegendOptions;
            this.legendOptionsMap = new HashMap<String, String>();
            for (String lop : splittedLegendOptions = legendOptions.split(";")) {
                String[] kvp = lop.split(":");
                this.legendOptionsMap.put(kvp[0], kvp[1]);
            }
        }
        if ((opacity = this.remove(this.options, "opacity", Float.class)) != null) {
            this.opacityOption = opacity.floatValue();
        }
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContext) {
        double dpi = RendererUtilities.getDpi(mapContext.getRequest().getFormatOptions());
        double standardDpi = RendererUtilities.getDpi(Collections.emptyMap());
        double scaleFactor = dpi / standardDpi;
        List<LayerLegend> layerLegends = this.getLayerLegend(g2d, mapContext, null);
        this.legends.set(layerLegends);
        int width = 0;
        int height = 0;
        for (LayerLegend legend : layerLegends) {
            int legendHeight = legend.legend.getHeight();
            int legendWidth = legend.legend.getWidth();
            int titleWidth = 0;
            int titleHeight = 0;
            if (legend.title != null) {
                titleWidth = legend.title.getWidth();
                titleHeight = legend.title.getHeight();
            }
            int tmpHeight = legendHeight + titleHeight;
            int tmpWidth = legendWidth;
            if (titleWidth > legendWidth) {
                tmpWidth = titleWidth;
                tmpWidth += (int)Math.ceil((double)(TITLE_INDENT * 2) * scaleFactor);
            }
            Dimension size = new BasicStroke((float)scaleFactor).createStrokedShape(new Rectangle(0, 0, tmpWidth, tmpHeight)).getBounds().getSize();
            height += (int)Math.ceil(size.getHeight() + size.getHeight() * BETWEEN_LEGENDS_PERCENT_INDENT);
            if (!(size.getWidth() > (double)width)) continue;
            width = (int)Math.ceil(size.getWidth());
        }
        return new Dimension(width, height);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent mapContext) throws Exception {
        List<LayerLegend> legends = this.legends.get() != null ? this.legends.get() : this.getLayerLegend(g2d, mapContext, paintArea);
        double dpi = RendererUtilities.getDpi(mapContext.getRequest().getFormatOptions());
        double standardDpi = RendererUtilities.getDpi(Collections.emptyMap());
        double scaleFactor = dpi / standardDpi;
        Rectangle mainClip = g2d.getClipBounds();
        int heightOffset = 0;
        for (LayerLegend legend : legends) {
            int height = (int)paintArea.getHeight();
            int width = (int)paintArea.getWidth();
            if (legend.title != null) {
                height += legend.title.getHeight();
                if (width < legend.title.getWidth()) {
                    width = legend.title.getWidth();
                    width += (int)Math.ceil((double)(TITLE_INDENT * 2) * scaleFactor);
                }
            }
            Dimension size = new BasicStroke((float)scaleFactor).createStrokedShape(new Rectangle(0, 0, width, height)).getBounds().getSize();
            int strokeHeight = (int)Math.ceil(size.getHeight());
            int strokeWidth = (int)Math.ceil(size.getWidth());
            BufferedImage finalLegend = ImageUtils.createImage(strokeWidth, strokeHeight, null, false);
            Graphics2D finalGraphics = ImageUtils.prepareTransparency(false, LegendUtils.getBackgroundColor(legend.request), finalLegend, new HashMap<RenderingHints.Key, Object>());
            int titleHeightOffset = 0;
            if (legend.title != null) {
                finalGraphics.drawImage((Image)legend.title, (strokeWidth - legend.title.getWidth()) / 2, strokeHeight - height, null);
                titleHeightOffset += legend.title.getHeight();
            }
            finalGraphics.drawImage((Image)legend.legend, (strokeWidth - width) / 2, strokeHeight - height + titleHeightOffset, null);
            finalGraphics.setColor(LegendUtils.DEFAULT_BORDER_COLOR);
            finalGraphics.fill(new BasicStroke((float)scaleFactor).createStrokedShape(new Rectangle(0, 0, strokeWidth - 1, strokeHeight - 1)));
            g2d.drawImage((Image)finalLegend, mainClip.x + (int)Math.ceil((paintArea.getWidth() - (double)strokeWidth) / 2.0), mainClip.y + heightOffset, null);
            heightOffset = (int)((double)heightOffset + ((double)strokeHeight + (double)strokeHeight * BETWEEN_LEGENDS_PERCENT_INDENT));
        }
    }

    private String findTitle(Layer layer, Catalog catalog) {
        ResourceInfo resource;
        if (layer.getTitle() == null) {
            return null;
        }
        String[] nameparts = layer.getTitle().split(":");
        ResourceInfo resourceInfo = resource = nameparts.length > 1 ? catalog.getResourceByName(nameparts[0], nameparts[1], ResourceInfo.class) : catalog.getResourceByName(nameparts[0], ResourceInfo.class);
        if (this.useSldTitle && layer.getStyle() != null && layer.getStyle().getDescription() != null && layer.getStyle().getDescription().getTitle() != null) {
            return layer.getStyle().getDescription().getTitle().toString();
        }
        if (resource != null) {
            return resource.getTitle();
        }
        return layer.getTitle();
    }

    private void setLegendInfo(Layer layer, GetLegendGraphicRequest request, Rectangle size) {
        LayerInfo info = this.wms.getLayerByName(layer.getTitle());
        StyleInfo defaultStyle = info.getDefaultStyle();
        Predicate<StyleInfo> predicate = s -> {
            try {
                return s.getName().equals(layer.getStyle().getName()) && s.getStyle() != null;
            }
            catch (IOException e) {
                return false;
            }
        };
        StyleInfo sInfo = info.getStyles().stream().filter(predicate).findFirst().orElseGet(() -> defaultStyle);
        LegendInfo legend = sInfo.getLegend();
        if (legend != null && legend.getOnlineResource() != null) {
            if (size != null) {
                request.setWidth((int)size.getWidth());
                request.setHeight((int)size.getHeight());
            } else {
                request.setWidth(legend.getWidth());
                request.setHeight(legend.getHeight());
            }
        }
        GetLegendGraphicRequest.LegendRequest legendReq = request.getLegend(layer.getFeatureSource().getSchema().getName());
        legendReq.setLayerInfo(info);
        GetLegendGraphicKvpReader reader = new GetLegendGraphicKvpReader(this.wms);
        LegendInfo legendInfo = reader.resolveLegendInfo(sInfo.getLegend(), request, sInfo);
        if (legendInfo != null) {
            legendReq.setLegendInfo(legendInfo);
        }
    }

    public List<LayerLegend> getLayerLegends(Graphics2D g2d, WMSMapContent mapContext) {
        return this.getLayerLegend(g2d, mapContext, null);
    }

    private List<LayerLegend> getLayerLegend(Graphics2D g2d, WMSMapContent mapContext, Rectangle size) {
        ArrayList<LayerLegend> legendLayers = new ArrayList<LayerLegend>();
        double scaleDenominator = mapContext.getScaleDenominator(true);
        for (Layer layer : mapContext.layers()) {
            BufferedImage legendImage;
            Rule[] applicableRules = LegendUtils.getApplicableRules(layer.getStyle().featureTypeStyles().toArray(new FeatureTypeStyle[0]), scaleDenominator);
            if (!this.layers.isEmpty() && !this.layers.contains(layer.getTitle()) || applicableRules.length == 0) continue;
            BufferedImageLegendGraphicBuilder legendGraphicBuilder = new BufferedImageLegendGraphicBuilder();
            GetLegendGraphicRequest request = new GetLegendGraphicRequest();
            request.setLayer(layer.getFeatureSource().getSchema());
            request.setTransparent(true);
            request.setScale(scaleDenominator);
            request.setStyle(layer.getStyle());
            request.setWms(this.wms);
            Request dispatcherRequest = (Request)Dispatcher.REQUEST.get();
            if (dispatcherRequest != null) {
                request.setKvp(dispatcherRequest.getKvp());
                request.setRawKvp((Map<String, String>)KvpUtils.toStringKVP((Map)dispatcherRequest.getRawKvp()));
            }
            this.setLegendInfo(layer, request, size);
            Map<String, Object> legendOptions = this.getLegendOptions();
            legendOptions.putAll(mapContext.getRequest().getFormatOptions());
            if (this.legendOptionsMap != null) {
                legendOptions.putAll(this.legendOptionsMap);
            }
            float opacity = this.opacityOption;
            g2d.setComposite(AlphaComposite.getInstance(3, opacity));
            if (dispatcherRequest != null && dispatcherRequest.getKvp().get("legend_options") != null) {
                Map requestOptions = (Map)dispatcherRequest.getKvp().get("legend_options");
                legendOptions.putAll(requestOptions);
            }
            request.setLegendOptions(legendOptions);
            LayerLegend legend = new LayerLegend();
            legend.request = request;
            String title = this.findTitle(layer, this.wms.getGeoServer().getCatalog());
            if (title != null) {
                Font newFont = LegendUtils.getLabelFont(request);
                newFont = newFont.deriveFont(1);
                newFont = newFont.deriveFont((float)newFont.getSize() + 2.0f);
                Font oldFont = g2d.getFont();
                g2d.setFont(newFont);
                if (LegendUtils.isFontAntiAliasing(legend.request)) {
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                BufferedImage titleImage = LegendUtils.renderLabel(title, g2d, request);
                g2d.setFont(oldFont);
                legend.title = titleImage;
            }
            legend.legend = legendImage = legendGraphicBuilder.buildLegendGraphic(request);
            legendLayers.add(legend);
        }
        return legendLayers;
    }

    private Map<String, Object> getLegendOptions() {
        CaseInsensitiveMap result = new CaseInsensitiveMap(new HashMap());
        List parsers = GeoServerExtensions.extensions(KvpParser.class);
        for (Map.Entry<String, Expression> entry : this.options.entrySet()) {
            String key = entry.getKey();
            String value = MapDecorationLayout.evaluate(entry.getValue(), String.class);
            Object parsed = null;
            for (Object o : parsers) {
                KvpParser parser = (KvpParser)o;
                if (!key.equalsIgnoreCase(parser.getKey())) continue;
                try {
                    parsed = parser.parse(value);
                    if (parsed == null) continue;
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to parse key " + key, e);
                }
            }
            if (parsed == null) {
                parsed = value;
            }
            result.put(key, parsed);
        }
        return result;
    }

    private class LayerLegend {
        public BufferedImage title;
        public BufferedImage legend;
        public GetLegendGraphicRequest request;

        private LayerLegend() {
        }
    }
}

