/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.util.Map;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class LayerWorkspaceTest
extends WMSTestSupport {
    private Catalog catalog;

    @Before
    public void setCatalog() throws Exception {
        this.catalog = this.getCatalog();
    }

    LayerInfo layer(Catalog cat, QName name) {
        return cat.getLayerByName(this.getLayerId(name));
    }

    @Override
    protected void registerNamespaces(Map<String, String> namespaces) {
        namespaces.put("wms", "http://www.opengis.net/wms");
    }

    @Test
    public void testGlobalCapabilities() throws Exception {
        LayerInfo layer = this.layer(this.catalog, MockData.PRIMITIVEGEOFEATURE);
        Document doc = this.getAsDOM("/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathExists((String)("//wms:Layer[wms:Name='" + layer.prefixedName() + "']"), (Document)doc);
    }

    @Test
    public void testWorkspaceCapabilities() throws Exception {
        Document doc = this.getAsDOM("/sf/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathExists((String)("//wms:Layer[wms:Name='" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "']"), (Document)doc);
    }
}

