/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class DimensionsRasterCapabilitiesTest
extends WMSDimensionsTestSupport {
    @Test
    public void testNoDimension() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='sf:watertemp'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
    }

    @Test
    public void testDefaultElevationUnits() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:5030", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"m", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
    }

    @Test
    public void testElevationList() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0,100.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationContinuous() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/100.0/0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationDiscreteNoResolution() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.DISCRETE_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/100.0/100.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationDiscreteManualResolution() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.DISCRETE_INTERVAL, 10.0, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/100.0/10.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeList() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//wms:Layer/wms:Dimension/@nearestValue", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeNearestMatch() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(WATTEMP, "time", true);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wms:Layer/wms:Dimension/@nearestValue", (Document)dom);
    }

    @Test
    public void testTimeContinuous() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT1S", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeResolution() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.DISCRETE_INTERVAL, 4.32E7, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT12H", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testDefaultTimeRangeFixed() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("P1M/PRESENT");
        this.setupResourceDimensionDefaultValue(WATTEMP, "time", defaultValueSetting, new String[0]);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"P1M/PRESENT", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
    }

    @Test
    public void testStaticTimeRange() throws Exception {
        String startValue = "2014-01-24T13:25:00.000Z";
        String endValue = "2021";
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.DISCRETE_INTERVAL, 4.32E7, null, null);
        this.setupRasterStartAndEndValues(TIMERANGES, "time", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2014-01-24T13:25:00.000Z/2021-01-01T00:00:00.000Z/PT12H", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticTimeRangeContinuous() throws Exception {
        String startValue = "2014-01-24T13:25:00.000Z";
        String endValue = "2021";
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        this.setupRasterStartAndEndValues(TIMERANGES, "time", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2014-01-24T13:25:00.000Z/2021-01-01T00:00:00.000Z/PT1S", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticElevationRange() throws Exception {
        String startValue = "-11034.0";
        String endValue = "8848.86";
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.DISCRETE_INTERVAL, 1.1, "foot", "ft");
        this.setupRasterStartAndEndValues(TIMERANGES, "elevation", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-11034.0/8848.86/1.1", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticElevationRangeContinuous() throws Exception {
        String startValue = "-11034.0";
        String endValue = "8848.86";
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        this.setupRasterStartAndEndValues(TIMERANGES, "elevation", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-11034.0/8848.86/0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }
}

