/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.xsd.XML;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class CapabilitiesSystemTest
extends WMSTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        MetadataLinkInfo mdlink = this.getCatalog().getFactory().createMetadataLink();
        mdlink.setMetadataType("FGDC");
        mdlink.setContent("http://geoserver.org");
        mdlink.setType("text/xml");
        ResourceInfo resource = layer.getResource();
        resource.getMetadataLinks().add(mdlink);
        this.getCatalog().save(resource);
        Catalog catalog = this.getCatalog();
        DataStoreInfo info = catalog.getDataStoreByName(MockData.SF_PREFIX);
        info.setEnabled(false);
        catalog.save((StoreInfo)info);
    }

    @Test
    public void testValidateCapabilitiesXML() throws Exception {
        final Document dom = this.getAsDOM("ows?service=WMS&version=1.3.0&request=GetCapabilities");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaLocation = ((Object)((Object)this)).getClass().getResource("/schemas/wms/1.3.0/capabilities_1_3_0.xsd");
        factory.setResourceResolver(new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                if (namespaceURI.equals("http://www.w3.org/1999/xlink")) {
                    try {
                        LSInput input = ((DOMImplementationLS)((Object)dom.getImplementation())).createLSInput();
                        URL xlink = this.getClass().getResource("/schemas/xlink/1999/xlink.xsd");
                        systemId = xlink.toURI().toASCIIString();
                        input.setPublicId(publicId);
                        input.setSystemId(systemId);
                        return input;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                    try {
                        LSInput input = ((DOMImplementationLS)((Object)dom.getImplementation())).createLSInput();
                        URL xml = XML.class.getResource("xml.xsd");
                        systemId = xml.toURI().toASCIIString();
                        input.setPublicId(publicId);
                        input.setSystemId(systemId);
                        return input;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
        });
        Schema schema = factory.newSchema(schemaLocation);
        Validator validator = schema.newValidator();
        DOMSource source = new DOMSource(dom);
        try {
            validator.validate(source);
            Assert.assertTrue((boolean)true);
        }
        catch (SAXException ex) {
            LOGGER.log(Level.WARNING, "WMS 1.3.0 capabilities validation error", ex);
            this.print(dom);
            Assert.fail((String)("WMS 1.3.0 capabilities validation error: " + ex.getMessage()));
        }
    }

    @Test
    public void testRequestVersionNumberNegotiation() throws Exception {
        Document dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities");
        XMLAssert.assertXpathEvaluatesTo((String)"1.3.0", (String)"/wms:WMS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.1.1");
        XMLAssert.assertXpathEvaluatesTo((String)"1.1.1", (String)"/WMT_MS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1.3.0", (String)"/wms:WMS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.1.2");
        XMLAssert.assertXpathEvaluatesTo((String)"1.1.1", (String)"/WMT_MS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.4.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1.3.0", (String)"/wms:WMS_Capabilities/@version", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.0.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1.1.1", (String)"/WMT_MS_Capabilities/@version", (Document)dom);
    }

    @Test
    public void testRequestOptionalFormatParameter() throws Exception {
        String path = "ows?service=WMS&request=GetCapabilities&version=1.3.0";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)this.getAsDOM(path).getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"text/xml", (Object)response.getContentType());
        path = "ows?service=WMS&request=GetCapabilities&version=1.3.0&format=text/xml";
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)this.getAsDOM(path).getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"text/xml", (Object)response.getContentType());
        path = "ows?service=WMS&request=GetCapabilities&version=1.3.0&format=application/unsupported";
        response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)this.getAsDOM(path).getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"text/xml", (Object)response.getContentType());
    }

    @Test
    public void testRequestMandatoryServiceParameter() throws Exception {
        Document dom = this.getAsDOM("ows?request=GetCapabilities&version=1.3.0");
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"/ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    @Test
    public void testRequestMandatoryRequestParameter() throws Exception {
        Document dom = this.getAsDOM("ows?request=GetCapabilities&version=1.3.0");
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"/ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    @Test
    public void testRequestUpdateSequence() throws Exception {
        Document dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String locationPath = "/wms:WMS_Capabilities/@updateSequence";
        String updateSeq = xpath.evaluate("/wms:WMS_Capabilities/@updateSequence", dom);
        int currUpdateSeq = Integer.parseInt(updateSeq);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0");
        XMLAssert.assertXpathEvaluatesTo((String)updateSeq, (String)"/wms:WMS_Capabilities/@updateSequence", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0&updateSequence=" + updateSeq);
        XMLAssert.assertXpathEvaluatesTo((String)"1.3.0", (String)"/ogc:ServiceExceptionReport/@version", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CurrentUpdateSequence", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0&updateSequence=" + (currUpdateSeq - 1));
        XMLAssert.assertXpathEvaluatesTo((String)updateSeq, (String)"/wms:WMS_Capabilities/@updateSequence", (Document)dom);
        dom = this.getAsDOM("ows?service=WMS&request=GetCapabilities&version=1.3.0&updateSequence=" + (currUpdateSeq + 1));
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidUpdateSequence", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCiteCompliant() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.setCiteCompliant(true);
        gs.save((ServiceInfo)wms);
        try {
            Document dom = this.getAsDOM("wms?service=WMS&request=GetCapabilities");
            Assert.assertEquals((Object)"WMS_Capabilities", (Object)dom.getDocumentElement().getNodeName());
            dom = this.getAsDOM("wms?request=GetCapabilities&version=1.3.0");
            this.checkLegacyException(dom, "MissingParameterValue", "service");
            String testWorkspace = "wcs";
            dom = this.getAsDOM("wcs/wms?request=GetCapabilities&version=1.3.0");
            this.checkLegacyException(dom, "MissingParameterValue", "service");
            dom = this.getAsDOM("wcs/wms/?request=GetCapabilities&version=1.3.0");
            this.checkLegacyException(dom, "MissingParameterValue", "service");
        }
        finally {
            wms.setCiteCompliant(false);
            gs.save((ServiceInfo)wms);
        }
    }

    @Test
    public void testCRSList() throws Exception {
        Document dom = this.getAsDOM("wms?request=GetCapabilities&version=1.3.0");
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='CRS:84']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='EPSG:4326']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='EPSG:32632']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='EPSG:900913']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='EPSG:404000']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='AUTO:42001']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='AUTO:42002']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='AUTO:42003']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='AUTO:42004']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:CRS[text()='IAU:1000']", (Document)dom);
    }

    @Test
    public void testMarsLayers() throws Exception {
        Document dom = this.getAsDOM("iau/wms?request=GetCapabilities&version=1.3.0&service=WMS");
        this.print(dom);
        XMLAssert.assertXpathExists((String)"//wms:Layer[wms:Name='Viking' and wms:CRS = 'IAU:49900']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:Layer[wms:Name='Viking']/wms:BoundingBox[@CRS='IAU:49900']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:Layer[wms:Name='MarsPoi' and wms:CRS = 'IAU:49900']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wms:Layer[wms:Name='MarsPoi']/wms:BoundingBox[@CRS='IAU:49900']", (Document)dom);
    }
}

