/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.decorate.AbstractDecorator;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CapabilitiesIntegrationTest
extends WMSTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        DataStoreInfo info = catalog.getDataStoreByName(MockData.SF_PREFIX);
        info.setEnabled(false);
        catalog.save((StoreInfo)info);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        WorkspaceInfo ws = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        testData.addStyle(ws, "Lakes", "Lakes.sld", SystemTestData.class, catalog);
        StyleInfo lakesStyle = catalog.getStyleByName(ws, "Lakes");
        LayerInfo lakesLayer = catalog.getLayerByName(MockData.LAKES.getLocalPart());
        lakesLayer.setDefaultStyle(lakesStyle);
        catalog.save(lakesLayer);
        this.setupOpaqueGroup(catalog);
    }

    @Override
    protected void registerNamespaces(Map<String, String> namespaces) {
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
    }

    @Test
    public void testCapabilities() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)e.getLocalName());
    }

    @Test
    public void testCapabilitiesNoWGS84DD() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathNotExists((String)"//wms:CRS[text() = 'EPSG:WGS84(DD)']", (Document)dom);
    }

    @Test
    public void testGetCapsContainsNoDisabledTypes() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Name[text()='sf:PrimitiveGeoFeature'])", (Document)doc);
    }

    @Test
    public void testFilteredCapabilitiesCite() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0&namespace=cite"), true);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wms:Layer/wms:Name[starts-with(., cite)]", dom).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wms:Layer/wms:Name[not(starts-with(., cite))]", dom).getLength());
    }

    @Test
    public void testLayerCount() throws Exception {
        int expectedLayerCount = this.getRawTopLayerCount();
        Document dom = this.dom(this.get("wms?request=GetCapabilities&version=1.3.0"), true);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        NodeList nodeLayers = xpath.getMatchingNodes("/wms:WMS_Capabilities/wms:Capability/wms:Layer/wms:Layer", dom);
        Assert.assertEquals((long)expectedLayerCount, (long)nodeLayers.getLength());
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Document dom = this.dom(this.get("cite/wms?request=getCapabilities&version=1.3.0"), true);
        this.print(dom);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wms:Layer/wms:Name[starts-with(., cite)]", dom).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wms:Layer/wms:Name[not(starts-with(., cite))]", dom).getLength());
        NodeList nodes = xpath.getMatchingNodes("//wms:Layer//wms:OnlineResource", dom);
        Assert.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            String attribute = e.getAttribute("xlink:href");
            Assert.assertTrue((boolean)attribute.contains("geoserver/cite/ows"));
        }
    }

    @Test
    public void testLayerQualified() throws Exception {
        Document dom = this.dom(this.get("cite/Forests/wms?service=WMS&request=getCapabilities&version=1.3.0"), true);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wms:Layer/wms:Name[starts-with(., 'cite:Forests')]", dom).getLength());
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wms:Layer/wms:Layer", dom).getLength());
        NodeList nodes = xpath.getMatchingNodes("//wms:Layer//wms:OnlineResource", dom);
        Assert.assertTrue((nodes.getLength() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            String attribute = e.getAttribute("xlink:href");
            Assert.assertTrue((boolean)attribute.contains("geoserver/cite/Forests/ows"));
        }
    }

    @Test
    public void testAttribution() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Attribution)", (Document)doc);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        AttributionInfo attr = points.getAttribution();
        attr.setTitle("Point Provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:Title)", (Document)doc);
        attr = points.getAttribution();
        attr.setHref("http://example.com/points/provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:OnlineResource)", (Document)doc);
        attr = points.getAttribution();
        attr.setLogoURL("http://example.com/points/logo");
        attr.setLogoType("image/logo");
        attr.setLogoHeight(50);
        attr.setLogoWidth(50);
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Attribution/wms:LogoURL)", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroup() throws Exception {
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo lg = this.getCatalog().getFactory().createLayerGroup();
        lg.setName("MyLayerGroup");
        lg.getLayers().add(points);
        lg.getStyles().add(null);
        builder.calculateLayerGroupBounds(lg, CRS.decode((String)"EPSG:4326"));
        lg.setAttribution(this.getCatalog().getFactory().createAttribution());
        lg.getAttribution().setTitle("My Attribution");
        MetadataLinkInfo info = this.getCatalog().getFactory().createMetadataLink();
        info.setType("text/html");
        info.setMetadataType("FGDC");
        info.setContent("http://my/metadata/link");
        lg.getMetadataLinks().add(info);
        this.getCatalog().add(lg);
        this.addKeywordsToLayerGroup("MyLayerGroup");
        try {
            Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='MyLayerGroup']/wms:Attribution)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"My Attribution", (String)"//wms:Layer[wms:Name='MyLayerGroup']/wms:Attribution/wms:Title", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='MyLayerGroup']/wms:MetadataURL)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"http://my/metadata/link", (String)"//wms:Layer[wms:Name='MyLayerGroup']/wms:MetadataURL/wms:OnlineResource/@xlink:href", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wms:Layer[wms:Name='MyLayerGroup']/wms:KeywordList/wms:Keyword)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"keyword1", (String)"//wms:Layer[wms:Name='MyLayerGroup']/wms:KeywordList/wms:Keyword[@vocabulary='vocabulary1']", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"keyword2", (String)"//wms:Layer[wms:Name='MyLayerGroup']/wms:KeywordList/wms:Keyword[@vocabulary='vocabulary2']", (Document)doc);
        }
        finally {
            this.getCatalog().remove(lg);
        }
    }

    @Test
    public void testAlternateStyles() throws Exception {
        StyleInfo pointStyle = this.getCatalog().getStyleByName("point");
        LayerInfo layer = this.getCatalog().getLayerByName("Fifteen");
        layer.getStyles().add(pointStyle);
        this.getCatalog().save(layer);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='cdf:Fifteen'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wms:Layer[wms:Name='cdf:Fifteen']/wms:Style)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String href = xpath.evaluate("//wms:Layer[wms:Name='cdf:Fifteen']/wms:Style[wms:Name='Default']/wms:LegendURL/wms:OnlineResource/@xlink:href", doc);
        Assert.assertTrue((boolean)href.contains("GetLegendGraphic"));
        Assert.assertTrue((boolean)href.contains("layer=cdf%3AFifteen"));
        Assert.assertFalse((boolean)href.contains("style"));
        href = xpath.evaluate("//wms:Layer[wms:Name='cdf:Fifteen']/wms:Style[wms:Name='point']/wms:LegendURL/wms:OnlineResource/@xlink:href", doc);
        Assert.assertTrue((boolean)href.contains("GetLegendGraphic"));
        Assert.assertTrue((boolean)href.contains("layer=cdf%3AFifteen"));
        Assert.assertTrue((boolean)href.contains("style=point"));
        layer.setDefaultStyle(pointStyle);
        this.getCatalog().save(layer);
        Document document = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='cdf:Fifteen'])", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='cdf:Fifteen']/wms:Style)", (Document)document);
        Assert.assertTrue((boolean)layer.getStyles().contains(pointStyle));
        Assert.assertFalse((boolean)layer.styles().contains(pointStyle));
    }

    @Test
    public void testServiceMetadata() throws Exception {
        WMSInfo service = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        service.setTitle("test title");
        service.setAbstract("test abstract");
        service.setAccessConstraints("test accessConstraints");
        service.setFees("test fees");
        service.getKeywords().clear();
        service.getKeywords().add(new Keyword("test keyword 1"));
        service.getKeywords().add(new Keyword("test keyword 2"));
        service.setMaintainer("test maintainer");
        service.setOnlineResource("http://example.com/geoserver");
        GeoServerInfo global = this.getGeoServer().getGlobal();
        ContactInfo contact = global.getSettings().getContact();
        contact.setAddress("__address");
        contact.setAddressCity("__city");
        contact.setAddressCountry("__country");
        contact.setAddressPostalCode("__ZIP");
        contact.setAddressState("__state");
        contact.setAddressType("__type");
        contact.setContactEmail("e@mail");
        contact.setContactOrganization("__org");
        contact.setContactFacsimile("__fax");
        contact.setContactPerson("__me");
        contact.setContactPosition("__position");
        contact.setContactVoice("__phone");
        this.getGeoServer().save(global);
        this.getGeoServer().save((ServiceInfo)service);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        String base = "wms:WMS_Capabilities/wms:Service/";
        XMLAssert.assertXpathEvaluatesTo((String)"WMS", (String)(base + "wms:Name"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test title", (String)(base + "wms:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test abstract", (String)(base + "wms:Abstract"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test keyword 1", (String)(base + "wms:KeywordList/wms:Keyword[1]"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"test keyword 2", (String)(base + "wms:KeywordList/wms:Keyword[2]"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://example.com/geoserver", (String)(base + "wms:OnlineResource/@xlink:href"), (Document)doc);
        String cinfo = base + "wms:ContactInformation/";
        XMLAssert.assertXpathEvaluatesTo((String)"__me", (String)(cinfo + "wms:ContactPersonPrimary/wms:ContactPerson"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__org", (String)(cinfo + "wms:ContactPersonPrimary/wms:ContactOrganization"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__position", (String)(cinfo + "wms:ContactPosition"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__type", (String)(cinfo + "wms:ContactAddress/wms:AddressType"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__address", (String)(cinfo + "wms:ContactAddress/wms:Address"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__city", (String)(cinfo + "wms:ContactAddress/wms:City"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__state", (String)(cinfo + "wms:ContactAddress/wms:StateOrProvince"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__ZIP", (String)(cinfo + "wms:ContactAddress/wms:PostCode"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__country", (String)(cinfo + "wms:ContactAddress/wms:Country"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__phone", (String)(cinfo + "wms:ContactVoiceTelephone"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"__fax", (String)(cinfo + "wms:ContactFacsimileTelephone"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"e@mail", (String)(cinfo + "wms:ContactElectronicMailAddress"), (Document)doc);
    }

    @Test
    public void testNoFeesOrContraints() throws Exception {
        WMSInfo service = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        service.setAccessConstraints(null);
        service.setFees(null);
        this.getGeoServer().save((ServiceInfo)service);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        String base = "wms:WMS_Capabilities/wms:Service/";
        XMLAssert.assertXpathEvaluatesTo((String)"WMS", (String)(base + "wms:Name"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"none", (String)(base + "wms:Fees"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"none", (String)(base + "wms:AccessConstraints"), (Document)doc);
    }

    @Test
    public void testExceptions() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"XML", (String)"wms:WMS_Capabilities/wms:Capability/wms:Exception/wms:Format[1]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"INIMAGE", (String)"wms:WMS_Capabilities/wms:Capability/wms:Exception/wms:Format[2]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"BLANK", (String)"wms:WMS_Capabilities/wms:Capability/wms:Exception/wms:Format[3]", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"JSON", (String)"wms:WMS_Capabilities/wms:Capability/wms:Exception/wms:Format[4]", (Document)doc);
        boolean jsonpOriginal = JSONType.isJsonpEnabled();
        try {
            JSONType.setJsonpEnabled((boolean)true);
            doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            XMLAssert.assertXpathEvaluatesTo((String)"JSONP", (String)"wms:WMS_Capabilities/wms:Capability/wms:Exception/wms:Format[5]", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(wms:WMS_Capabilities/wms:Capability/wms:Exception/wms:Format)", (Document)doc);
            JSONType.setJsonpEnabled((boolean)false);
            doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(wms:WMS_Capabilities/wms:Capability/wms:Exception/wms:Format)", (Document)doc);
        }
        finally {
            JSONType.setJsonpEnabled((boolean)jsonpOriginal);
        }
    }

    @Test
    public void testQueryable() throws Exception {
        LayerInfo lines = this.getCatalog().getLayerByName(MockData.LINES.getLocalPart());
        lines.setQueryable(true);
        this.getCatalog().save(lines);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        points.setQueryable(false);
        this.getCatalog().save(points);
        String linesName = MockData.LINES.getPrefix() + ":" + MockData.LINES.getLocalPart();
        String pointsName = MockData.POINTS.getPrefix() + ":" + MockData.POINTS.getLocalPart();
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("//wms:Layer[wms:Name='" + linesName + "']/@queryable"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("//wms:Layer[wms:Name='" + pointsName + "']/@queryable"), (Document)doc);
    }

    @Test
    public void testOpaque() throws Exception {
        LayerInfo lines = this.getCatalog().getLayerByName(MockData.LINES.getLocalPart());
        lines.setOpaque(true);
        this.getCatalog().save(lines);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        points.setOpaque(false);
        this.getCatalog().save(points);
        String linesName = MockData.LINES.getPrefix() + ":" + MockData.LINES.getLocalPart();
        String pointsName = MockData.POINTS.getPrefix() + ":" + MockData.POINTS.getLocalPart();
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("//wms:Layer[wms:Name='" + linesName + "']/@opaque"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("//wms:Layer[wms:Name='" + pointsName + "']/@opaque"), (Document)doc);
    }

    @Test
    public void testKeywordVocab() throws Exception {
        FeatureTypeInfo lines = this.getFeatureTypeInfo(MockData.LINES);
        Keyword kw = new Keyword("foo");
        kw.setVocabulary("bar");
        lines.getKeywords().add(kw);
        this.getCatalog().save((ResourceInfo)lines);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        kw = new Keyword("baz");
        kw.setVocabulary("bar");
        wms.getKeywords().add(kw);
        this.getGeoServer().save((ServiceInfo)wms);
        String linesName = MockData.LINES.getPrefix() + ":" + MockData.LINES.getLocalPart();
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        Object xpath = "//wms:Layer[wms:Name='" + linesName + "']/wms:KeywordList/wms:Keyword[@vocabulary='bar']";
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"foo", (String)xpath, (Document)doc);
        xpath = "//wms:Service/wms:KeywordList/wms:Keyword[@vocabulary='bar']";
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"baz", (String)xpath, (Document)doc);
    }

    @Test
    public void testBoundingBoxCRS84() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathExists((String)"/wms:WMS_Capabilities/wms:Capability/wms:Layer/wms:BoundingBox[@CRS = 'CRS:84']", (Document)doc);
        XMLAssert.assertXpathExists((String)"/wms:WMS_Capabilities/wms:Capability/wms:Layer//wms:Layer/wms:BoundingBox[@CRS = 'CRS:84']", (Document)doc);
    }

    @Test
    public void testMetadataLinks() throws Exception {
        String layerName = MockData.POINTS.getPrefix() + ":" + MockData.POINTS.getLocalPart();
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        MetadataLinkInfo mdlink = this.getCatalog().getFactory().createMetadataLink();
        mdlink.setMetadataType("FGDC");
        mdlink.setContent("http://geoserver.org");
        mdlink.setType("text/xml");
        ResourceInfo resource = layer.getResource();
        resource.getMetadataLinks().add(mdlink);
        this.getCatalog().save(resource);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        String xpath = "//wms:Layer[wms:Name='" + layerName + "']/wms:MetadataURL/wms:Format";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml", (String)xpath, (Document)doc);
        xpath = "//wms:Layer[wms:Name='" + layerName + "']/wms:MetadataURL/@type";
        XMLAssert.assertXpathEvaluatesTo((String)"FGDC", (String)xpath, (Document)doc);
        xpath = "//wms:Layer[wms:Name='" + layerName + "']/wms:MetadataURL/wms:OnlineResource/@xlink:type";
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)xpath, (Document)doc);
        xpath = "//wms:Layer[wms:Name='" + layerName + "']/wms:MetadataURL/wms:OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org", (String)xpath, (Document)doc);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        String proxyBaseUrl = global.getSettings().getProxyBaseUrl();
        mdlink.setContent("/metadata");
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata"), (String)xpath, (Document)doc);
        String query = "key=value";
        mdlink.setContent("/metadata?" + query);
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata?" + query), (String)xpath, (Document)doc);
        mdlink.setContent("http://localhost/metadata?" + query);
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)("http://localhost/metadata?" + query), (String)xpath, (Document)doc);
    }

    @Test
    public void testDataLinks() throws Exception {
        String layerName = MockData.POINTS.getPrefix() + ":" + MockData.POINTS.getLocalPart();
        LayerInfo layer = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        DataLinkInfo mdlink = this.getCatalog().getFactory().createDataLink();
        mdlink.setContent("http://geoserver.org");
        mdlink.setType("text/xml");
        ResourceInfo resource = layer.getResource();
        resource.getDataLinks().add(mdlink);
        this.getCatalog().save(resource);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        String xpath = "//wms:Layer[wms:Name='" + layerName + "']/wms:DataURL/wms:Format";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml", (String)xpath, (Document)doc);
        xpath = "//wms:Layer[wms:Name='" + layerName + "']/wms:DataURL/wms:OnlineResource/@xlink:type";
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)xpath, (Document)doc);
        xpath = "//wms:Layer[wms:Name='" + layerName + "']/wms:DataURL/wms:OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org", (String)xpath, (Document)doc);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        String proxyBaseUrl = global.getSettings().getProxyBaseUrl();
        mdlink.setContent("/metadata");
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata"), (String)xpath, (Document)doc);
        String query = "key=value";
        mdlink.setContent("/metadata?" + query);
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata?" + query), (String)xpath, (Document)doc);
        mdlink.setContent("http://localhost/metadata?" + query);
        this.getCatalog().save(resource);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)("http://localhost/metadata?" + query), (String)xpath, (Document)doc);
    }

    @Test
    public void testOpenlayersFormat() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:GetMap[wms:Format = 'text/html; subtype=openlayers'])", (Document)doc);
    }

    @Test
    public void testStyleWorkspaceQualified() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XMLAssert.assertXpathEvaluatesTo((String)"cite:Lakes", (String)"//wms:Layer[wms:Name='cite:Lakes']/wms:Style[1]/wms:Name", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateLayerGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        lakes.setAdvertised(false);
        catalog.save(lakes);
        try {
            Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='nature'])", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Title='containerGroup']/wms:Layer[wms:Name='nature'])", (Document)doc);
        }
        finally {
            lakes.setAdvertised(true);
            catalog.save(lakes);
        }
    }

    @Test
    public void testOpaqueGroup() throws Exception {
        Document dom = this.dom(this.get("wms?request=GetCapabilities&version=1.3.0"), true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='opaqueGroup'])", (Document)dom);
        for (LayerInfo l : this.getCatalog().getLayerGroupByName("opaqueGroup").layers()) {
            XMLAssert.assertXpathNotExists((String)("//wms:Layer[wms:Name='" + l.prefixedName() + "']"), (Document)dom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedGroupInOpaqueGroup() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo container = catalog.getLayerGroupByName("containerGroup");
        LayerGroupInfo opaque = catalog.getLayerGroupByName("opaqueGroup");
        opaque.getLayers().add(container);
        opaque.getStyles().add(null);
        catalog.save(opaque);
        try {
            Document dom = this.getAsDOM("wms?request=GetCapabilities&version=1.3.0");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='opaqueGroup'])", (Document)dom);
            for (PublishedInfo p : this.getCatalog().getLayerGroupByName("opaqueGroup").getLayers()) {
                XMLAssert.assertXpathNotExists((String)("//wms:Layer[wms:Name='" + p.prefixedName() + "']"), (Document)dom);
            }
            List nestedLayers = new LayerGroupHelper(container).allLayers();
            int expectedLayerCount = this.getRawTopLayerCount() - nestedLayers.size() - 1;
            XpathEngine xpath = XMLUnit.newXpathEngine();
            NodeList nodeLayers = xpath.getMatchingNodes("/wms:WMS_Capabilities/wms:Capability/wms:Layer/wms:Layer", dom);
            Assert.assertEquals((long)expectedLayerCount, (long)nodeLayers.getLength());
        }
        finally {
            opaque.getLayers().remove(container);
            opaque.getStyles().remove(opaque.getStyles().size() - 1);
            catalog.save(opaque);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalBoundingBoxForLayerGroups() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
        workspace.setName("NON_ADVERTISED");
        NamespaceInfoImpl nameSpace = new NamespaceInfoImpl();
        nameSpace.setPrefix("NON_ADVERTISED");
        nameSpace.setURI("http://non-advertised.org");
        List<LayerGroupInfo> layerGroups = catalog.getLayerGroups().stream().map(this::unwrapLayerGroup).collect(Collectors.toList());
        catalog.getLayerGroups().forEach(arg_0 -> ((Catalog)catalog).remove(arg_0));
        try {
            catalog.add((WorkspaceInfo)workspace);
            catalog.add((NamespaceInfo)nameSpace);
            LayerInfo layer1 = this.cloneVectorLayerIntoWorkspace((WorkspaceInfo)workspace, (NamespaceInfo)nameSpace, MockData.BUILDINGS.getLocalPart());
            LayerInfo layer2 = this.cloneVectorLayerIntoWorkspace((WorkspaceInfo)workspace, (NamespaceInfo)nameSpace, MockData.BRIDGES.getLocalPart());
            LayerGroupInfo layerGroup = this.createLayerGroup((WorkspaceInfo)workspace, "NON_ADVERTISED", layer1, layer2);
            ReferencedEnvelope layersBounds = layerGroup.getBounds();
            ReferencedEnvelope layerGroupBounds = new ReferencedEnvelope(-10.0, 10.0, -20.0, 20.0, layersBounds.getCoordinateReferenceSystem());
            layerGroup.setBounds(layerGroupBounds);
            catalog.save(layerGroup);
            Document document = this.getAsDOM("NON_ADVERTISED/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            this.checkGlobalBoundingBox(layersBounds, document);
            layer1.setAdvertised(false);
            layer2.setAdvertised(false);
            catalog.save(layer1);
            catalog.save(layer2);
            document = this.getAsDOM("NON_ADVERTISED/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            this.checkGlobalBoundingBox(layerGroupBounds, document);
        }
        finally {
            layerGroups.forEach(arg_0 -> ((Catalog)catalog).add(arg_0));
            CascadeDeleteVisitor deleteVisitor = new CascadeDeleteVisitor(catalog);
            deleteVisitor.visit((WorkspaceInfo)workspace);
            catalog.remove((NamespaceInfo)nameSpace);
            catalog.remove((WorkspaceInfo)workspace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupsPerWorkspace() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfoImpl workspaceA = new WorkspaceInfoImpl();
        workspaceA.setName("LG_TEST_WORKSPACE_A");
        NamespaceInfoImpl nameSpaceA = new NamespaceInfoImpl();
        nameSpaceA.setPrefix("LG_TEST_WORKSPACE_A");
        nameSpaceA.setURI("http://lg-test-workspace-a.org");
        WorkspaceInfoImpl workspaceB = new WorkspaceInfoImpl();
        workspaceB.setName("LG_TEST_WORKSPACE_B");
        NamespaceInfoImpl nameSpaceB = new NamespaceInfoImpl();
        nameSpaceB.setPrefix("LG_TEST_WORKSPACE_B");
        nameSpaceB.setURI("http://lg-test-workspace-b.org");
        LayerGroupInfo globalLayerGroup = null;
        try {
            catalog.add((WorkspaceInfo)workspaceA);
            catalog.add((NamespaceInfo)nameSpaceA);
            catalog.add((WorkspaceInfo)workspaceB);
            catalog.add((NamespaceInfo)nameSpaceB);
            this.createLayerGroup((WorkspaceInfo)workspaceA, "LAYER_GROUP_A", this.cloneVectorLayerIntoWorkspace((WorkspaceInfo)workspaceA, (NamespaceInfo)nameSpaceA, MockData.BUILDINGS.getLocalPart()), this.cloneVectorLayerIntoWorkspace((WorkspaceInfo)workspaceA, (NamespaceInfo)nameSpaceA, MockData.BRIDGES.getLocalPart()));
            this.createLayerGroup((WorkspaceInfo)workspaceB, "LAYER_GROUP_B", this.cloneVectorLayerIntoWorkspace((WorkspaceInfo)workspaceB, (NamespaceInfo)nameSpaceB, MockData.BUILDINGS.getLocalPart()), this.cloneVectorLayerIntoWorkspace((WorkspaceInfo)workspaceB, (NamespaceInfo)nameSpaceB, MockData.BRIDGES.getLocalPart()));
            globalLayerGroup = this.createLayerGroup("LAYER_GROUP_C", catalog.getLayerByName(MockData.BUILDINGS.getLocalPart()), catalog.getLayerByName(MockData.BRIDGES.getLocalPart()));
            Document document = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LG_TEST_WORKSPACE_A:LAYER_GROUP_A'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LG_TEST_WORKSPACE_B:LAYER_GROUP_B'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_A'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_B'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_C'])", (Document)document);
            document = this.getAsDOM("LG_TEST_WORKSPACE_A/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LG_TEST_WORKSPACE_A:LAYER_GROUP_A'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LG_TEST_WORKSPACE_B:LAYER_GROUP_B'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_A'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_B'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_C'])", (Document)document);
            document = this.getAsDOM("LG_TEST_WORKSPACE_B/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LG_TEST_WORKSPACE_A:LAYER_GROUP_A'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LG_TEST_WORKSPACE_B:LAYER_GROUP_B'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_A'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_B'])", (Document)document);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Capability/wms:Layer/wms:Layer[wms:Name='LAYER_GROUP_C'])", (Document)document);
        }
        catch (Throwable throwable) {
            CascadeDeleteVisitor deleteVisitor = new CascadeDeleteVisitor(catalog);
            deleteVisitor.visit((WorkspaceInfo)workspaceA);
            catalog.remove((NamespaceInfo)nameSpaceA);
            catalog.remove((WorkspaceInfo)workspaceA);
            deleteVisitor.visit((WorkspaceInfo)workspaceB);
            catalog.remove((NamespaceInfo)nameSpaceB);
            catalog.remove((WorkspaceInfo)workspaceB);
            if (globalLayerGroup != null) {
                catalog.remove(globalLayerGroup);
            }
            throw throwable;
        }
        CascadeDeleteVisitor deleteVisitor = new CascadeDeleteVisitor(catalog);
        deleteVisitor.visit((WorkspaceInfo)workspaceA);
        catalog.remove((NamespaceInfo)nameSpaceA);
        catalog.remove((WorkspaceInfo)workspaceA);
        deleteVisitor.visit((WorkspaceInfo)workspaceB);
        catalog.remove((NamespaceInfo)nameSpaceB);
        catalog.remove((WorkspaceInfo)workspaceB);
        if (globalLayerGroup != null) {
            catalog.remove(globalLayerGroup);
        }
    }

    @Test
    public void testDefaultAbstract() throws Exception {
        Document dom = this.getAsDOM("wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        Element el = this.findAbstractForLayerWithName(CiteTestData.BASIC_POLYGONS.getLocalPart(), dom);
        Assert.assertNotNull((Object)el);
        Assert.assertNotNull((Object)el.getFirstChild());
        Assert.assertEquals((Object)this.getCatalog().getLayerByName(CiteTestData.BASIC_POLYGONS.getLocalPart()).getAbstract(), (Object)el.getFirstChild().getNodeValue());
        el = this.findAbstractForLayerWithName(CiteTestData.TASMANIA_BM.getLocalPart(), dom);
        Assert.assertNotNull((Object)el);
        Assert.assertNull((Object)el.getFirstChild());
    }

    private Element findAbstractForLayerWithName(String name, Document dom) {
        NodeList nodeList = dom.getElementsByTagName("Layer");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element el;
            Element title;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !node.getLocalName().equals("Layer") || (title = this.getFirstElementByTagName(el = (Element)node, "Title")) == null || title.getFirstChild() == null || !name.equals(title.getFirstChild().getTextContent())) continue;
            return this.getFirstElementByTagName(el, "Abstract");
        }
        return null;
    }

    private void checkGlobalBoundingBox(ReferencedEnvelope expectedBoundingBox, Document capabilitiesResult) throws Exception {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String minX = xpath.evaluate("//wms:Capability/wms:Layer/wms:EX_GeographicBoundingBox/wms:westBoundLongitude/text()", capabilitiesResult);
        String maxX = xpath.evaluate("//wms:Capability/wms:Layer/wms:EX_GeographicBoundingBox/wms:eastBoundLongitude/text()", capabilitiesResult);
        String minY = xpath.evaluate("//wms:Capability/wms:Layer/wms:EX_GeographicBoundingBox/wms:southBoundLatitude/text()", capabilitiesResult);
        String maxY = xpath.evaluate("//wms:Capability/wms:Layer/wms:EX_GeographicBoundingBox/wms:northBoundLatitude/text()", capabilitiesResult);
        CapabilitiesIntegrationTest.checkNumberSimilar(minX, expectedBoundingBox.getMinX(), 1.0E-4);
        CapabilitiesIntegrationTest.checkNumberSimilar(maxX, expectedBoundingBox.getMaxX(), 1.0E-4);
        CapabilitiesIntegrationTest.checkNumberSimilar(minY, expectedBoundingBox.getMinY(), 1.0E-4);
        CapabilitiesIntegrationTest.checkNumberSimilar(maxY, expectedBoundingBox.getMaxY(), 1.0E-4);
    }

    private LayerGroupInfo unwrapLayerGroup(LayerGroupInfo layerGroup) {
        while (layerGroup instanceof AbstractDecorator) {
            AbstractDecorator decorator = (AbstractDecorator)layerGroup;
            layerGroup = this.unwrap(decorator);
        }
        if (Proxy.isProxyClass(layerGroup.getClass())) {
            ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(layerGroup);
            proxy.commit();
            layerGroup = (LayerGroupInfo)proxy.getProxyObject();
        }
        return layerGroup;
    }

    private LayerGroupInfo unwrap(AbstractDecorator decorator) {
        return (LayerGroupInfo)decorator.unwrap(LayerGroupInfo.class);
    }

    private LayerGroupInfo createLayerGroup(String layerGroupName, LayerInfo ... layers) throws Exception {
        return this.createLayerGroup(null, layerGroupName, layers);
    }

    private LayerGroupInfo createLayerGroup(WorkspaceInfo workspace, String layerGroupName, LayerInfo ... layers) throws Exception {
        LayerGroupInfo layerGroup = this.getCatalog().getFactory().createLayerGroup();
        layerGroup.setName(layerGroupName);
        layerGroup.setWorkspace(workspace);
        for (LayerInfo layerInfo : layers) {
            layerGroup.getLayers().add(layerInfo);
            layerGroup.getStyles().add(null);
        }
        CatalogBuilder catalogBuilder = new CatalogBuilder(this.getCatalog());
        catalogBuilder.calculateLayerGroupBounds(layerGroup);
        this.getCatalog().add(layerGroup);
        if (workspace == null) {
            return this.getCatalog().getLayerGroupByName(layerGroupName);
        }
        return this.getCatalog().getLayerGroupByName(workspace, layerGroupName);
    }
}

