/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.util.Map;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.featureinfo.TextFeatureInfoOutputFormat;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CapabilitiesAllowedMimeTypesTest
extends WMSTestSupport {
    GetMapOutputFormat getMapFormat;
    GetFeatureInfoOutputFormat getInfoFormat;

    @Override
    protected void registerNamespaces(Map<String, String> namespaces) {
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
    }

    void addMimeTypes() {
        this.getMapFormat = new RenderedImageMapOutputFormat(this.getWMS());
        this.getInfoFormat = new TextFeatureInfoOutputFormat(this.getWMS());
        WMSInfo wms = this.getWMS().getServiceInfo();
        wms.getGetMapMimeTypes().add(this.getMapFormat.getMimeType());
        wms.getGetFeatureInfoMimeTypes().add(this.getInfoFormat.getContentType());
        wms.setGetMapMimeTypeCheckingEnabled(true);
        wms.setGetFeatureInfoMimeTypeCheckingEnabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
    }

    @After
    public void removeMimeTypes() {
        WMSInfo wms = this.getWMS().getServiceInfo();
        wms.getGetMapMimeTypes().clear();
        wms.getGetFeatureInfoMimeTypes().clear();
        wms.setGetMapMimeTypeCheckingEnabled(false);
        wms.setGetFeatureInfoMimeTypeCheckingEnabled(false);
        this.getGeoServer().save((ServiceInfo)wms);
    }

    @Test
    public void testAllowedMimeTypes() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        NodeList formatNodes = xpath.getMatchingNodes("wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetMap/wms:Format", doc);
        Assert.assertTrue((formatNodes.getLength() > 1 ? 1 : 0) != 0);
        formatNodes = xpath.getMatchingNodes("/wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetFeatureInfo/wms:Format", doc);
        Assert.assertTrue((formatNodes.getLength() > 1 ? 1 : 0) != 0);
        this.addMimeTypes();
        doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        formatNodes = xpath.getMatchingNodes("wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetMap/wms:Format", doc);
        Assert.assertEquals((long)1L, (long)formatNodes.getLength());
        Assert.assertEquals((Object)this.getMapFormat.getMimeType(), (Object)formatNodes.item(0).getTextContent());
        formatNodes = xpath.getMatchingNodes("/wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetFeatureInfo/wms:Format", doc);
        Assert.assertEquals((long)1L, (long)formatNodes.getLength());
        Assert.assertEquals((Object)this.getInfoFormat.getContentType(), (Object)formatNodes.item(0).getTextContent());
        this.removeMimeTypes();
        doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.3.0", true);
        formatNodes = xpath.getMatchingNodes("wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetMap/wms:Format", doc);
        Assert.assertTrue((formatNodes.getLength() > 1 ? 1 : 0) != 0);
        formatNodes = xpath.getMatchingNodes("/wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetFeatureInfo/wms:Format", doc);
        Assert.assertTrue((formatNodes.getLength() > 1 ? 1 : 0) != 0);
    }
}

