/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.io.ByteArrayInputStream;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geoserver.wms.featureinfo.VectorRenderingLayerIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class DimensionsVectorGetFeatureInfoTest
extends WMSDimensionsTestSupport {
    String baseFeatureInfo;
    XpathEngine xpath;
    String baseFeatureInfoStacked;
    String baseFeatureInfoCustom;

    @After
    public void cleanup() {
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
    }

    @Before
    public void setXpahEngine() throws Exception {
        this.baseFeatureInfo = "wms?service=WMS&version=1.1.1&request=GetFeatureInfo&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&query_layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&feature_count=50";
        this.baseFeatureInfoStacked = "wms?service=WMS&version=1.1.1&request=GetFeatureInfo&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION_STACKED) + "&query_layers=" + this.getLayerId(this.V_TIME_ELEVATION_STACKED) + "&feature_count=1";
        this.baseFeatureInfoCustom = "wms?service=WMS&version=1.1.1&request=GetFeatureInfo&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&query_layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&feature_count=1";
        this.xpath = XMLUnit.newXpathEngine();
    }

    String getFeatureAt(String baseFeatureInfo, int x, int y) throws Exception {
        return this.getFeatureAt(baseFeatureInfo, x, y, "sf:TimeElevation");
    }

    String getFeatureAt(String baseFeatureInfo, int x, int y, String typeName) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(baseFeatureInfo + "&info_format=application/vnd.ogc.gml&x=" + x + "&y=" + y);
        Assert.assertEquals((Object)"application/vnd.ogc.gml", (Object)response.getContentType());
        Document doc = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        String sCount = this.xpath.evaluate("count(//" + typeName + ")", doc);
        int count = Integer.valueOf(sCount);
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return this.xpath.evaluate("//" + typeName + "/@fid", doc);
        }
        Assert.fail((String)("Found more than one feature: " + count));
        return null;
    }

    @Test
    public void testNoDimension() throws Exception {
        Assert.assertEquals((Object)"TimeElevation.0", (Object)this.getFeatureAt(this.baseFeatureInfo, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(this.baseFeatureInfo, 60, 10));
        Assert.assertEquals((Object)"TimeElevation.2", (Object)this.getFeatureAt(this.baseFeatureInfo, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(this.baseFeatureInfo, 60, 30));
    }

    @Test
    public void testElevationDefault() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Assert.assertEquals((Object)"TimeElevation.0", (Object)this.getFeatureAt(this.baseFeatureInfo, 20, 10));
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 20, 30));
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 60, 30));
    }

    @Test
    public void testElevationSingle() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        String base = this.baseFeatureInfo + "&elevation=1.0";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testElevationInvalid() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setExceptionsOnInvalidDimension(true);
        String base = this.baseFeatureInfo + "&elevation=-10";
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM(base + "&info_format=application/vnd.ogc.gml&x=20&y=10");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "elevation");
        Assert.assertEquals((Object)"Could not find a match for 'elevation' value: '-10'", (Object)message.trim());
    }

    @Test
    public void testElevationIgnoreInvalid() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setExceptionsOnInvalidDimension(true);
        String base = this.baseFeatureInfo + "&elevation=-10";
        this.setExceptionsOnInvalidDimension(false);
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 30));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testElevationInvalidBasicIdentifier() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setExceptionsOnInvalidDimension(true);
        String base = this.baseFeatureInfo + "&elevation=-10";
        this.setExceptionsOnInvalidDimension(true);
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        try {
            Document dom = this.getAsDOM(base + "&info_format=application/vnd.ogc.gml&x=20&y=10");
            String message = this.checkLegacyException(dom, "InvalidDimensionValue", "elevation");
            Assert.assertEquals((Object)"Could not find a match for 'elevation' value: '-10'", (Object)message.trim());
        }
        finally {
            VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
        }
    }

    @Test
    public void testElevationListMulti() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        String base = this.baseFeatureInfo + "&elevation=1.0,3.0";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testElevationListExtra() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        String base = this.baseFeatureInfo + "&elevation=1.0,3.0,5.0";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testElevationInterval() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        String base = this.baseFeatureInfo + "&elevation=1.0/3.0";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertEquals((Object)"TimeElevation.2", (Object)this.getFeatureAt(base, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testElevationIntervalResolution() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        String base = this.baseFeatureInfo + "&elevation=1.0/4.0/2.0";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testTimeDefault() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 20, 10));
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(this.baseFeatureInfo, 60, 30));
    }

    @Test
    public void testTimeCurrent() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=CURRENT";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testTimeSingle() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=2011-05-02";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testTimeSingleNoNearestIgnore() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=2011-05-02T012:00:00Z";
        this.setExceptionsOnInvalidDimension(false);
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testTimeSingleNoNearestException() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=2011-05-02T012:00:00Z";
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM(base + "&info_format=text/plain&x=20&y=10");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
        Assert.assertEquals((Object)"Could not find a match for 'time' value: '2011-05-02T012:00:00Z'", (Object)message.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeSingleNoNearestExceptionBasic() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=2011-05-02T012:00:00Z";
        this.setExceptionsOnInvalidDimension(true);
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        try {
            Document dom = this.getAsDOM(base + "&info_format=text/plain&x=20&y=10");
            String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
            Assert.assertEquals((Object)"Could not find a match for 'time' value: '2011-05-02T012:00:00Z'", (Object)message.trim());
        }
        finally {
            VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
        }
    }

    @Test
    public void testTimeSingleNearestClose() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true);
        String base = this.baseFeatureInfo + "&time=2011-05-02T01:00:00Z";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-02T00:00:00.000Z");
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-02T00:00:00.000Z");
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-02T00:00:00.000Z");
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 30));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-02T00:00:00.000Z");
    }

    @Test
    public void testTimeSingleNearestAfter() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true);
        String base = this.baseFeatureInfo + "&time=2013-05-02";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-04T00:00:00.000Z");
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 10));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-04T00:00:00.000Z");
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-04T00:00:00.000Z");
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-04T00:00:00.000Z");
    }

    @Test
    public void testTimeSingleNearestBefore() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true);
        String base = this.baseFeatureInfo + "&time=1190-05-02";
        Assert.assertEquals((Object)"TimeElevation.0", (Object)this.getFeatureAt(base, 20, 10));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-01T00:00:00.000Z");
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 10));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-01T00:00:00.000Z");
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-01T00:00:00.000Z");
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 30));
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-01T00:00:00.000Z");
    }

    @Test
    public void testTimeSingleNearestBeforeBasicIdentifier() throws Exception {
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        try {
            this.testTimeSingleNearestBefore();
        }
        finally {
            VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = true;
        }
    }

    @Test
    public void testTimeListMulti() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=2011-05-02,2011-05-04";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testTimeListExtra() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=2011-05-02,2011-05-04,2011-05-10";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testTimeInterval() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=2011-05-02/2011-05-05";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(base, 60, 10));
        Assert.assertEquals((Object)"TimeElevation.2", (Object)this.getFeatureAt(base, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(base, 60, 30));
    }

    @Ignore
    @Test
    public void testTimeIntervalResolution() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        String base = this.baseFeatureInfo + "&time=2011-05-01/2011-05-04/P2D";
        Assert.assertEquals((Object)"TimeElevation.0", (Object)this.getFeatureAt(base, 20, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 10));
        Assert.assertEquals((Object)"TimeElevation.2", (Object)this.getFeatureAt(base, 20, 30));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 30));
    }

    @Test
    public void testElevationDefaultAsRange() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("1/3");
        this.setupResourceDimensionDefaultValue(this.V_TIME_ELEVATION, "elevation", defaultValueSetting, "elevation");
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(this.baseFeatureInfo, 60, 10));
        Assert.assertEquals((Object)"TimeElevation.2", (Object)this.getFeatureAt(this.baseFeatureInfo, 20, 30));
        Assert.assertEquals((Object)"TimeElevation.3", (Object)this.getFeatureAt(this.baseFeatureInfo, 60, 30));
    }

    @Test
    public void testTimeDefaultAsRange() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("2011-05-02/2011-05-03");
        this.setupResourceDimensionDefaultValue(this.V_TIME_ELEVATION, "time", defaultValueSetting, "time");
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 20, 10));
        Assert.assertEquals((Object)"TimeElevation.1", (Object)this.getFeatureAt(this.baseFeatureInfo, 60, 10));
        Assert.assertEquals((Object)"TimeElevation.2", (Object)this.getFeatureAt(this.baseFeatureInfo, 20, 30));
        Assert.assertNull((Object)this.getFeatureAt(this.baseFeatureInfo, 60, 30));
    }

    @Test
    public void testSortTimeElevationAscending() throws Exception {
        Assert.assertEquals((Object)"TimeElevationStacked.3", (Object)this.getFeatureAt(this.baseFeatureInfoStacked + "&sortBy=time,elevation", 20, 10, "sf:TimeElevationStacked"));
    }

    @Test
    public void testSortTimeElevationDescending() throws Exception {
        Assert.assertEquals((Object)"TimeElevationStacked.0", (Object)this.getFeatureAt(this.baseFeatureInfoStacked + "&sortBy=time D,elevation D", 20, 10, "sf:TimeElevationStacked"));
    }

    @Test
    public void testSortTimeElevationAscendingLegacyIdentifier() throws Exception {
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        Assert.assertEquals((Object)"TimeElevationStacked.3", (Object)this.getFeatureAt(this.baseFeatureInfoStacked + "&sortBy=time,elevation", 20, 10, "sf:TimeElevationStacked"));
    }

    @Test
    public void testSortTimeElevationDescendingLegacyIdentifier() throws Exception {
        VectorRenderingLayerIdentifier.RENDERING_FEATUREINFO_ENABLED = false;
        Assert.assertEquals((Object)"TimeElevationStacked.0", (Object)this.getFeatureAt(this.baseFeatureInfoStacked + "&sortBy=time D,elevation D", 20, 10, "sf:TimeElevationStacked"));
    }

    @Test
    public void testCustomDimensionStringInvalidException() throws Exception {
        this.setupVectorDimension("dim_custom", "shared_key", DimensionPresentation.LIST, null, "foot", "ft");
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM(String.format("%s&info_format=text/plain&x=%d&y=%d&dim_custom=IAmNotThere", this.baseFeatureInfoCustom, 20, 10));
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "DIM_CUSTOM");
        Assert.assertEquals((Object)"Could not find a match for 'custom' value: 'IAmNotThere'", (Object)message.trim());
    }

    @Test
    public void testCustomDimensionStringInvalidIgnore() throws Exception {
        this.setupVectorDimension("dim_custom", "shared_key", DimensionPresentation.LIST, null, "foot", "ft");
        this.setExceptionsOnInvalidDimension(false);
        String base = this.baseFeatureInfoCustom + "&dim_custom=IAmNotThere";
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 10));
        Assert.assertNull((Object)this.getFeatureAt(base, 20, 30));
        Assert.assertNull((Object)this.getFeatureAt(base, 60, 30));
    }
}

