/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.util.logging.Level;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DescribeLayerTest
extends WMSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Logging.getLogger((String)"org.geoserver.ows").setLevel(Level.OFF);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    @Test
    public void testDescribeLayerVersion111() throws Exception {
        String layer = MockData.FORESTS.getPrefix() + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?service=wms&version=1.1.1&request=DescribeLayer&layers=" + layer;
        Assert.assertEquals((Object)"src/test/resources/geoserver", (Object)this.getGeoServer().getGlobal().getSettings().getProxyBaseUrl());
        Document dom = this.getAsDOM(request, true);
        Assert.assertEquals((Object)"1.1.1", (Object)dom.getDocumentElement().getAttributes().getNamedItem("version").getNodeValue());
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Document dom = this.getAsDOM("cite/wms?service=wms&version=1.1.1&request=DescribeLayer&layers=PrimitiveGeoFeature", true);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("sf/wms?service=wms&version=1.1.1&request=DescribeLayer&layers=PrimitiveGeoFeature", true);
        Assert.assertEquals((Object)"WMS_DescribeLayerResponse", (Object)dom.getDocumentElement().getNodeName());
        Element e = (Element)dom.getElementsByTagName("LayerDescription").item(0);
        String attribute = e.getAttribute("owsURL");
        Assert.assertTrue((boolean)attribute.contains("sf/wfs"));
        attribute = e.getAttribute("owsType");
        Assert.assertEquals((Object)"WFS", (Object)attribute);
        e = (Element)dom.getElementsByTagName("Query").item(0);
        String typeName = e.getAttribute("typeName");
        Assert.assertEquals((String)"unexpected fully qualified typename", (Object)"sf:PrimitiveGeoFeature", (Object)typeName);
    }

    @Test
    public void testWorkspaceNonQualifiedUrl() throws Exception {
        Document dom = this.getAsDOM("wms?service=wms&version=1.1.1&request=DescribeLayer&layers=PrimitiveGeoFeature", true);
        Assert.assertEquals((Object)"WMS_DescribeLayerResponse", (Object)dom.getDocumentElement().getNodeName());
        Element e = (Element)dom.getElementsByTagName("LayerDescription").item(0);
        String attribute = e.getAttribute("owsURL");
        Assert.assertTrue((boolean)attribute.contains("wfs"));
        attribute = e.getAttribute("owsType");
        Assert.assertEquals((Object)"WFS", (Object)attribute);
        e = (Element)dom.getElementsByTagName("Query").item(0);
        String typeName = e.getAttribute("typeName");
        Assert.assertEquals((String)"unexpected fully qualified typename", (Object)"sf:PrimitiveGeoFeature", (Object)typeName);
    }

    @Test
    public void testImageWMSLayer() throws Exception {
        Document dom = this.getAsDOM("wms?service=wms&version=1.1.1&request=DescribeLayer&layers=wcs:World", true);
        Assert.assertEquals((Object)"WMS_DescribeLayerResponse", (Object)dom.getDocumentElement().getNodeName());
        Element e = (Element)dom.getElementsByTagName("LayerDescription").item(0);
        String attribute = e.getAttribute("owsURL");
        Assert.assertTrue((boolean)attribute.contains("wcs"));
        attribute = e.getAttribute("owsType");
        Assert.assertEquals((Object)"WCS", (Object)attribute);
        e = (Element)dom.getElementsByTagName("Query").item(0);
        String typeName = e.getAttribute("typeName");
        Assert.assertEquals((String)"unexpected typename", (Object)"wcs:World", (Object)typeName);
    }

    @Test
    public void testImageWMSLayerWorkspaceQualified() throws Exception {
        Document dom = this.getAsDOM("wcs/wms?service=wms&version=1.1.1&request=DescribeLayer&layers=World", true);
        Assert.assertEquals((Object)"WMS_DescribeLayerResponse", (Object)dom.getDocumentElement().getNodeName());
        Element e = (Element)dom.getElementsByTagName("LayerDescription").item(0);
        String attribute = e.getAttribute("owsURL");
        Assert.assertTrue((boolean)attribute.contains("wcs"));
        attribute = e.getAttribute("owsType");
        Assert.assertEquals((Object)"WCS", (Object)attribute);
        e = (Element)dom.getElementsByTagName("Query").item(0);
        String typeName = e.getAttribute("typeName");
        Assert.assertEquals((String)"unexpected typename", (Object)"wcs:World", (Object)typeName);
    }
}

