/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.Serializable;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geoserver.wms.WMSInfo;
import org.geotools.image.io.ImageIOExt;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class CustomDimensionsTest
extends WMSDimensionsTestSupport {
    private static final QName WATTEMP = new QName(MockData.DEFAULT_URI, "watertemp", MockData.DEFAULT_PREFIX);
    private static final String CAPABILITIES_REQUEST = "wms?request=getCapabilities&version=1.1.1";
    private static final String BBOX = "0,40,15,45";
    private static final String LAYERS = "gs:watertemp";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        String styleName = "temperature";
        testData.addStyle(styleName, "../temperature.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        HashMap<SystemTestData.LayerProperty, String> propertyMap = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMap.put(SystemTestData.LayerProperty.STYLE, "temperature");
        testData.addRasterLayer(WATTEMP, "custwatertemp.zip", null, propertyMap, SystemTestData.class, this.getCatalog());
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.getSRS().add("EPSG:4326");
        this.getGeoServer().save((ServiceInfo)wms);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("", "http://www.opengis.net/wms");
        namespaces.put("wms", "http://www.opengis.net/wms");
        SystemTestData cfr_ignored_0 = (SystemTestData)this.getTestData();
        SystemTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    @After
    public void removeRasterDimensions() {
        CoverageInfo info = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        info.getMetadata().remove((Object)"custom_dimension_MY_DIMENSION");
        this.getCatalog().save((ResourceInfo)info);
    }

    @Test
    public void testCapabilitiesNoDimension() throws Exception {
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='gs:watertemp'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Layer/Dimension)", (Document)dom);
    }

    @Test
    public void testCapabilities() throws Exception {
        this.setupRasterDimension("MY_DIMENSION", DimensionPresentation.LIST, null, null);
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"MY_DIMENSION", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CustomDimValueA", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CustomDimValueA,CustomDimValueB,CustomDimValueC", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testInvalidCustomCapabilities() throws Exception {
        this.setupRasterDimension("MY_DIMENSION", DimensionPresentation.LIST, null, null);
        this.setupRasterDimension("foobar", DimensionPresentation.LIST, null, null);
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"MY_DIMENSION", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CustomDimValueA", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CustomDimValueA,CustomDimValueB,CustomDimValueC", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testCapabilitiesUnits() throws Exception {
        this.setupRasterDimension("MY_DIMENSION", DimensionPresentation.LIST, "nano meters", "nm");
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"nano meters", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"nm", (String)"//Layer/Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"MY_DIMENSION", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CustomDimValueA", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"CustomDimValueA,CustomDimValueB,CustomDimValueC", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testGetMap() throws Exception {
        ImageIOExt.allowNativeCodec((String)"tif", ImageReaderSpi.class, (boolean)false);
        this.setupRasterDimension("MY_DIMENSION", DimensionPresentation.LIST, "nano meters", "nm");
        this.setExceptionsOnInvalidDimension(false);
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=0,40,15,45&styles=&layers=gs:watertemp&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&VALIDATESCHEMA=true&DIM_MY_DIMENSION=bad_dimension_value");
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertTrue((boolean)CustomDimensionsTest.isEmpty(image));
        response = this.getAsServletResponse("wms?bbox=0,40,15,45&styles=raster&layers=gs:watertemp&Format=image/tiff&request=GetMap&width=550&height=250&srs=EPSG:4326&VALIDATESCHEMA=true&DIM_MY_DIMENSION=CustomDimValueB,CustomDimValueC,CustomDimValueA");
        image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertFalse((boolean)CustomDimensionsTest.isEmpty(image));
        Assert.assertTrue((String)"sample model bands", (3 <= image.getSampleModel().getNumBands() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomDimensionTooMany() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.setMaxRequestedDimensionValues(2);
        gs.save((ServiceInfo)wms);
        try {
            ImageIOExt.allowNativeCodec((String)"tif", ImageReaderSpi.class, (boolean)false);
            MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=0,40,15,45&styles=raster&layers=gs:watertemp&Format=image/tiff&request=GetMap&width=550&height=250&srs=EPSG:4326&VALIDATESCHEMA=true&DIM_MY_DIMENSION=CustomDimValueB,CustomDimValueC,CustomDimValueA");
            Assert.assertEquals((Object)"text/xml", (Object)this.getBaseMimeType(response.getContentType()));
            Document dom = this.dom(response, true);
            String text = this.checkLegacyException(dom, "InvalidParameterValue", "DIM_MY_DIMENSION");
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 2 dimension values"));
        }
        finally {
            wms.setMaxRequestedDimensionValues(100);
            gs.save((ServiceInfo)wms);
        }
    }

    @Test
    public void testGetMapCaseInsesitiveKey() throws Exception {
        this.setupRasterDimension("MY_DIMENSION", DimensionPresentation.LIST, "nano meters", "nm");
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=0,40,15,45&styles=&layers=gs:watertemp&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&VALIDATESCHEMA=true&DIM_" + "MY_DIMENSION".toLowerCase() + "=CustomDimValueB");
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertFalse((boolean)CustomDimensionsTest.isEmpty(image));
    }

    private void setupRasterDimension(String metadata, DimensionPresentation presentation, String units, String unitSymbol) {
        CoverageInfo info = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(presentation);
        di.setUnits(units);
        di.setUnitSymbol(unitSymbol);
        info.getMetadata().put("custom_dimension_" + metadata, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    private static boolean isEmpty(BufferedImage image) {
        DataBuffer pixData = image.getRaster().getDataBuffer();
        int bankCount = pixData.getNumBanks();
        int size = pixData.getSize();
        for (int i = 0; i < bankCount; ++i) {
            for (int j = 0; j < size; ++j) {
                if (pixData.getElem(i, j) == 255) continue;
                return false;
            }
        }
        return true;
    }
}

