/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.svg;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.svg.SVGStreamingMapOutputFormat;
import org.geoserver.wms.svg.StreamingSVGMap;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.style.Style;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class SVGMapProducerTest
extends WMSTestSupport {
    private static String EXPECTED_DOC = "<?xml version=\"1.0\" standalone=\"no\"?><svg xmlns=\"http://www.w3.org/2000/svg\"    xmlns:xlink=\"http://www.w3.org/1999/xlink\"    stroke=\"green\"    fill=\"none\"    stroke-width=\"0.1%\"    stroke-linecap=\"round\"    stroke-linejoin=\"round\"    width=\"300\"    height=\"300\"    viewBox=\"-250.0 -250.0 500.0 500.0\"    preserveAspectRatio=\"xMidYMid meet\">  <g id=\"LAYER\" class=\"STYLE\">    <use x=\"10\" y=\"-10\" xlink:href=\"#point\"/>    <path d=\"M50 -50l50 -50 \"/>    <path d=\"M0 0l0 -200 200 0 0 200 -200 0 Z\"/>  </g></svg>";

    private void doTestSVGMapProducer(String layer, String style, String expectedDoc) throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(10.0, 10.0));
        LineString line = gf.createLineString(new Coordinate[]{new Coordinate(50.0, 50.0), new Coordinate(100.0, 100.0)});
        Polygon polygon = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 200.0), new Coordinate(200.0, 200.0), new Coordinate(200.0, 0.0), new Coordinate(0.0, 0.0)}), null);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(layer);
        ftb.add("geom", Geometry.class);
        SimpleFeatureType type = ftb.buildFeatureType();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{line}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{polygon}, null);
        MemoryDataStore ds = new MemoryDataStore();
        ds.createSchema(type);
        ds.addFeatures(new SimpleFeature[]{f1, f2, f3});
        ContentFeatureSource fs = ds.getFeatureSource(layer);
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(new ReferencedEnvelope(-250.0, 250.0, -250.0, 250.0, null));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        Style basicStyle = this.getCatalog().getStyleByName("Default").getStyle();
        basicStyle.setName(style);
        map.addLayer((Layer)new FeatureLayer((FeatureSource)fs, basicStyle));
        SVGStreamingMapOutputFormat producer = new SVGStreamingMapOutputFormat();
        StreamingSVGMap encodeSVG = producer.produceMap(map);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        encodeSVG.encode((OutputStream)out);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLAssert.assertXMLEqual((String)expectedDoc, (String)out.toString());
    }

    @Test
    public void testHeterogeneousGeometry() throws Exception {
        String layer = "test";
        String style = "Default";
        String expectedDoc = EXPECTED_DOC.replace("LAYER", layer).replace("STYLE", style);
        this.doTestSVGMapProducer(layer, style, expectedDoc);
    }

    @Test
    public void testEscaping() throws Exception {
        String unescapedLayer = "layer\"<>";
        String escapedLayer = "layer&quot;&lt;&gt;";
        String unescapedStyle = "style\"<>";
        String escapedStyle = "style&quot;&lt;&gt;";
        String expectedDoc = EXPECTED_DOC.replace("LAYER", escapedLayer).replace("STYLE", escapedStyle);
        this.doTestSVGMapProducer(unescapedLayer, unescapedStyle, expectedDoc);
    }
}

