/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.RenderingVariables;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.RasterSymbolizerVisitorTest;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.styling.SLDParser;
import org.junit.Assert;
import org.junit.Test;

public class VectorToRasterTransformTest
extends WMSTestSupport {
    @Test
    public void testVectorToRasterTransformUsesBBox() throws IOException {
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.setMapWidth(100);
        map.setMapHeight(100);
        map.setRequest(request);
        ReferencedEnvelope bounds = new ReferencedEnvelope(0.0, 45.0, 0.0, 45.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.getViewport().setBounds(bounds);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(CiteTestData.STREAMS.getNamespaceURI(), CiteTestData.STREAMS.getLocalPart());
        final SimpleFeatureSource featureSource = (SimpleFeatureSource)ftInfo.getFeatureSource(null, null);
        final MutableBoolean containsBBox = new MutableBoolean(false);
        DecoratingFeatureSource source = new DecoratingFeatureSource((FeatureSource)featureSource){

            public SimpleFeatureCollection getFeatures(Query query) throws IOException {
                query.getFilter().accept((FilterVisitor)new NullFilterVisitor(){

                    public Object visit(BBOX filter, Object data) {
                        containsBBox.setValue(true);
                        return data;
                    }
                }, null);
                return featureSource.getFeatures(query);
            }
        };
        Style style = this.parseStyle("HeatmapTransform.sld");
        map.addLayer((Layer)new FeatureLayer((FeatureSource)source, style));
        request.setFormat("image/gif");
        RenderingVariables.setupEnvironmentVariables((WMSMapContent)map);
        RenderedImageMap imageMap = new RenderedImageMapOutputFormat(this.getWMS()).produceMap(map);
        imageMap.dispose();
        Assert.assertTrue((String)"The query filter should have a BBOX", (boolean)containsBBox.booleanValue());
    }

    private Style parseStyle(String styleName) throws IOException {
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
        parser.setInput(RasterSymbolizerVisitorTest.class.getResource(styleName));
        StyledLayerDescriptor sld = parser.parseSLD();
        NamedLayer ul = (NamedLayer)sld.getStyledLayers()[0];
        return ul.getStyles()[0];
    }
}

