/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.wms.map.RenderTimeStatistics;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RenderTimeStatisticsTest {
    List<Layer> layers;

    @Before
    public void setUp() {
        this.layers = new ArrayList<Layer>(2);
        this.layers.add(new Layer(){

            public ReferencedEnvelope getBounds() {
                return null;
            }

            public String getTitle() {
                return "Layer1";
            }
        });
        this.layers.add(new Layer(){

            public ReferencedEnvelope getBounds() {
                return null;
            }

            public String getTitle() {
                return "Layer2";
            }
        });
    }

    @Test
    public void testRenderingTimeStatistics() {
        RenderTimeStatistics statistics = new RenderTimeStatistics();
        ServletRequestAttributes attrs = new ServletRequestAttributes(this.createMockHttpRequest(statistics));
        RequestContextHolder.setRequestAttributes((RequestAttributes)attrs);
        for (Layer l : this.layers) {
            statistics.layerStart(l);
            statistics.labellingStart();
            statistics.labellingEnd();
            statistics.layerEnd(l);
        }
        statistics.renderingComplete();
        Assert.assertEquals((Object)statistics.getRenderingLayersIdxs(), Arrays.asList(0, 1));
        Assert.assertEquals(statistics.getLayerNames().get(0), (Object)"Layer1");
        Assert.assertEquals(statistics.getLayerNames().get(1), (Object)"Layer2");
        Assert.assertNotNull((Object)statistics.getRenderingTime(Integer.valueOf(0)));
        Assert.assertNotNull((Object)statistics.getRenderingTime(Integer.valueOf(1)));
        Assert.assertNotNull((Object)statistics.getLabellingTime());
        Assert.assertNotNull((Object)attrs.getAttribute("statistics", 0));
    }

    public HttpServletRequest createMockHttpRequest(RenderTimeStatistics statistics) {
        HttpServletRequest httpReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        httpReq.setAttribute("statistics", (Object)statistics);
        Mockito.when((Object)httpReq.getAttribute("statistics")).thenReturn((Object)statistics);
        ((HttpServletRequest)Mockito.doNothing().when((Object)httpReq)).setAttribute("statistics", (Object)statistics);
        return httpReq;
    }
}

