/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.junit.Test;

public class RasterWithoutOutlineMapStyleTest
extends WMSDimensionsTestSupport {
    private static final String BASE_URL = "wms?service=WMS&version=1.1.0&request=GetMap&bbox=-2.237,38.562,16.593,46.558&width=200&height=80&srs=EPSG:4326&format=image/png";
    private static final String MIME = "image/png";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("raster_without_outline", "../raster_without_outline.sld", ((Object)((Object)this)).getClass(), catalog);
    }

    @Test
    public void testNoOutline() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&bbox=-2.237,38.562,16.593,46.558&width=200&height=80&srs=EPSG:4326&format=image/png&layers=watertemp&styles=raster_without_outline", MIME);
        this.assertPixel(image, 60, 20, new Color(255, 255, 255));
        this.assertPixel(image, 100, 40, new Color(255, 165, 0));
        image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&bbox=-2.237,38.562,16.593,46.558&width=200&height=80&srs=EPSG:4326&format=image/png&layers=watertemp,TimeElevation&styles=raster_without_outline,raster_without_outline", MIME);
        this.assertPixel(image, 24, 40, new Color(0, 0, 0));
        this.assertPixel(image, 60, 20, new Color(255, 255, 255));
        this.assertPixel(image, 100, 40, new Color(255, 165, 0));
    }
}

