/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.TestHttpClientRule;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.LayerGroupStyleImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.logging.TestAppender;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.OpenLayers3MapOutputFormat;
import org.geoserver.wms.map.OpenLayersMapOutputFormat;
import org.geoserver.wms.map.RawMap;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class OpenLayersMapOutputFormatTest
extends WMSTestSupport {
    Pattern lookForEscapedParam = Pattern.compile(Pattern.quote("\"</script><script>alert('x-scripted');</script><script>\": 'foo'"));
    @Rule
    public TestHttpClientRule clientMocker = new TestHttpClientRule();

    protected String getLogConfiguration() {
        GeoServerResourceLoader loader = new GeoServerResourceLoader(testData.getDataDirectoryRoot());
        Resource resource = loader.get("logs/OL_LOGGING.properties");
        if (resource.getType() == Resource.Type.UNDEFINED) {
            try {
                loader.copyFromClassPath("/OL_LOGGING.properties", "logs/OL_LOGGING.properties");
            }
            catch (IOException e) {
                LOGGER.fine("Unable to configure with OL_LOGGING");
                return "TEST_LOGGING";
            }
        }
        return "OL_LOGGING";
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        WorkspaceInfo workspaceInfo = this.getCatalog().getWorkspaceByName(MockData.DEFAULT_PREFIX);
        StoreInfo store = this.createStaticRasterStore(workspaceInfo);
        NamespaceInfo nameSpace = this.getCatalog().getNamespaceByPrefix(MockData.DEFAULT_PREFIX);
        this.createStaticRasterLayer(nameSpace, store, "staticRaster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXssFix() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + (Envelope)env);
        GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        request.getRawKvp().put("</script><script>alert('x-scripted');</script><script>", "foo");
        request.getRawKvp().put("25064;ALERT(1)//419", "1");
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        FeatureLayer layer = new FeatureLayer(fs, basicStyle);
        layer.setTitle("Title</foo");
        map.addLayer((Layer)layer);
        request.setFormat("application/openlayers");
        StyleInfoImpl otherStyle = new StyleInfoImpl(null);
        otherStyle.setName("style<>");
        try {
            ((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getStyles().add(otherStyle);
            String htmlDoc = this.getAsHTML(map);
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"&lt;/script&gt;&lt;script&gt;alert(&#39;x-scripted&#39;);&lt;/script&gt;&lt;script&gt;"));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"25064;ALERT(1)//419"));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)layer.getTitle())));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"Title&lt;/foo"));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)otherStyle.getName())));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"style&lt;&gt;"));
        }
        finally {
            ((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getStyles().remove(otherStyle);
        }
    }

    @Test
    public void testRastersFilteringCapabilities() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=gs:staticRaster&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"supportsFiltering\" value=\"true\"/>"));
        response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=wcs:World&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"supportsFiltering\" value=\"false\"/>"));
        response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=wcs:World,gs:staticRaster&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"supportsFiltering\" value=\"true\"/>"));
    }

    @Test
    public void testWMTSFilteringCapabilities() throws Exception {
        this.createWMTSCatalogStuff();
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=gs:wmtslayername&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"supportsFiltering\" value=\"false\"/>"));
        response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=gs:wmtslayername,gs:staticRaster&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"supportsFiltering\" value=\"true\"/>"));
    }

    private StoreInfo createStaticRasterStore(WorkspaceInfo workspace) {
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo store = catalog.getFactory().createCoverageStore();
        store.setWorkspace(workspace);
        store.setType("StaticRaster");
        store.setEnabled(true);
        store.setName("StaticRaster");
        store.setURL("http://127.0.0.1:geoserver");
        catalog.add((StoreInfo)store);
        return store;
    }

    private StoreInfo createWMTSCatalogStuff() throws MalformedURLException, IOException {
        String capabilities = this.clientMocker.getServer() + "/geoserver/gwc?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS";
        MockHttpClient client = new MockHttpClient();
        client.expectGet(new URL(capabilities), (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("/nasa.getcapa.xml"), "text/xml", new String[0]));
        this.clientMocker.bind((HTTPClient)client, capabilities);
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspace = this.getCatalog().getWorkspaceByName(MockData.DEFAULT_PREFIX);
        NamespaceInfo nameSpace = this.getCatalog().getNamespaceByPrefix(MockData.DEFAULT_PREFIX);
        WMTSStoreInfo store = catalog.getFactory().createWebMapTileServer();
        store.setWorkspace(workspace);
        store.setType("WMTS");
        store.setEnabled(true);
        store.setName("wmts");
        store.setCapabilitiesURL(capabilities);
        catalog.add((StoreInfo)store);
        WMTSLayerInfo resource = catalog.getFactory().createWMTSLayer();
        resource.setNamespace(nameSpace);
        resource.setName("wmtslayername");
        resource.setNativeName("AMSR2_Snow_Water_Equivalent");
        resource.setEnabled(true);
        resource.setStore((StoreInfo)store);
        catalog.add((ResourceInfo)resource);
        LayerInfoImpl layer = new LayerInfoImpl();
        layer.setResource((ResourceInfo)resource);
        layer.setEnabled(true);
        layer.setName("wmtslayername");
        catalog.add((LayerInfo)layer);
        return store;
    }

    private void createStaticRasterLayer(NamespaceInfo namespace, StoreInfo store, String layerName) {
        Catalog catalog = this.getCatalog();
        CoverageInfoImpl coverageInfo = new CoverageInfoImpl(catalog);
        coverageInfo.setNamespace(namespace);
        coverageInfo.setName(layerName);
        coverageInfo.setNativeCoverageName(layerName);
        coverageInfo.setStore(store);
        LayerInfoImpl layer = new LayerInfoImpl();
        layer.setResource((ResourceInfo)coverageInfo);
        layer.setEnabled(true);
        layer.setName(layerName);
        layer.setDefaultStyle(catalog.getStyleByName("raster"));
        coverageInfo.setNativeCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        coverageInfo.setSRS("EPSG:4326");
        catalog.add((ResourceInfo)coverageInfo);
        catalog.add((LayerInfo)layer);
    }

    @Test
    public void testUrnCodeFix() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + (Envelope)env);
        GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        request.setCrs(crs);
        WMSMapContent map = new WMSMapContent();
        map.setRequest(request);
        request.setFormat("application/openlayers");
        String htmlDoc = this.getAsHTML(map);
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"SRS\" value=\"EPSG:4326\"/>"));
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"yx\" value=\"true\"/>"));
    }

    @Test
    public void testOL3vsOL2() throws Exception {
        String path = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&bbox=-180,-90,180,90&width=768&height=330&srs=EPSG:4326&format=";
        String firefoxAgent = "Firefox 40.1";
        String ie8Agent = "MSIE 8.";
        String contentFirefox = this.getResponseContent(path + "application/openlayers", "Firefox 40.1", this.getBaseMimeType("text/html; subtype=openlayers3"));
        MatcherAssert.assertThat((Object)contentFirefox, (Matcher)Matchers.containsString((String)"openlayers3/ol.js"));
        String contentIE8 = this.getResponseContent(path + "application/openlayers", ie8Agent, this.getBaseMimeType("text/html; subtype=openlayers2"));
        MatcherAssert.assertThat((Object)contentIE8, (Matcher)Matchers.containsString((String)"OpenLayers.js"));
        String contentOL2 = this.getResponseContent(path + "application/openlayers2", "Firefox 40.1", this.getBaseMimeType("text/html; subtype=openlayers2"));
        MatcherAssert.assertThat((Object)contentOL2, (Matcher)Matchers.containsString((String)"OpenLayers.js"));
        String contentOL3 = this.getResponseContent(path + "application/openlayers3", "Firefox 40.1", this.getBaseMimeType("text/html; subtype=openlayers3"));
        MatcherAssert.assertThat((Object)contentOL3, (Matcher)Matchers.containsString((String)"openlayers3/ol.js"));
        String exception = this.getResponseContent(path + "application/openlayers3", ie8Agent, "application/vnd.ogc.se_xml");
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.containsString((String)"not supported"));
    }

    public String getResponseContent(String path, String userAgent, String expectedMimeType) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("GET");
        request.setContent(new byte[0]);
        if (userAgent != null) {
            request.addHeader("USER-AGENT", (Object)userAgent);
        }
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((Object)expectedMimeType, (Object)this.getBaseMimeType(response.getContentType()));
        return response.getContentAsString();
    }

    String getAsHTML(WMSMapContent map) throws IOException {
        OpenLayersMapOutputFormat mapProducer = (OpenLayersMapOutputFormat)GeoServerExtensions.extensions(OpenLayersMapOutputFormat.class).get(0);
        RawMap rawMap = mapProducer.produceMap(map);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        rawMap.writeTo((OutputStream)bos);
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }

    String getAsHTMLOL3(WMSMapContent map) throws IOException {
        OpenLayers3MapOutputFormat mapProducer = (OpenLayers3MapOutputFormat)GeoServerExtensions.extensions(OpenLayers3MapOutputFormat.class).get(0);
        RawMap rawMap = mapProducer.produceMap(map);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        rawMap.writeTo((OutputStream)bos);
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }

    @Test
    public void testExceptionsInImage() throws Exception {
        String path = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&bbox=-180,-90,180,90&width=768&height=330&srs=EPSG:4326&format=application/openlayers";
        String html = this.getAsString(path);
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" class=\"param\" title=\"EXCEPTIONS\" value=\"application/vnd.ogc.se_inimage\"/>"));
    }

    @Test
    public void testExceptionsXML() throws Exception {
        String path = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&bbox=-180,-90,180,90&width=768&height=330&srs=EPSG:4326&format=application/openlayers&exceptions=application/vnd.ogc.se_xml";
        String html = this.getAsString(path);
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" class=\"param\" title=\"EXCEPTIONS\" value=\"application/vnd.ogc.se_xml\"/>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<input type=\"hidden\" class=\"param\" title=\"EXCEPTIONS\" value=\"application/vnd.ogc.se_inimage\"/>")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXssOL3() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + (Envelope)env);
        GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        request.putHttpRequestHeader("USER-AGENT", "Firefox 40.1");
        request.getRawKvp().put("</script><script>alert('x-scripted');</script><script>", "foo");
        request.getRawKvp().put("25064;ALERT(1)//419", "1");
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        FeatureLayer layer = new FeatureLayer(fs, basicStyle);
        layer.setTitle("Title");
        map.addLayer((Layer)layer);
        request.setFormat("application/openlayers3");
        StyleInfoImpl otherStyle = new StyleInfoImpl(null);
        otherStyle.setName("style<>");
        try {
            ((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getStyles().add(otherStyle);
            String htmlDoc = this.getAsHTMLOL3(map);
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"&lt;/script&gt;&lt;script&gt;alert(&#39;x-scripted&#39;);&lt;/script&gt;&lt;script&gt;"));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"25064;ALERT(1)//419"));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)otherStyle.getName())));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"style&lt;&gt;"));
        }
        finally {
            ((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getStyles().remove(otherStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLayerGroupStylesInDropdown() throws Exception {
        LayerGroupInfo group = null;
        Catalog catalog = this.getCatalog();
        try {
            this.createLakesPlacesLayerGroup(catalog, "lakes_and_places_group", LayerGroupInfo.Mode.SINGLE, null);
            group = catalog.getLayerGroupByName("lakes_and_places_group");
            LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
            StyleInfoImpl styleName = new StyleInfoImpl(this.getCatalog());
            styleName.setName("nature-style");
            groupStyle.setName((StyleInfo)styleName);
            groupStyle.getLayers().add(this.getCatalog().getLayerByName("cite:Forests"));
            groupStyle.getLayers().add(this.getCatalog().getLayerByName("cite:Lakes"));
            groupStyle.getStyles().add(null);
            groupStyle.getStyles().add(null);
            group.getLayerGroupStyles().add(groupStyle);
            catalog.save(group);
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&format=application/openlayers&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&bbox=-0.002,-0.003,0.005,0.002";
            MockHttpServletResponse response = this.getAsServletResponse(url);
            String content = response.getContentAsString();
            Assert.assertTrue((boolean)content.contains("<option value=\"nature-style\">nature-style</option>"));
            if (group == null) return;
        }
        catch (Throwable throwable) {
            if (group == null) throw throwable;
            catalog.remove(group);
            throw throwable;
        }
        catalog.remove(group);
    }

    @Test
    public void testAutoCodeLogsErrors() throws Exception {
        try (TestAppender appender = TestAppender.createAppender((String)"testAutoCodeLogsErrors", null);){
            appender.startRecording("org.geoserver.wms.map");
            GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
            CoordinateReferenceSystem crs = CRS.decode((String)"AUTO:42003,9001,-20,-45");
            request.setCrs(crs);
            request.setBbox(new Envelope(-3000000.0, 3000000.0, -3000000.0, 3000000.0));
            WMSMapContent map = new WMSMapContent();
            map.setRequest(request);
            request.setFormat("application/openlayers");
            String htmlDoc = this.getAsHTML(map);
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"SRS\" value=\"EPSG:4326\"/>"));
            MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"<input type=\"hidden\" id=\"yx\" value=\"false\"/>"));
            appender.assertFalse("Error was logged", "Failed to determine CRS axis order");
            appender.stopRecording("org.geoserver.wms.map");
        }
    }

    @Test
    public void testRemovedInlineJavaScriptOL2() throws Exception {
        WMSMapContent map = new WMSMapContent();
        map.setRequest(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        String htmlDoc = this.getAsHTML(map);
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"<script src=\""));
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<script defer=\"defer\" type=\"text/javascript\">")));
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" onload=")));
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" onchange=")));
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" onClick=")));
    }

    @Test
    public void testRemovedInlineJavaScriptOL3() throws Exception {
        WMSMapContent map = new WMSMapContent();
        map.setRequest(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.getRequest().putHttpRequestHeader("USER-AGENT", "Firefox 40.1");
        String htmlDoc = this.getAsHTMLOL3(map);
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)"<script src=\""));
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<script type=\"text/javascript\">")));
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" onchange=")));
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" onClick=")));
    }
}

