/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import org.geoserver.wms.map.JpegOrPngChooser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JpegOrPngChooserTest {
    private BufferedImage indexed;
    private BufferedImage gray;
    private BufferedImage rgb;
    private BufferedImage rgba;
    private BufferedImage rgba_opaque;
    private BufferedImage rgba_partial;

    @Before
    public void prepareImages() {
        this.indexed = new BufferedImage(10, 10, 13);
        this.gray = new BufferedImage(10, 10, 10);
        this.rgb = new BufferedImage(10, 10, 5);
        this.rgba = new BufferedImage(10, 10, 6);
        this.rgba_opaque = new BufferedImage(10, 10, 6);
        Graphics2D graphics = this.rgba_opaque.createGraphics();
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, 10, 10);
        graphics.dispose();
        this.rgba_partial = new BufferedImage(10, 10, 6);
        graphics = this.rgba_partial.createGraphics();
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, 10, 5);
        graphics.dispose();
    }

    @Test
    public void testJpegPngImageWriter() {
        this.assertPng(this.indexed);
        this.assertJpeg(this.gray);
        this.assertJpeg(this.rgb);
        this.assertPng(this.rgba);
        this.assertJpeg(this.rgba_opaque);
        this.assertPng(this.rgba_partial);
    }

    private void assertPng(RenderedImage image) {
        JpegOrPngChooser chooser = new JpegOrPngChooser(image);
        Assert.assertFalse((boolean)chooser.isJpegPreferred());
        Assert.assertEquals((Object)"image/png", (Object)chooser.getMime());
        Assert.assertEquals((Object)"png", (Object)chooser.getExtension());
    }

    private void assertJpeg(RenderedImage image) {
        JpegOrPngChooser chooser = new JpegOrPngChooser(image);
        Assert.assertTrue((boolean)chooser.isJpegPreferred());
        Assert.assertEquals((Object)"image/jpeg", (Object)chooser.getMime());
        Assert.assertEquals((Object)"jpeg", (Object)chooser.getExtension());
    }
}

