/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.transform.TransformerException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.GetLegendGraphic;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.legendgraphic.BaseLegendTest;
import org.geoserver.wms.legendgraphic.JSONLegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.xml.styling.SLDParser;
import org.geotools.xml.styling.SLDTransformer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class JSONLegendGraphicOutputFormatTest
extends BaseLegendTest<JSONLegendGraphicBuilder> {
    static final String JSONFormat = "application/json";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("tricky_point", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("arealandmarks", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("fixedArrows", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("dynamicArrows", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("multiLanguageVector", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("multiLanguageRaster", ((Object)((Object)this)).getClass(), catalog);
        testData.addWorkspace("foo", "http://foo", catalog);
        testData.addStyle(catalog.getWorkspaceByName("foo"), "arealandmarks", "arealandmarks.sld", ((Object)((Object)this)).getClass(), catalog);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @Before
    public void setLegendProducer() throws Exception {
        this.legendProducer = new JSONLegendGraphicBuilder();
        this.service = new GetLegendGraphic(this.getWMS());
    }

    @Test
    public void testUserSpecifiedRule() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        Rule rule = (Rule)((FeatureTypeStyle)multipleRulesStyle.featureTypeStyles().get(0)).rules().get(0);
        LOGGER.info("testing single rule " + rule.getName() + " from style " + multipleRulesStyle.getName());
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        GetLegendGraphicRequest req = this.getRequest(ftInfo.getFeatureType(), multipleRulesStyle);
        req.setRule(rule.getName());
        req.setLegendOptions(new HashMap());
        req.setFormat(JSONFormat);
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        JSONArray rules = result.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)rule.getDescription().getTitle().toString(), (Object)rules.getJSONObject(0).getJSONArray("rules").getJSONObject(0).get("title"));
    }

    @Test
    public void testRainfall() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall").getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        GetLegendGraphicRequest req = this.getRequest(feature.getSchema(), multipleRulesStyle);
        req.setLegendOptions(new HashMap());
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testNoLayerProvidedAndNonStrictRequest() throws Exception {
        Style style = this.getCatalog().getStyleByName("rainfall").getStyle();
        Assert.assertNotNull((Object)style);
        GetLegendGraphicRequest req = this.getRequest(null, style);
        req.setStrict(false);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((long)1L, (long)resp.getJSONArray("Legend").size());
    }

    @Test
    public void testMultipleLayers() throws Exception {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        Style style = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        GetLegendGraphicRequest req = this.getRequest(ftInfo.getFeatureType(), style);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(resp);
        GetLegendGraphicRequest.LegendRequest legend = new GetLegendGraphicRequest.LegendRequest(ftInfo.getFeatureType());
        legend.setStyle(style);
        req.getLegends().add(legend);
        resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(resp);
    }

    @Test
    public void testMultipleLayersWithDifferentStyles() throws Exception {
        GetLegendGraphicRequest req = this.getRequest(null, null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        req.getLegends().clear();
        req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ftInfo.getFeatureType()));
        req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ftInfo.getFeatureType()));
        Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(0)).setStyle(style1);
        Style style2 = this.getCatalog().getStyleByName(MockData.LAKES.getLocalPart()).getStyle();
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(1)).setStyle(style2);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertEquals((long)2L, (long)legend.size());
    }

    @Test
    public void testMultipleLayersWithVectorAndCoverage() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setFeatureType(JSONFormat);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        req.getLegends().clear();
        layers.add(ftInfo.getFeatureType());
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        layers.add(feature.getSchema());
        layers.forEach(ft -> req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ft)));
        Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(0)).setStyle(style1);
        Style style2 = this.getCatalog().getStyleByName("rainfall").getStyle();
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(1)).setStyle(style2);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((Object)"RoadSegments", (Object)resp.getJSONArray("Legend").getJSONObject(0).get("layerName"));
        Assert.assertEquals((Object)"GridCoverage", (Object)resp.getJSONArray("Legend").getJSONObject(1).get("layerName"));
    }

    @Test
    public void testMultipleLayersWithVectorAndInvisibleCoverage() throws Exception {
        GetLegendGraphicRequest req = this.getRequest(null, null);
        req.setScale(1000.0);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        req.getLegends().clear();
        req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ftInfo.getFeatureType()));
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(feature.getSchema()));
        Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(0)).setStyle(style1);
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(1)).setStyle(this.readSLD("InvisibleRaster.sld"));
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        JSONArray legends = resp.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)legends.size());
        Assert.assertEquals((Object)"RoadSegments", (Object)legends.getJSONObject(0).get("layerName"));
    }

    @Test
    public void testMultipleLayersWithVectorAndInvisibleVector() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setScale(1000.0);
        req.getLegends().clear();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ftInfo.getFeatureType()));
        req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ftInfo.getFeatureType()));
        StyleInfo roadStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart());
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(0)).setStyle(roadStyle.getStyle());
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(1)).setStyle(this.readSLD("InvisibleLine.sld"));
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        JSONArray legends = resp.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)legends.size());
        Assert.assertEquals((Object)"RoadSegments", (Object)legends.getJSONObject(0).get("layerName"));
    }

    @Test
    public void testMixedGeometry() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("MIXEDGEOMETRY");
        builder.setNamespaceURI("test");
        builder.setDefaultGeometry("GEOMETRY");
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        builder.setCRS(crs);
        AttributeTypeImpl at = new AttributeTypeImpl((Name)new NameImpl("ID"), String.class, false, false, Collections.emptyList(), null, null);
        builder.add((AttributeDescriptor)new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("ID"), 0, 1, false, null));
        GeometryTypeImpl gt = new GeometryTypeImpl((Name)new NameImpl("GEOMETRY"), Geometry.class, crs, false, false, Collections.emptyList(), null, null);
        builder.add((AttributeDescriptor)new GeometryDescriptorImpl((GeometryType)gt, (Name)new NameImpl("GEOMETRY"), 0, 1, false, null));
        SimpleFeatureType fType = builder.buildFeatureType();
        req.getLegends().clear();
        GetLegendGraphicRequest.LegendRequest lr = new GetLegendGraphicRequest.LegendRequest((FeatureType)fType);
        lr.setStyle(this.readSLD("MixedGeometry.sld"));
        req.getLegends().add(lr);
        JSONObject resp = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)resp);
        JSONArray legends = resp.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)legends.size());
        JSONObject legend = legends.getJSONObject(0);
        Assert.assertEquals((Object)"MIXEDGEOMETRY", (Object)legend.get("layerName"));
        JSONArray rules = legend.getJSONArray("rules");
        Assert.assertTrue((boolean)rules.getJSONObject(0).getJSONArray("symbolizers").getJSONObject(0).containsKey((Object)"Line"));
        Assert.assertTrue((boolean)rules.getJSONObject(1).getJSONArray("symbolizers").getJSONObject(0).containsKey((Object)"Polygon"));
        Assert.assertTrue((boolean)rules.getJSONObject(2).getJSONArray("symbolizers").getJSONObject(0).containsKey((Object)"Point"));
    }

    @Test
    public void testSymbolContainedInIconUsingExpression() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("SymbolExpression.sld");
        req.setStyle(style);
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Iterator iterator = rules.iterator();
        String[] expectedSizes = new String[]{"[\"id\"]", "40"};
        int counter = 0;
        while (iterator.hasNext()) {
            JSONObject rule = (JSONObject)iterator.next();
            Assert.assertNotNull((Object)rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Point");
            Assert.assertEquals((Object)expectedSizes[counter++], (Object)pointSymb.get("size").toString());
            Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        }
    }

    @Test
    public void testProportionalSymbolSize() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbols.sld"));
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Iterator iterator = rules.iterator();
        String[] expectedSizes = new String[]{"40", "20", "10", "1"};
        int counter = 0;
        while (iterator.hasNext()) {
            JSONObject rule = (JSONObject)iterator.next();
            Assert.assertNotNull((Object)rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Point");
            Assert.assertEquals((Object)expectedSizes[counter++], (Object)pointSymb.get("size").toString());
            Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        }
    }

    @Test
    public void testProportionalSymbolsLine() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbolsLine.sld"));
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Iterator iterator = rules.iterator();
        String[] expectedSizes = new String[]{"30", "15"};
        int counter = 0;
        while (iterator.hasNext()) {
            JSONObject rule = (JSONObject)iterator.next();
            Assert.assertNotNull((Object)rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Line");
            Assert.assertEquals((Object)expectedSizes[counter++], (Object)pointSymb.getJSONObject("graphic-stroke").getString("size"));
        }
    }

    @Test
    public void testProportionalSymbolSizeUOM() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("ProportionalSymbolsUOM.sld");
        req.setStyle(style);
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Iterator iterator = rules.iterator();
        String[] expectedSizes = new String[]{"40", "20", "10", "1"};
        int counter = 0;
        while (iterator.hasNext()) {
            JSONObject rule = (JSONObject)iterator.next();
            Assert.assertNotNull((Object)rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Point");
            Assert.assertEquals((Object)expectedSizes[counter++], (Object)pointSymb.get("size").toString());
            Assert.assertEquals((Object)"m", (Object)pointSymb.get("uom"));
            Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        }
    }

    @Test
    public void testProportionalSymbolSizePartialUOM() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setScale(RendererUtilities.calculatePixelsPerMeterRatio((double)10.0, Collections.emptyMap()));
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("ProportionalSymbolsPartialUOM.sld");
        this.printStyle(style);
        req.setStyle(style);
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        String[] expectedSizes = new String[]{"40.0", "40.0"};
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            this.assertNotEmpty(rule);
            JSONObject symbolizer = rule.getJSONArray("symbolizers").getJSONObject(0);
            JSONObject pointSymb = symbolizer.getJSONObject("Point");
            Assert.assertEquals((Object)expectedSizes[i], (Object)pointSymb.get("size"));
            Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        }
    }

    @Test
    public void testInternationalizedLabels() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("forceLabels", "on");
        req.setLegendOptions(options);
        req.setFormat(JSONFormat);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("Internationalized.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertEquals((Object)"title", (Object)result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules").getJSONObject(0).get("title"));
        req.setLocale(Locale.ITALIAN);
        result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertEquals((Object)"titolomoltolungo", (Object)result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules").getJSONObject(0).get("title"));
        req.setLocale(Locale.ENGLISH);
        result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertEquals((Object)"anothertitle", (Object)result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules").getJSONObject(0).get("title"));
    }

    @Test
    public void testRenderingTransformationRasterVector() throws Exception {
        Style transformStyle = this.readSLD("RenderingTransformRasterVector.sld");
        GetLegendGraphicRequest req = this.getRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName(MockData.TASMANIA_DEM.getNamespaceURI(), MockData.TASMANIA_DEM.getLocalPart());
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(transformStyle);
        req.setLegendOptions(new HashMap());
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
    }

    @Test
    public void testColorMapWithCql() throws Exception {
        Style style = this.readSLD("ColorMapWithCql.sld");
        Assert.assertNotNull((Object)style.featureTypeStyles());
        Assert.assertEquals((long)1L, (long)style.featureTypeStyles().size());
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Assert.assertNotNull((Object)fts.rules());
        Assert.assertEquals((long)1L, (long)fts.rules().size());
        Rule rule = (Rule)fts.rules().get(0);
        Assert.assertNotNull((Object)rule.symbolizers());
        Assert.assertEquals((long)1L, (long)rule.symbolizers().size());
        Assert.assertTrue((boolean)(rule.symbolizers().get(0) instanceof RasterSymbolizer));
        RasterSymbolizer symbolizer = (RasterSymbolizer)rule.symbolizers().get(0);
        Assert.assertNotNull((Object)symbolizer.getColorMap());
        Assert.assertEquals((long)3L, (long)symbolizer.getColorMap().getColorMapEntries().length);
        ColorMapEntry[] entries = symbolizer.getColorMap().getColorMapEntries();
        Color color = LegendUtils.color((ColorMapEntry)entries[0]);
        int red = color.getRed();
        Assert.assertEquals((long)255L, (long)red);
        int green = color.getGreen();
        Assert.assertEquals((long)0L, (long)green);
        int blue = color.getBlue();
        Assert.assertEquals((long)0L, (long)blue);
        double quantity = LegendUtils.getQuantity((ColorMapEntry)entries[1]);
        Assert.assertEquals((double)20.0, (double)quantity, (double)0.0);
        double opacity = LegendUtils.getOpacity((ColorMapEntry)entries[2]);
        Assert.assertEquals((double)0.5, (double)opacity, (double)0.0);
        GetLegendGraphicRequest req = this.getRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(style);
        req.setLegendOptions(new HashMap());
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray lx = result.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)lx.size());
        JSONObject rasterSymb = lx.getJSONObject(0).getJSONArray("rules").getJSONObject(0).getJSONArray("symbolizers").getJSONObject(0).getJSONObject("Raster");
        JSONArray colorMap = rasterSymb.getJSONObject("colormap").getJSONArray("entries");
        Assert.assertEquals((Object)"['${strConcat(''#FF'',''0000'')}']", (Object)colorMap.getJSONObject(0).get("color"));
        Assert.assertEquals((Object)"[\"${15+5}\"]", (Object)colorMap.getJSONObject(1).getString("quantity"));
        Assert.assertEquals((Object)"[\"${0.25*2}\"]", (Object)colorMap.getJSONObject(2).getString("opacity"));
    }

    @Test
    public void testRenderingTransformationVectorRaster() throws Exception {
        Style transformStyle = this.readSLD("RenderingTransformVectorRaster.sld");
        GetLegendGraphicRequest req = this.getRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.NAMED_PLACES.getNamespaceURI(), MockData.NAMED_PLACES.getLocalPart());
        Assert.assertNotNull((Object)ftInfo);
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(transformStyle);
        req.setLegendOptions(new HashMap());
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
    }

    @Test
    public void testExternalGraphic() throws Exception {
        Style externalGraphicStyle = this.readSLD("ExternalGraphicDemo.sld");
        Assert.assertNotNull((Object)externalGraphicStyle);
        GetLegendGraphicRequest req = this.getRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        this.printStyle(externalGraphicStyle);
        req.setStyle(externalGraphicStyle);
        req.setScale(1.0);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        this.print((JSON)result);
        JSONArray lx = result.getJSONArray("Legend");
        Assert.assertEquals((long)1L, (long)lx.size());
        JSONObject pointSymb = lx.getJSONObject(0).getJSONArray("rules").getJSONObject(0).getJSONArray("symbolizers").getJSONObject(0).getJSONObject("Point");
        Assert.assertEquals((Object)"14.0", (Object)pointSymb.get("size"));
        Assert.assertEquals((Object)"circle", (Object)pointSymb.getJSONArray("graphics").getJSONObject(0).get("mark"));
        Assert.assertEquals((Object)"image/png", (Object)lx.getJSONObject(0).getJSONArray("rules").getJSONObject(1).getJSONObject("LegendGraphic").get("external-graphic-type"));
    }

    @Test
    public void testThickPolygonBorder() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("ThickBorder.sld");
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        this.print((JSON)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        Assert.assertFalse((boolean)legend.isEmpty());
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb1 = symbolizers.getJSONObject(0).getJSONObject("Polygon");
        Assert.assertNotNull((Object)polySymb1);
        Assert.assertEquals((Object)"#FF0000", (Object)polySymb1.get("fill"));
        Assert.assertEquals((Object)"#000000", (Object)polySymb1.get("stroke"));
        Assert.assertEquals((Object)"4", (Object)polySymb1.get("stroke-width"));
        JSONObject polySymb2 = rules.getJSONObject(1).getJSONArray("symbolizers").getJSONObject(0).getJSONObject("Polygon");
        Assert.assertNotNull((Object)polySymb2);
        Assert.assertEquals((Object)"#00FF00", (Object)polySymb2.get("fill"));
        Assert.assertEquals((Object)"#000000", (Object)polySymb2.get("stroke"));
        Assert.assertEquals((Object)"1", (Object)polySymb2.get("stroke-width"));
    }

    @Test
    public void testSimplePoint() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("point.sld");
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
    }

    @Test
    public void testHospitalPoint() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("hospital.sld");
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/Hospital?0.0.0=", (Object)pointSymb.getString("url"));
        pointSymb = symbolizers.getJSONObject(1).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/Hospital?0.0.1=", (Object)pointSymb.getString("url"));
    }

    @Test
    public void testTrickyGraphic() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        StyleInfo styleinfo = catalog.getStyleByName("tricky_point");
        Style style = styleinfo.getStyle();
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/styles/img/landmarks/shop_supermarket.p.16.png", (Object)pointSymb.getString("url"));
        symbolizers = rules.getJSONObject(2).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/tricky_point?0.2.0=", (Object)pointSymb.getString("url"));
        pointSymb = symbolizers.getJSONObject(1).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/tricky_point?0.2.1=", (Object)pointSymb.getString("url"));
    }

    @Test
    public void testGraphicFillLinks() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOLYGONS.getNamespaceURI(), MockData.MPOLYGONS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        StyleInfo styleinfo = catalog.getStyleByName("arealandmarks");
        Style style = styleinfo.getStyle();
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)2L, (long)rules.size());
        JSONObject r1 = rules.getJSONObject(0);
        Assert.assertEquals((Object)"park", (Object)r1.getString("name"));
        Assert.assertEquals((Object)"[MTFCC = 'K2180']", (Object)r1.getString("filter"));
        JSONArray symbolizers1 = r1.getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers1.size());
        JSONObject s1 = symbolizers1.getJSONObject(0);
        JSONObject gf1 = s1.getJSONObject("Polygon").getJSONObject("graphic-fill");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/styles/img/landmarks/area/forest.png", (Object)gf1.getString("url"));
        JSONObject r2 = rules.getJSONObject(1);
        Assert.assertEquals((Object)"nationalpark", (Object)r2.getString("name"));
        Assert.assertEquals((Object)"[MTFCC = 'K2181']", (Object)r2.getString("filter"));
        JSONArray symbolizers2 = r2.getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers2.size());
        JSONObject s2 = symbolizers2.getJSONObject(0);
        JSONObject gf2 = s2.getJSONObject("Polygon").getJSONObject("graphic-fill");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/arealandmarks?0.1.0=&npg=true", (Object)gf2.getString("url"));
    }

    @Test
    public void testGraphicFillLinksInWorkspace() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOLYGONS.getNamespaceURI(), MockData.MPOLYGONS.getLocalPart());
        StyleInfo styleInfo = catalog.getStyleByName("foo:arealandmarks");
        GetLegendGraphicRequest req = this.getRequest(ftInfo.getFeatureType(), styleInfo.getStyle());
        req.setWidth(20);
        req.setHeight(20);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray rules = result.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        String graphicUrl = rules.getJSONObject(0).getJSONArray("symbolizers").getJSONObject(0).getJSONObject("Polygon").getJSONObject("graphic-fill").getString("url");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/styles/foo/img/landmarks/area/forest.png", (Object)graphicUrl);
        String markUrl = rules.getJSONObject(1).getJSONArray("symbolizers").getJSONObject(0).getJSONObject("Polygon").getJSONObject("graphic-fill").getString("url");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/foo/arealandmarks?0.1.0=&npg=true", (Object)markUrl);
    }

    @Test
    public void testTextSymbolizerGraphic() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        StyleInfo styleinfo = catalog.getStyleByName("fixedArrows");
        Style style = styleinfo.getStyle();
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)1L, (long)rules.size());
        JSONObject r1 = rules.getJSONObject(0);
        JSONArray symbolizers1 = r1.getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers1.size());
        JSONObject s1 = symbolizers1.getJSONObject(0);
        JSONObject graphic = s1.getJSONObject("Text").getJSONObject("graphic");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/fixedArrows?0.0.0=&npg=true", (Object)graphic.getString("url"));
    }

    @Test
    public void testTextSymbolizerDynamicGraphic() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ftInfo = catalog.getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        StyleInfo styleinfo = catalog.getStyleByName("dynamicArrows");
        Style style = styleinfo.getStyle();
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)1L, (long)rules.size());
        JSONObject r1 = rules.getJSONObject(0);
        JSONArray symbolizers1 = r1.getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers1.size());
        JSONObject s1 = symbolizers1.getJSONObject(0);
        JSONObject graphic = s1.getJSONObject("Text").getJSONObject("graphic");
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/dynamicArrows?0.0.0=&0.0.0.rotation=0.0&0.0.0.size=16.0&npg=true", (Object)graphic.getString("url"));
    }

    @Test
    public void testElseFilter() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("PopulationElse.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        JSONObject rule = rules.getJSONObject(2);
        Assert.assertEquals((Object)"true", (Object)rule.get("ElseFilter"));
    }

    @Test
    public void testFullPoint() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("full_point.sld");
        req.setStyle(style);
        this.printStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject pointSymb = symbolizers.getJSONObject(0).getJSONObject("Point");
        Assert.assertNotNull((Object)pointSymb);
        Assert.assertEquals((Object)"[centroid(the_geom)]", (Object)pointSymb.get("geometry"));
        Assert.assertEquals((Object)"6", (Object)pointSymb.get("size"));
        Assert.assertEquals((Object)"[rotation * '-1']", (Object)pointSymb.get("rotation"));
        Assert.assertEquals((Object)"0.4", (Object)pointSymb.get("opacity"));
    }

    @Test
    public void testSimpleLine() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("line.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject lineSymb = symbolizers.getJSONObject(0).getJSONObject("Line");
        Assert.assertNotNull((Object)lineSymb);
        Assert.assertEquals((Object)"#0000FF", (Object)lineSymb.get("stroke"));
        Assert.assertEquals((Object)"2", (Object)lineSymb.get("stroke-width"));
    }

    @Test
    public void testFullLine() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("full_line.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.print((JSON)result);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject lineSymb = symbolizers.getJSONObject(0).getJSONObject("Line");
        Assert.assertFalse((boolean)lineSymb.isNullObject());
        JSONObject lineSymb1 = symbolizers.getJSONObject(1).getJSONObject("Line");
        Assert.assertFalse((boolean)lineSymb1.isNullObject());
        Assert.assertEquals((Object)"10", (Object)lineSymb.get("perpendicular-offset"));
        JSONObject graphicStroke1 = lineSymb1.getJSONObject("graphic-stroke");
        Assert.assertFalse((boolean)graphicStroke1.isNullObject());
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/Default%20Styler?0.0.0=&0.0.0.rotation=0.0&npg=true", (Object)graphicStroke1.getString("url"));
        JSONObject lineSymb2 = symbolizers.getJSONObject(2).getJSONObject("Line");
        Assert.assertFalse((boolean)lineSymb2.isNullObject());
        JSONObject graphicFill2 = lineSymb2.getJSONObject("graphic-fill");
        Assert.assertFalse((boolean)graphicFill2.isNullObject());
        Assert.assertEquals((Object)"http://local-test:8080/geoserver/kml/icon/Default%20Styler?0.0.1=&0.0.1.rotation=0.0&npg=true", (Object)graphicFill2.getString("url"));
    }

    @Test
    public void testSimplePolygon() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("polygon.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb = symbolizers.getJSONObject(0).getJSONObject("Polygon");
        Assert.assertNotNull((Object)polySymb);
        Assert.assertEquals((Object)"#0099CC", (Object)polySymb.get("fill"));
        Assert.assertEquals((Object)"#000000", (Object)polySymb.get("stroke"));
        Assert.assertEquals((Object)"0.5", (Object)polySymb.get("stroke-width"));
    }

    @Test
    public void testFullPolygon() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("full_polygon.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb = symbolizers.getJSONObject(0).getJSONObject("Polygon");
        Assert.assertNotNull((Object)polySymb);
        Assert.assertEquals((Object)"#0099CC", (Object)polySymb.get("fill"));
        Assert.assertEquals((Object)"#000000", (Object)polySymb.get("stroke"));
        Assert.assertEquals((Object)"0.5", (Object)polySymb.get("stroke-width"));
        JSONObject polySymb2 = symbolizers.getJSONObject(1).getJSONObject("Polygon");
        Assert.assertFalse((polySymb2.isNullObject() && polySymb2.isEmpty() ? 1 : 0) != 0);
        JSONObject stroke = polySymb2.getJSONObject("graphic-stroke");
        Assert.assertFalse((stroke.isNullObject() && stroke.isEmpty() ? 1 : 0) != 0);
        JSONObject fill = polySymb2.getJSONObject("graphic-fill");
        Assert.assertFalse((fill.isNullObject() && fill.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleText() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("text.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertNotNull((Object)result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb = symbolizers.getJSONObject(0).getJSONObject("Line");
        Assert.assertNotNull((Object)polySymb);
        Assert.assertEquals((Object)"#000000", (Object)polySymb.get("stroke"));
        Assert.assertEquals((Object)"0.2", (Object)polySymb.get("stroke-width"));
        JSONObject textSymb = symbolizers.getJSONObject(1).getJSONObject("Text");
        Assert.assertFalse((boolean)textSymb.isNullObject());
        Assert.assertEquals((Object)"[STATE_ABBR]", (Object)textSymb.getString("label"));
        JSONArray fonts = textSymb.getJSONArray("fonts");
        Assert.assertEquals((long)2L, (long)fonts.size());
        Assert.assertEquals((Object)"[STATE_FONT]", (Object)fonts.getJSONObject(0).getJSONArray("font-family").get(0));
        Assert.assertEquals((Object)"Lobster", (Object)fonts.getJSONObject(0).getJSONArray("font-family").get(1));
        Assert.assertEquals((Object)"Times New Roman", (Object)fonts.getJSONObject(0).getJSONArray("font-family").get(2));
        Assert.assertEquals((Object)"Normal", (Object)fonts.getJSONObject(0).get("font-style"));
        Assert.assertEquals((Object)"normal", (Object)fonts.getJSONObject(0).get("font-weight"));
        Assert.assertEquals((Object)"14", (Object)fonts.getJSONObject(0).get("font-size"));
        Assert.assertEquals((Object)"Times New Roman", (Object)fonts.getJSONObject(1).getJSONArray("font-family").get(0));
        Assert.assertEquals((Object)"Italic", (Object)fonts.getJSONObject(1).get("font-style"));
        Assert.assertEquals((Object)"normal", (Object)fonts.getJSONObject(1).get("font-weight"));
        Assert.assertEquals((Object)"9", (Object)fonts.getJSONObject(1).get("font-size"));
        Assert.assertFalse((boolean)textSymb.getJSONObject("label-placement").isNullObject());
        Assert.assertFalse((boolean)textSymb.getJSONObject("halo").isNullObject());
        JSONObject vops = textSymb.getJSONObject("vendor-options");
        this.assertNotEmpty(vops);
        Assert.assertEquals((Object)"true", (Object)vops.get("followLine"));
    }

    @Test
    public void testComplexText() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style style = this.readSLD("text_scaleSize.sld");
        req.setStyle(style);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject polySymb = symbolizers.getJSONObject(0).getJSONObject("Line");
        Assert.assertNotNull((Object)polySymb);
        Assert.assertEquals((Object)"#000000", (Object)polySymb.get("stroke"));
        Assert.assertEquals((Object)"0.2", (Object)polySymb.get("stroke-width"));
        JSONObject textSymb = symbolizers.getJSONObject(1).getJSONObject("Text");
        Assert.assertFalse((boolean)textSymb.isNullObject());
        Assert.assertEquals((Object)"[STATE_ABBR]", (Object)textSymb.getString("label"));
        JSONArray fonts = textSymb.getJSONArray("fonts");
        Assert.assertEquals((long)2L, (long)fonts.size());
        Assert.assertEquals((Object)"9", (Object)fonts.getJSONObject(1).get("font-size"));
    }

    @Test
    public void testContrastRaster() throws Exception {
        Style multipleRulesStyle = this.readSLD("raster_brightness.sld");
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = this.getRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(multipleRulesStyle);
        req.setLegendOptions(new HashMap());
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject rasterSymb = symbolizers.getJSONObject(0).getJSONObject("Raster");
        this.assertNotEmpty(rasterSymb);
        JSONObject ce = rasterSymb.getJSONObject("contrast-enhancement");
        this.assertNotEmpty(ce);
        Assert.assertEquals((Object)"0.5", (Object)ce.getString("gamma-value"));
        Assert.assertEquals((Object)"true", (Object)ce.get("normalize"));
    }

    @Test
    public void testDescreteRaster() throws Exception {
        Style multipleRulesStyle = this.readSLD("raster_discretecolors.sld");
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(WMS.get());
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
        req.setLayer(feature.getSchema());
        req.setStyle(multipleRulesStyle);
        req.setLegendOptions(new HashMap());
        req.setFormat(JSONFormat);
        JSONObject result = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotEmpty(result);
        JSONArray legend = result.getJSONArray("Legend");
        Assert.assertNotNull((Object)legend);
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertNotNull((Object)rules);
        Assert.assertFalse((boolean)rules.isEmpty());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertNotNull((Object)symbolizers);
        Assert.assertFalse((boolean)symbolizers.isEmpty());
        JSONObject rasterSymb = symbolizers.getJSONObject(0).getJSONObject("Raster");
        this.assertNotEmpty(rasterSymb);
        JSONObject ce = rasterSymb.getJSONObject("contrast-enhancement");
        Assert.assertTrue((boolean)ce.isEmpty());
        JSONObject colormap = rasterSymb.getJSONObject("colormap");
        Assert.assertEquals((Object)"intervals", (Object)colormap.get("type"));
    }

    @Test
    public void testLegendSelectionInRule() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOLYGONS.getNamespaceURI(), MockData.MPOLYGONS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.getCatalog().getStyleByName("styleWithLegendSelection").getStyle());
        req.setFormat(JSONFormat);
        JSONObject jsonLegend = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        JSONArray legend = jsonLegend.getJSONArray("Legend");
        JSONArray rules = legend.getJSONObject(0).getJSONArray("rules");
        Assert.assertEquals((long)1L, (long)rules.size());
        String ruleName = rules.getJSONObject(0).getString("name");
        Assert.assertEquals((Object)"nationalpark", (Object)ruleName);
    }

    @Test
    public void testLegendSelectionInSymbolizer() throws Exception {
        GetLegendGraphicRequest req = this.getRequest();
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOLYGONS.getNamespaceURI(), MockData.MPOLYGONS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.getCatalog().getStyleByName("styleWithLegendSelectionOnSymbolizer").getStyle());
        req.setFormat(JSONFormat);
        JSONObject jsonLegend = ((JSONLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        JSONArray rules = jsonLegend.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Assert.assertEquals((long)1L, (long)rules.size());
        JSONArray symbolizers = rules.getJSONObject(0).getJSONArray("symbolizers");
        Assert.assertEquals((long)1L, (long)symbolizers.size());
    }

    @Test
    public void testLanguageVector() throws Exception {
        String base = "wms?request=GetLegendGraphic&layer=MPolygons&style=multiLanguageVector&format=application/json&legend_options=hideEmptyRules:true";
        this.checkLanguageRule("it", base);
        this.checkLanguageRule("de", base);
    }

    @Test
    public void testLanguageRaster() throws Exception {
        String base = "wms?request=GetLegendGraphic&layer=MPolygons&style=multiLanguageRaster&format=application/json&legend_options=hideEmptyRules:true";
        this.checkLanguageRule(null, base);
        this.checkLanguageRule("", base);
        this.checkLanguageRule("it", base);
        this.checkLanguageRule("de", base);
    }

    @Test
    public void testGroupDefaultStyle() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("wms?request=GetLegendGraphic&layer=nature&style=default-style-nature&format=application/json");
        JSONArray legend = json.getJSONArray("Legend");
        Assert.assertEquals((long)2L, (long)legend.size());
        Assert.assertEquals((Object)"Lakes", (Object)legend.getJSONObject(0).getString("layerName"));
        Assert.assertEquals((Object)"Forests", (Object)legend.getJSONObject(1).getString("layerName"));
    }

    @Test
    public void testGroupInvalidStyleName() throws Exception {
        Document dom = this.getAsDOM("wms?request=GetLegendGraphic&layer=nature&style=notAStyleName&format=application/json");
        XMLAssert.assertXpathEvaluatesTo((String)"StyleNotDefined", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String exception = xpath.evaluate("/ogc:ServiceExceptionReport/ogc:ServiceException", dom);
        Assert.assertEquals((Object)"No such style: notAStyleName", (Object)exception.trim());
    }

    private void checkLanguageRule(String lang, String base) throws Exception {
        Object suffix = lang != null ? "&language=" + lang : "";
        JSONObject json = (JSONObject)this.getAsJSON(base + (String)suffix, 200);
        this.print((JSON)json);
        JSONArray rules = json.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Assert.assertEquals((long)1L, (long)rules.size());
        String filter = rules.getJSONObject(0).getString("filter");
        if (lang != null) {
            Assert.assertEquals((Object)("[language() = '" + lang + "']"), (Object)filter);
        } else {
            Assert.assertEquals((Object)"[language() = '']", (Object)filter);
        }
    }

    private void assertNotEmpty(JSONObject result) {
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isNullObject());
        Assert.assertFalse((boolean)result.isEmpty());
    }

    private Style readSLD(String sldName) throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        SLDParser stylereader = new SLDParser(styleFactory, ((Object)((Object)this)).getClass().getResource(sldName));
        Style[] readStyles = stylereader.readXML();
        Style style = readStyles[0];
        return style;
    }

    private void printStyle(Style style) throws TransformerException {
        if (JSONLegendGraphicOutputFormatTest.isQuietTests()) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SLDTransformer transformer = new SLDTransformer();
        transformer.setIndentation(2);
        transformer.transform((Object)style, (OutputStream)bos);
        String styleStr = bos.toString();
        System.out.println(styleStr);
    }

    private GetLegendGraphicRequest getRequest() {
        return this.getRequest(null, null);
    }

    private GetLegendGraphicRequest getRequest(FeatureType layer, Style style) {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(WMS.get());
        req.setBaseUrl("http://local-test:8080/geoserver");
        req.setLayer(layer);
        req.setStyle(style);
        req.setFormat(JSONFormat);
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLayerGroupStyleSingle() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            String lgStyleName = "nature-style";
            String lgName = "single_lake_and_places";
            LayerInfo forestL = this.getCatalog().getLayerByName("cite:Forests");
            LayerInfo lakesL = this.getCatalog().getLayerByName("cite:Lakes");
            group = this.lakesAndPlacesWithGroupStyle(lgName, LayerGroupInfo.Mode.SINGLE, lgStyleName, Arrays.asList(forestL, lakesL), Arrays.asList(null, null));
            String url = "wms?LAYER=" + group.getName() + "&STYLE=nature-style&FORMAT=application/json&SERVICE=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&WIDTH=20&HEIGHT=20";
            JSONObject legend = (JSONObject)this.getAsJSON(url);
            JSONObject forest = legend.getJSONArray("Legend").getJSONObject(0);
            JSONObject lakes = legend.getJSONArray("Legend").getJSONObject(1);
            Assert.assertEquals((Object)"Forests", (Object)forest.get("layerName"));
            Assert.assertEquals((Object)"Lakes", (Object)lakes.get("layerName"));
            if (group == null) return;
        }
        catch (Throwable throwable) {
            if (group == null) throw throwable;
            catalog.remove(group);
            throw throwable;
        }
        catalog.remove(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLayerGroupStyleOpaque() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            String lgStyleName = "nature-style";
            String lgName = "opaque_lakes_and_places";
            LayerInfo forestL = this.getCatalog().getLayerByName("cite:Forests");
            LayerInfo lakesL = this.getCatalog().getLayerByName("cite:Lakes");
            group = this.lakesAndPlacesWithGroupStyle(lgName, LayerGroupInfo.Mode.OPAQUE_CONTAINER, lgStyleName, Arrays.asList(forestL, lakesL), Arrays.asList(null, null));
            String url = "wms?LAYER=" + group.getName() + "&STYLE=nature-style&FORMAT=application/json&SERVICE=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&WIDTH=20&HEIGHT=20";
            JSONObject legend = (JSONObject)this.getAsJSON(url);
            JSONObject forest = legend.getJSONArray("Legend").getJSONObject(0);
            JSONObject lakes = legend.getJSONArray("Legend").getJSONObject(1);
            Assert.assertEquals((Object)"Forests", (Object)forest.get("layerName"));
            Assert.assertEquals((Object)"Lakes", (Object)lakes.get("layerName"));
            if (group == null) return;
        }
        catch (Throwable throwable) {
            if (group == null) throw throwable;
            catalog.remove(group);
            throw throwable;
        }
        catalog.remove(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedGroupWithStyle() throws Exception {
        Catalog catalog;
        LayerGroupInfo nested;
        block5: {
            nested = null;
            LayerGroupInfo container = null;
            catalog = this.getCatalog();
            try {
                String lgName = "nested-lakes_and_places_group";
                LayerInfo forestL = this.getCatalog().getLayerByName("cite:Forests");
                ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
                styles.add(null);
                nested = this.lakesAndPlacesWithGroupStyle(lgName, LayerGroupInfo.Mode.SINGLE, "forest-style", Arrays.asList(forestL), styles);
                this.createLakesPlacesLayerGroup(catalog, "lakes-and-place", LayerGroupInfo.Mode.SINGLE, null);
                container = catalog.getLayerGroupByName("lakes-and-place");
                container.getLayers().add(0, nested);
                container.getStyles().add(0, ((LayerGroupStyle)nested.getLayerGroupStyles().get(0)).getName());
                catalog.save(container);
                String url = "wms?LAYER=" + container.getName() + "&STYLE=&FORMAT=application/json&SERVICE=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&WIDTH=20&HEIGHT=20";
                JSONObject legend = (JSONObject)this.getAsJSON(url);
                JSONObject forest = legend.getJSONArray("Legend").getJSONObject(0);
                JSONObject lakes = legend.getJSONArray("Legend").getJSONObject(1);
                JSONObject places = legend.getJSONArray("Legend").getJSONObject(2);
                Assert.assertEquals((Object)"Forests", (Object)forest.get("layerName"));
                Assert.assertEquals((Object)"Lakes", (Object)lakes.get("layerName"));
                Assert.assertEquals((Object)"NamedPlaces", (Object)places.get("layerName"));
                if (container == null) break block5;
            }
            catch (Throwable throwable) {
                if (container != null) {
                    catalog.remove(container);
                }
                if (nested != null) {
                    catalog.remove(nested);
                }
                throw throwable;
            }
            catalog.remove(container);
        }
        if (nested != null) {
            catalog.remove(nested);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLayerGroupStyleIngnoredIfTree() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = null;
        try {
            String lgName = "lakes_and_places_named";
            LayerInfo forestL = this.getCatalog().getLayerByName("cite:Forests");
            LayerInfo lakesL = this.getCatalog().getLayerByName("cite:Lakes");
            group = this.lakesAndPlacesWithGroupStyle(lgName, LayerGroupInfo.Mode.NAMED, "nature-style", Arrays.asList(forestL, lakesL), Arrays.asList(null, null));
            String url = "wms?LAYER=" + group.getName() + "&STYLE=nature-style&FORMAT=application/json&SERVICE=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&WIDTH=20&HEIGHT=20";
            JSONObject legend = (JSONObject)this.getAsJSON(url);
            JSONObject lakes = legend.getJSONArray("Legend").getJSONObject(0);
            JSONObject places = legend.getJSONArray("Legend").getJSONObject(1);
            Assert.assertEquals((Object)"Lakes", (Object)lakes.get("layerName"));
            Assert.assertEquals((Object)"NamedPlaces", (Object)places.get("layerName"));
            if (group == null) return;
        }
        catch (Throwable throwable) {
            if (group == null) throw throwable;
            catalog.remove(group);
            throw throwable;
        }
        catalog.remove(group);
    }

    @Test
    public void testHideEmptyRules() throws Exception {
        String url = "wms?LAYER=" + MockData.NAMED_PLACES.getLocalPart() + "&FORMAT=application/json&SERVICE=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&WIDTH=20&HEIGHT=20";
        JSONObject legend = (JSONObject)this.getAsJSON(url);
        JSONArray rules = legend.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertEquals((Object)"ashton", (Object)rules.getJSONObject(0).getString("name"));
        Assert.assertEquals((Object)"goose_island", (Object)rules.getJSONObject(1).getString("name"));
        url = url + "&LEGEND_OPTIONS=hideEmptyRules:true&BBOX=0,0,0.1,0.1";
        legend = (JSONObject)this.getAsJSON(url);
        rules = legend.getJSONArray("Legend").getJSONObject(0).getJSONArray("rules");
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)"ashton", (Object)rules.getJSONObject(0).getString("name"));
    }
}

