/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.BufferedImage;
import java.awt.image.SampleModel;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.legendgraphic.ImageList;
import org.geoserver.wms.legendgraphic.Tally;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ImageListTest {
    @Test
    public void testAddingToImageListWithoutExceedingMemoryLimit() {
        Tally tally = new Tally(100000L);
        ImageList imageList = new ImageList(tally);
        BufferedImage renderedImage = (BufferedImage)Mockito.mock(BufferedImage.class);
        SampleModel sampleModel = (SampleModel)Mockito.mock(SampleModel.class);
        int[] sampleSize = new int[]{100, 100, 200, 500};
        Mockito.when((Object)renderedImage.getSampleModel()).thenReturn((Object)sampleModel);
        Mockito.when((Object)sampleModel.getSampleSize()).thenReturn((Object)sampleSize);
        Mockito.when((Object)renderedImage.getWidth()).thenReturn((Object)10);
        Mockito.when((Object)renderedImage.getHeight()).thenReturn((Object)10);
        imageList.add(renderedImage);
        Assert.assertEquals((long)1L, (long)imageList.size());
    }

    @Test(expected=ServiceException.class)
    public void testExceedingMaxMemoryWhenAddingToImageList() {
        Tally tally = new Tally(1000L);
        ImageList imageList = new ImageList(tally);
        BufferedImage renderedImage = (BufferedImage)Mockito.mock(BufferedImage.class);
        SampleModel sampleModel = (SampleModel)Mockito.mock(SampleModel.class);
        int[] sampleSize = new int[]{100, 100, 200, 500};
        Mockito.when((Object)renderedImage.getSampleModel()).thenReturn((Object)sampleModel);
        Mockito.when((Object)sampleModel.getSampleSize()).thenReturn((Object)sampleSize);
        Mockito.when((Object)renderedImage.getWidth()).thenReturn((Object)10);
        Mockito.when((Object)renderedImage.getHeight()).thenReturn((Object)10);
        imageList.add(renderedImage);
    }
}

