/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Collections;
import javax.imageio.ImageIO;
import org.geoserver.wms.icons.IconRenderer;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.image.test.ImageAssert;
import org.junit.Assert;
import org.junit.Test;

public class IconRendererTest {
    static final int THRESHOLD = 400;

    @Test
    public void testSimpleCircle() throws Exception {
        StyleFactory sfact = CommonFactoryFinder.getStyleFactory();
        FilterFactory ffact = CommonFactoryFinder.getFilterFactory();
        Mark m = sfact.mark((Expression)ffact.literal((Object)"circle"), sfact.fill(null, (Expression)ffact.literal((Object)"#FF0000"), null), sfact.stroke((Expression)ffact.literal((Object)"#000000"), null, (Expression)ffact.literal(1), null, null, null, null));
        Graphic g = sfact.graphic(Arrays.asList(m), Expression.NIL, Expression.NIL, Expression.NIL, null, null);
        PointSymbolizer symb = sfact.pointSymbolizer(null, (Expression)ffact.property((String)null), null, null, g);
        Rule r = sfact.rule(null, null, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Arrays.asList(symb), null);
        FeatureTypeStyle fts = sfact.featureTypeStyle(null, null, null, Collections.emptySet(), Collections.emptySet(), Arrays.asList(r));
        Style s = sfact.style(null, null, true, Arrays.asList(fts), null);
        BufferedImage img = IconRenderer.renderIcon((Style)s);
        int size = 76;
        Assert.assertEquals((long)76L, (long)img.getHeight());
        Assert.assertEquals((long)76L, (long)img.getWidth());
        BufferedImage expected = ImageIO.read(this.getClass().getResource("circle-red-16-x4.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)img, (int)400);
    }

    @Test
    public void testSimpleSquare() throws Exception {
        StyleFactory sfact = CommonFactoryFinder.getStyleFactory();
        FilterFactory ffact = CommonFactoryFinder.getFilterFactory();
        Mark m = sfact.mark((Expression)ffact.literal((Object)"square"), sfact.fill(null, (Expression)ffact.literal((Object)"#0000FF"), null), sfact.stroke((Expression)ffact.literal((Object)"#000000"), null, (Expression)ffact.literal(1), null, null, null, null));
        Graphic g = sfact.graphic(Arrays.asList(m), Expression.NIL, Expression.NIL, Expression.NIL, null, null);
        PointSymbolizer symb = sfact.pointSymbolizer(null, (Expression)ffact.property((String)null), null, null, g);
        Rule r = sfact.rule(null, null, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Arrays.asList(symb), null);
        FeatureTypeStyle fts = sfact.featureTypeStyle(null, null, null, Collections.emptySet(), Collections.emptySet(), Arrays.asList(r));
        Style s = sfact.style(null, null, true, Arrays.asList(fts), null);
        BufferedImage img = IconRenderer.renderIcon((Style)s);
        int size = 76;
        Assert.assertEquals((long)76L, (long)img.getHeight());
        Assert.assertEquals((long)76L, (long)img.getWidth());
        BufferedImage expected = ImageIO.read(this.getClass().getResource("square-blue-16-x4.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)img, (int)400);
    }

    @Test
    public void testSquareRotated45() throws Exception {
        StyleFactory sfact = CommonFactoryFinder.getStyleFactory();
        FilterFactory ffact = CommonFactoryFinder.getFilterFactory();
        Mark m = sfact.mark((Expression)ffact.literal((Object)"square"), sfact.fill(null, (Expression)ffact.literal((Object)"#0000FF"), null), sfact.stroke((Expression)ffact.literal((Object)"#000000"), null, (Expression)ffact.literal(1), null, null, null, null));
        Graphic g = sfact.graphic(Arrays.asList(m), Expression.NIL, Expression.NIL, (Expression)ffact.literal(45.0), null, null);
        PointSymbolizer symb = sfact.pointSymbolizer(null, (Expression)ffact.property((String)null), null, null, g);
        Rule r = sfact.rule(null, null, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Arrays.asList(symb), null);
        FeatureTypeStyle fts = sfact.featureTypeStyle(null, null, null, Collections.emptySet(), Collections.emptySet(), Arrays.asList(r));
        Style s = sfact.style(null, null, true, Arrays.asList(fts), null);
        BufferedImage img = IconRenderer.renderIcon((Style)s);
        int baseSize = 16;
        int rotated = (int)Math.ceil(16.0 * Math.sqrt(2.0));
        int size = (rotated + 1 + 1 + 1) * 4;
        Assert.assertEquals((long)size, (long)img.getHeight());
        Assert.assertEquals((long)size, (long)img.getWidth());
        BufferedImage expected = ImageIO.read(this.getClass().getResource("square-blue-16-x4-45deg.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)img, (int)400);
    }

    @Test
    public void testExternalImage() throws Exception {
        StyleFactory sfact = CommonFactoryFinder.getStyleFactory();
        FilterFactory ffact = CommonFactoryFinder.getFilterFactory();
        ExternalGraphic gs = sfact.createExternalGraphic(this.getClass().getResource("arrow-16.png"), "image/png");
        Graphic g = sfact.graphic(Arrays.asList(gs), Expression.NIL, Expression.NIL, Expression.NIL, null, null);
        PointSymbolizer symb = sfact.pointSymbolizer(null, (Expression)ffact.property((String)null), null, null, g);
        Rule r = sfact.rule(null, null, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Arrays.asList(symb), null);
        FeatureTypeStyle fts = sfact.featureTypeStyle(null, null, null, Collections.emptySet(), Collections.emptySet(), Arrays.asList(r));
        Style s = sfact.style(null, null, true, Arrays.asList(fts), null);
        BufferedImage img = IconRenderer.renderIcon((Style)s);
        int size = 72;
        Assert.assertEquals((long)72L, (long)img.getHeight());
        Assert.assertEquals((long)72L, (long)img.getWidth());
        BufferedImage expected = ImageIO.read(this.getClass().getResource("arrow-16-x4.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)img, (int)400);
    }

    @Test
    public void testExternalImageRotated45() throws Exception {
        StyleFactory sfact = CommonFactoryFinder.getStyleFactory();
        FilterFactory ffact = CommonFactoryFinder.getFilterFactory();
        ExternalGraphic gs = sfact.createExternalGraphic(this.getClass().getResource("arrow-16.png"), "image/png");
        Graphic g = sfact.graphic(Arrays.asList(gs), Expression.NIL, Expression.NIL, (Expression)ffact.literal(45.0), null, null);
        PointSymbolizer symb = sfact.pointSymbolizer(null, (Expression)ffact.property((String)null), null, null, g);
        Rule r = sfact.rule(null, null, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Arrays.asList(symb), null);
        FeatureTypeStyle fts = sfact.featureTypeStyle(null, null, null, Collections.emptySet(), Collections.emptySet(), Arrays.asList(r));
        Style s = sfact.style(null, null, true, Arrays.asList(fts), null);
        BufferedImage img = IconRenderer.renderIcon((Style)s);
        int baseSize = 16;
        int rotated = (int)Math.ceil(16.0 * Math.sqrt(2.0));
        int size = (rotated + 0 + 1 + 1) * 4;
        Assert.assertEquals((long)size, (long)img.getHeight());
        Assert.assertEquals((long)size, (long)img.getWidth());
        BufferedImage expected = ImageIO.read(this.getClass().getResource("arrow-16-x4-45deg.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)img, (int)400);
    }

    @Test
    public void testBigExternalImage() throws Exception {
        StyleFactory sfact = CommonFactoryFinder.getStyleFactory();
        FilterFactory ffact = CommonFactoryFinder.getFilterFactory();
        ExternalGraphic gs = sfact.createExternalGraphic(this.getClass().getResource("planet-42.png"), "image/png");
        Graphic g = sfact.graphic(Arrays.asList(gs), Expression.NIL, Expression.NIL, Expression.NIL, null, null);
        PointSymbolizer symb = sfact.pointSymbolizer(null, (Expression)ffact.property((String)null), null, null, g);
        Rule r = sfact.rule(null, null, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Arrays.asList(symb), null);
        FeatureTypeStyle fts = sfact.featureTypeStyle(null, null, null, Collections.emptySet(), Collections.emptySet(), Arrays.asList(r));
        Style s = sfact.style(null, null, true, Arrays.asList(fts), null);
        BufferedImage img = IconRenderer.renderIcon((Style)s);
        int size = 176;
        Assert.assertEquals((long)176L, (long)img.getHeight());
        Assert.assertEquals((long)176L, (long)img.getWidth());
        BufferedImage expected = ImageIO.read(this.getClass().getResource("planet-42-x4.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)img, (int)400);
    }

    @Test
    public void testBigExternalImageSpecifySize() throws Exception {
        StyleFactory sfact = CommonFactoryFinder.getStyleFactory();
        FilterFactory ffact = CommonFactoryFinder.getFilterFactory();
        ExternalGraphic gs = sfact.createExternalGraphic(this.getClass().getResource("planet-42.png"), "image/png");
        Graphic g = sfact.graphic(Arrays.asList(gs), Expression.NIL, (Expression)ffact.literal(42), Expression.NIL, null, null);
        PointSymbolizer symb = sfact.pointSymbolizer(null, (Expression)ffact.property((String)null), null, null, g);
        Rule r = sfact.rule(null, null, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Arrays.asList(symb), null);
        FeatureTypeStyle fts = sfact.featureTypeStyle(null, null, null, Collections.emptySet(), Collections.emptySet(), Arrays.asList(r));
        Style s = sfact.style(null, null, true, Arrays.asList(fts), null);
        BufferedImage img = IconRenderer.renderIcon((Style)s);
        int size = 176;
        Assert.assertEquals((long)176L, (long)img.getHeight());
        Assert.assertEquals((long)176L, (long)img.getWidth());
        BufferedImage expected = ImageIO.read(this.getClass().getResource("planet-42-x4.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)img, (int)400);
    }

    @Test
    public void testBigExternalImageNilExpressionSize() throws Exception {
        StyleFactory sfact = CommonFactoryFinder.getStyleFactory();
        FilterFactory ffact = CommonFactoryFinder.getFilterFactory();
        ExternalGraphic gs = sfact.createExternalGraphic(this.getClass().getResource("planet-42.png"), "image/png");
        Graphic g = sfact.graphic(Arrays.asList(gs), Expression.NIL, Expression.NIL, Expression.NIL, null, null);
        PointSymbolizer symb = sfact.pointSymbolizer(null, (Expression)ffact.property((String)null), null, null, g);
        Rule r = sfact.rule(null, null, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Arrays.asList(symb), null);
        FeatureTypeStyle fts = sfact.featureTypeStyle(null, null, null, Collections.emptySet(), Collections.emptySet(), Arrays.asList(r));
        Style s = sfact.style(null, null, true, Arrays.asList(fts), null);
        BufferedImage img = IconRenderer.renderIcon((Style)s);
        int size = 176;
        Assert.assertEquals((long)176L, (long)img.getHeight());
        Assert.assertEquals((long)176L, (long)img.getWidth());
        BufferedImage expected = ImageIO.read(this.getClass().getResource("planet-42-x4.png"));
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)img, (int)400);
    }
}

