/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.wms.icons.IconProperties;
import org.geoserver.wms.icons.IconPropertyExtractor;
import org.geoserver.wms.icons.IconTestSupport;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IconPropertiesTest
extends IconTestSupport {
    private static final WorkspaceInfo workspace = new WorkspaceInfoImpl();

    @BeforeClass
    public static void setup() throws UnsupportedEncodingException {
        workspace.setName("workspace");
    }

    @Test
    public void testSimpleStyleEncodesNoProperties() {
        Style simple = this.styleFromRules(this.catchAllRule(new Symbolizer[]{this.grayCircle()}));
        Assert.assertEquals((Object)"0.0.0=", (Object)this.encode(simple, fieldIs1));
    }

    @Test
    public void testWorkspacedStyleEncodesNoProperties() {
        Style simple = this.styleFromRules(this.catchAllRule(new Symbolizer[]{this.grayCircle()}));
        Assert.assertEquals((Object)"0.0.0=", (Object)this.encode(workspace, simple, fieldIs1));
    }

    @Test
    public void testFilters() throws CQLException {
        PointSymbolizer symbolizer = this.grayCircle();
        Rule a = this.rule(ECQL.toFilter((String)"field = 1"), new Symbolizer[]{symbolizer});
        Rule b = this.rule(ECQL.toFilter((String)"field = 2"), new Symbolizer[]{symbolizer});
        Style style = this.styleFromRules(a, b);
        Assert.assertEquals((Object)"0.0.0=", (Object)this.encode(style, fieldIs1));
        Assert.assertEquals((Object)"0.1.0=", (Object)this.encode(style, fieldIs2));
    }

    @Test
    public void testMultipleSymbolizers() {
        PointSymbolizer symbolizer = this.grayCircle();
        Rule a = this.catchAllRule(new Symbolizer[]{symbolizer, symbolizer});
        Style style = this.styleFromRules(a);
        Assert.assertEquals((Object)"0.0.0=&0.0.1=", (Object)this.encode(style, fieldIs1));
    }

    @Test
    public void testMultipleFeatureTypeStyle() {
        PointSymbolizer symbolizer = this.grayCircle();
        Style s = this.style(this.featureTypeStyle(this.catchAllRule(new Symbolizer[]{symbolizer})), this.featureTypeStyle(this.catchAllRule(new Symbolizer[]{symbolizer})));
        Assert.assertEquals((Object)"0.0.0=&1.0.0=", (Object)this.encode(s, fieldIs1));
    }

    @Test
    public void testElseFilter() throws CQLException {
        PointSymbolizer symbolizer = this.grayCircle();
        Style style = this.styleFromRules(this.rule(ECQL.toFilter((String)"field = 1"), new Symbolizer[]{symbolizer}), this.elseRule(new Symbolizer[]{symbolizer}));
        Assert.assertEquals((Object)"0.0.0=", (Object)this.encode(style, fieldIs1));
        Assert.assertEquals((Object)"0.1.0=", (Object)this.encode(style, fieldIs2));
    }

    @Test
    public void testDynamicMark() throws CQLException {
        PointSymbolizer symbolizer = this.grayCircle();
        Mark mark = (Mark)symbolizer.getGraphic().graphicalSymbols().get(0);
        mark.setWellKnownName(ECQL.toExpression((String)"if_then_else(equalTo(field, 1), 'circle', 'square')"));
        Style s = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.name=circle", (Object)this.encode(s, fieldIs1));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.name=square", (Object)this.encode(s, fieldIs2));
    }

    @Test
    public void testDynamicColor() throws CQLException {
        Expression color = ECQL.toExpression((String)"if_then_else(equalTo(field, 1), '#8080C0', '#CC8030')");
        Stroke stroke = styleFactory.stroke(color, null, null, null, null, null, null);
        Fill fill = styleFactory.fill(null, color, null);
        Mark mark = styleFactory.mark(ECQL.toExpression((String)"circle"), fill, stroke);
        Graphic graphic = styleFactory.graphic(Collections.singletonList(mark), null, null, null, null, null);
        PointSymbolizer symbolizer = styleFactory.pointSymbolizer("symbolizer", ECQL.toExpression((String)"geom"), null, null, graphic);
        Style s = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.fill.color=%238080C0&0.0.0.name=square&0.0.0.stroke.color=%238080C0", (Object)this.encode(s, fieldIs1));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.fill.color=%23CC8030&0.0.0.name=square&0.0.0.stroke.color=%23CC8030", (Object)this.encode(s, fieldIs2));
    }

    @Test
    public void testDynamicOpacity() throws CQLException {
        PointSymbolizer symbolizer = this.grayCircle();
        Graphic graphic = symbolizer.getGraphic();
        graphic.setOpacity(ECQL.toExpression((String)"1 / field"));
        Style s = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.opacity=1.0", (Object)this.encode(s, fieldIs1));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.opacity=0.5", (Object)this.encode(s, fieldIs2));
    }

    @Test
    public void testDynamicRotation() throws CQLException {
        PointSymbolizer symbolizer = this.grayCircle();
        Graphic graphic = symbolizer.getGraphic();
        graphic.setRotation(ECQL.toExpression((String)"45 * field"));
        Style s = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.rotation=45.0", (Object)this.encode(s, fieldIs1));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.rotation=90.0", (Object)this.encode(s, fieldIs2));
    }

    @Test
    public void testDynamicSize() throws CQLException {
        PointSymbolizer symbolizer = this.grayCircle();
        Graphic graphic = symbolizer.getGraphic();
        graphic.setSize(ECQL.toExpression((String)"field * 16"));
        Style s = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.size=16.0", (Object)this.encode(s, fieldIs1));
        Assert.assertEquals((Object)"0.0.0=&0.0.0.size=32.0", (Object)this.encode(s, fieldIs2));
    }

    @Test
    public void testDynamicURL() throws CQLException, UnsupportedEncodingException {
        PointSymbolizer symbolizer = this.externalGraphic("http://127.0.0.1/foo${field}.png", "image/png");
        Style style = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer, symbolizer}));
        String url = URLEncoder.encode("http://127.0.0.1/", "UTF-8");
        Assert.assertEquals((Object)("0.0.0=&0.0.0.url=" + url + "foo1.png&0.0.1=&0.0.1.url=" + url + "foo1.png"), (Object)this.encode(style, fieldIs1));
        Assert.assertEquals((Object)("0.0.0=&0.0.0.url=" + url + "foo2.png&0.0.1=&0.0.1.url=" + url + "foo2.png"), (Object)this.encode(style, fieldIs2));
    }

    @Test
    public void testPublicURL() throws CQLException {
        PointSymbolizer symbolizer = this.externalGraphic("http://127.0.0.1/foo.png", "image/png");
        Style style = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        Assert.assertEquals((Object)"http://127.0.0.1/foo.png", (Object)this.encode(style, fieldIs1));
    }

    @Test
    public void testLocalFile() throws Exception {
        PointSymbolizer symbolizer = this.externalGraphic("file:foo.png", "image/png");
        Style style = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        Assert.assertEquals((Object)"http://127.0.0.1/styles/foo.png", (Object)this.encode(style, fieldIs1));
    }

    @Test
    public void testLocalFileRotate() throws Exception {
        PointSymbolizer symbolizer = this.externalGraphic("file:foo.png", "image/png");
        Graphic graphic = symbolizer.getGraphic();
        graphic.setRotation(ECQL.toExpression((String)"45 * field"));
        Style style = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        IconProperties prop1 = IconPropertyExtractor.extractProperties((Style)style, (SimpleFeature)fieldIs1);
        Assert.assertEquals((Object)"http://127.0.0.1/styles/foo.png", (Object)prop1.href("http://127.0.0.1/", null, "test"));
        Assert.assertEquals((double)45.0, (double)prop1.getHeading(), (double)1.0E-4);
        IconProperties prop2 = IconPropertyExtractor.extractProperties((Style)style, (SimpleFeature)fieldIs2);
        Assert.assertEquals((Object)"http://127.0.0.1/styles/foo.png", (Object)prop2.href("http://127.0.0.1/", null, "test"));
        Assert.assertEquals((double)90.0, (double)prop2.getHeading(), (double)1.0E-4);
    }

    @Test
    public void testTwoLocalFilesRotate() throws Exception {
        PointSymbolizer symbolizer1 = this.externalGraphic("file:foo.png", "image/png");
        PointSymbolizer symbolizer2 = this.externalGraphic("file:bar.png", "image/png");
        Graphic graphic1 = symbolizer1.getGraphic();
        graphic1.setRotation(ECQL.toExpression((String)"45 * field"));
        Graphic graphic2 = symbolizer2.getGraphic();
        graphic2.setRotation(ECQL.toExpression((String)"22.5 * field"));
        Style style = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer1, symbolizer2}));
        IconProperties prop = IconPropertyExtractor.extractProperties((Style)style, (SimpleFeature)fieldIs1);
        Assert.assertEquals((Object)"http://127.0.0.1/kml/icon/test?0.0.0=&0.0.0.rotation=45.0&0.0.1=&0.0.1.rotation=22.5", (Object)prop.href("http://127.0.0.1/", null, "test"));
        Assert.assertEquals((double)0.0, (double)prop.getHeading(), (double)1.0E-4);
    }

    @Test
    public void testTwoLocalFilesOneRotate() throws Exception {
        PointSymbolizer symbolizer1 = this.externalGraphic("file:foo.png", "image/png");
        PointSymbolizer symbolizer2 = this.externalGraphic("file:bar.png", "image/png");
        Graphic graphic1 = symbolizer1.getGraphic();
        graphic1.setRotation(ECQL.toExpression((String)"45 * field"));
        Graphic graphic2 = symbolizer2.getGraphic();
        graphic2.setRotation(Expression.NIL);
        Style style = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer1, symbolizer2}));
        IconProperties prop = IconPropertyExtractor.extractProperties((Style)style, (SimpleFeature)fieldIs1);
        Assert.assertEquals((Object)"http://127.0.0.1/kml/icon/test?0.0.0=&0.0.0.rotation=45.0&0.0.1=", (Object)prop.href("http://127.0.0.1/", null, "test"));
        Assert.assertEquals((double)0.0, (double)prop.getHeading(), (double)0.0);
    }

    @Test
    public void testMarkRotate() throws Exception {
        PointSymbolizer symbolizer = this.grayCircle();
        Graphic graphic = symbolizer.getGraphic();
        graphic.setRotation(ECQL.toExpression((String)"45 * field"));
        Style s = this.styleFromRules(this.catchAllRule(new Symbolizer[]{symbolizer}));
        IconProperties prop = IconPropertyExtractor.extractProperties((Style)s, (SimpleFeature)fieldIs1);
        Assert.assertEquals((Object)"http://127.0.0.1/kml/icon/test?0.0.0=&0.0.0.rotation=45.0", (Object)prop.href("http://127.0.0.1/", null, "test"));
        Assert.assertEquals((double)0.0, (double)prop.getHeading(), (double)1.0E-4);
    }

    protected String encode(Style style, SimpleFeature feature) {
        return IconPropertyExtractor.extractProperties((Style)style, (SimpleFeature)feature).href("http://127.0.0.1/", null, "test").replace("http://127.0.0.1/kml/icon/test?", "");
    }

    protected String encode(WorkspaceInfo workspace, Style style, SimpleFeature feature) {
        return IconPropertyExtractor.extractProperties((Style)style, (SimpleFeature)feature).href("http://127.0.0.1/", workspace, "test").replace("http://127.0.0.1/kml/icon/" + workspace.getName() + "/test?", "");
    }
}

