/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.georss.GeoRSSTransformerBase;
import org.geoserver.wms.georss.RSSGeoRSSTransformer;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RSSGeoRSSTransformerTest
extends WMSTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    @Test
    public void testChannelDescription() throws Exception {
        Document document;
        WMSMapContent map = new WMSMapContent(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        ((Layer)map.layers().get(0)).getUserData().put("abstract", "Test Abstract");
        try {
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        }
        finally {
            map.dispose();
        }
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"rss", (Object)element.getNodeName());
        Element channel = (Element)element.getElementsByTagName("channel").item(0);
        NodeList description = channel.getElementsByTagName("description");
        Assert.assertEquals((Object)"Test Abstract", (Object)description.item(0).getChildNodes().item(0).getNodeValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLinkTemplate() throws Exception {
        Document document;
        WMSMapContent map = new WMSMapContent(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        try {
            File linkFile = new File(testData.getDataDirectoryRoot().getAbsolutePath() + "/workspaces/cite/cite/BasicPolygons/link.ftl");
            try (FileOutputStream out = new FileOutputStream(linkFile);){
                out.write("http://dummp.com".getBytes());
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error writing link.ftl: " + e);
        }
        try {
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        }
        finally {
            map.dispose();
        }
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"rss", (Object)element.getNodeName());
        NodeList items = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)items.getLength());
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            MatcherAssert.assertThat((Object)item.getElementsByTagName("link").item(0).getTextContent(), (Matcher)Matchers.containsString((String)"http://dummp.com"));
        }
    }

    @Test
    public void testLatLongInternal() throws Exception {
        Document document;
        WMSMapContent map = new WMSMapContent(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        try {
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        }
        finally {
            map.dispose();
        }
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"rss", (Object)element.getNodeName());
        NodeList items = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)items.getLength());
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            Assert.assertEquals((long)1L, (long)item.getElementsByTagName("geo:lat").getLength());
            Assert.assertEquals((long)1L, (long)item.getElementsByTagName("geo:long").getLength());
        }
    }

    @Test
    public void testLatLongWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:latlong&format=application/rss+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"rss", (Object)element.getNodeName());
        NodeList items = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)items.getLength());
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            Assert.assertEquals((long)1L, (long)item.getElementsByTagName("geo:lat").getLength());
            Assert.assertEquals((long)1L, (long)item.getElementsByTagName("geo:long").getLength());
        }
    }

    @Test
    public void testSimpleInternal() throws Exception {
        Document document;
        WMSMapContent map = new WMSMapContent(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        try {
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.SIMPLE);
        }
        finally {
            map.dispose();
        }
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"rss", (Object)element.getNodeName());
        NodeList entries = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("georss:polygon").getLength());
        }
    }

    @Test
    public void testSimpleWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:simple&format=application/rss+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"rss", (Object)element.getNodeName());
        NodeList entries = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("georss:polygon").getLength());
        }
    }

    @Test
    public void testGmlWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:gml&format=application/rss+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        Assert.assertEquals((Object)"rss", (Object)element.getNodeName());
        NodeList entries = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((long)n, (long)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((long)1L, (long)entry.getElementsByTagName("gml:Polygon").getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilter() throws Exception {
        Document document;
        WMSMapContent map = new WMSMapContent(this.createGetMapRequest(MockData.BUILDINGS));
        try {
            FeatureLayer layer = (FeatureLayer)this.createMapLayer(MockData.BUILDINGS);
            PropertyIsEqualTo f = this.ff.equals((Expression)this.ff.property("ADDRESS"), (Expression)this.ff.literal((Object)"215 Main Street"));
            layer.setQuery(new Query(MockData.BUILDINGS.getLocalPart(), (Filter)f));
            map.addLayer((Layer)layer);
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        }
        finally {
            map.dispose();
        }
        NodeList items = document.getDocumentElement().getElementsByTagName("item");
        Assert.assertEquals((long)1L, (long)items.getLength());
    }

    @Test
    public void testReproject() throws Exception {
        Document document;
        WMSMapContent map = new WMSMapContent(this.createGetMapRequest(MockData.LINES));
        map.addLayer(this.createMapLayer(MockData.LINES));
        try {
            document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        }
        finally {
            map.dispose();
        }
        NodeList items = document.getDocumentElement().getElementsByTagName("item");
        Assert.assertEquals((long)1L, (long)items.getLength());
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            double lat = Double.parseDouble(this.getOrdinate(item, "geo:lat"));
            double lon = Double.parseDouble(this.getOrdinate(item, "geo:long"));
            Assert.assertTrue((String)("Expected valid latitude value: " + lat), (lat >= -90.0 && lat <= 90.0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expected valid longitude value: " + lon), (lon >= -180.0 && lon <= 180.0 ? 1 : 0) != 0);
        }
    }

    String getOrdinate(Element item, String ordinate) {
        return item.getElementsByTagName(ordinate).item(0).getChildNodes().item(0).getNodeValue();
    }

    Document getRSSResponse(WMSMapContent map, GeoRSSTransformerBase.GeometryEncoding encoding) throws TransformerException, ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        RSSGeoRSSTransformer tx = new RSSGeoRSSTransformer(this.getWMS());
        tx.setGeometryEncoding(encoding);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        return document;
    }
}

