/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.featureinfo.FreeMarkerTemplateManager;
import org.geoserver.wms.featureinfo.HTMLFeatureInfoOutputFormat;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;

public class HTMLFeatureInfoOutputFormatTest
extends WMSTestSupport {
    private HTMLFeatureInfoOutputFormat outputFormat;
    private FeatureCollectionType fcType;
    Map<String, Object> parameters;
    GetFeatureInfoRequest getFeatureInfoRequest;
    static final String templateFolder = "/org/geoserver/wms/featureinfo/";
    private String currentTemplate;

    @Before
    public void setUp() throws URISyntaxException, IOException {
        this.outputFormat = new HTMLFeatureInfoOutputFormat(this.getWMS(), (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class));
        this.currentTemplate = "test_content.ftl";
        GeoServerTemplateLoader templateLoader = new GeoServerTemplateLoader(((Object)((Object)this)).getClass(), this.getDataDirectory()){

            public Object findTemplateSource(String path) throws IOException {
                String templatePath = path.toLowerCase().contains("content") ? HTMLFeatureInfoOutputFormatTest.this.currentTemplate : "empty.ftl";
                try {
                    return new File(((Object)((Object)this)).getClass().getResource(HTMLFeatureInfoOutputFormatTest.templateFolder + templatePath).toURI());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        };
        this.outputFormat.getTemplateManager().setTemplateLoader(templateLoader);
        Request request = new Request();
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("LAYER", "testLayer");
        this.parameters.put("NUMBER1", 10);
        this.parameters.put("NUMBER2", 100);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TEST1", "VALUE1");
        env.put("TEST2", "VALUE2");
        this.parameters.put("ENV", env);
        request.setKvp(this.parameters);
        Dispatcher.REQUEST.set(request);
        FeatureTypeInfo featureType = this.getFeatureTypeInfo(MockData.PRIMITIVEGEOFEATURE);
        this.initFeatureType(featureType);
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        layerInfo.setType(PublishedType.VECTOR);
        FeatureTypeInfoImpl resourceInfo = new FeatureTypeInfoImpl(null);
        NamespaceInfoImpl nameSpace = new NamespaceInfoImpl();
        nameSpace.setPrefix("topp");
        nameSpace.setURI("http://www.topp.org");
        resourceInfo.setNamespace((NamespaceInfo)nameSpace);
        layerInfo.setResource((ResourceInfo)resourceInfo);
        MapLayerInfo mapLayerInfo = new MapLayerInfo((LayerInfo)layerInfo);
        queryLayers.add(mapLayerInfo);
        this.getFeatureInfoRequest = new GetFeatureInfoRequest();
        this.getFeatureInfoRequest.setQueryLayers(queryLayers);
    }

    @After
    public void resetSettings() {
        System.clearProperty("GEOSERVER_FORCE_FREEMARKER_ESCAPING");
        System.clearProperty("GEOSERVER_FREEMARKER_API_EXPOSED");
        System.clearProperty("GEOSERVER_FREEMARKER_BLOCK_LIST");
        FreeMarkerTemplateManager.clearClassIntrospectionCache();
    }

    private void initFeatureType(FeatureTypeInfo featureType) throws IOException {
        this.fcType = WfsFactory.eINSTANCE.createFeatureCollectionType();
        this.fcType.getFeature().add((Object)featureType.getFeatureSource(null, null).getFeatures());
    }

    @Test
    public void testRequestParametersAreEvaluatedInTemplate() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertEquals((Object)"VALUE1,VALUE2,testLayer", (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnvironmentVariablesAreEvaluatedInTemplate() throws IOException {
        this.currentTemplate = "test_env_content.ftl";
        System.setProperty("TEST_PROPERTY", "MYVALUE");
        MockServletContext servletContext = (MockServletContext)applicationContext.getServletContext();
        servletContext.setInitParameter("TEST_INIT_PARAM", "MYPARAM");
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
            String result = new String(outStream.toByteArray());
            Assert.assertEquals((Object)"MYVALUE,MYPARAM", (Object)result);
        }
        finally {
            System.clearProperty("TEST_PROPERTY");
        }
    }

    @Test
    public void testCoverageInfoIsEvaluatedInTemplate() throws IOException {
        this.currentTemplate = "test_resource_content.ftl";
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.toName(MockData.WORLD));
        SimpleFeatureType type = builder.buildFeatureType();
        Object[] values = new Double[]{};
        this.fcType.getFeature().set(0, (Object)DataUtilities.collection((SimpleFeature)SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])values, (String)"")));
        CoverageInfo resource = this.getCatalog().getCoverageByName(this.toName(MockData.WORLD));
        resource.setTitle("Raster Title");
        resource.setAbstract("Raster Abstract");
        resource.getKeywords().set(0, new Keyword("Raster Keyword"));
        this.getCatalog().save((ResourceInfo)resource);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertEquals((Object)"Raster Title,Raster Abstract,Raster Keyword,EPSG:4326", (Object)result);
    }

    @Test
    public void testFeatureTypeInfoIsEvaluatedInTemplate() throws IOException {
        this.currentTemplate = "test_resource_content.ftl";
        FeatureTypeInfo resource = this.getFeatureTypeInfo(MockData.PRIMITIVEGEOFEATURE);
        resource.setTitle("Vector Title");
        resource.setAbstract("Vector Abstract");
        resource.getKeywords().set(0, new Keyword("Vector Keyword"));
        this.getCatalog().save((ResourceInfo)resource);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertEquals((Object)"Vector Title,Vector Abstract,Vector Keyword,EPSG:4326", (Object)result);
    }

    @Test
    public void testExecuteIsBlocked() throws IOException {
        this.currentTemplate = "test_execute.ftl";
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Error occurred processing content template content.ftl"));
    }

    @Test
    public void testErrorWhenRequestParametersAreNotDefined() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        boolean error = false;
        this.parameters.remove("LAYER");
        try {
            this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        }
        catch (IOException e) {
            error = true;
        }
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testHTMLGetFeatureInfoCharset() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=text/html";
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        Assert.assertEquals((Object)"text/html", (Object)this.getBaseMimeType(response.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)response.getCharacterEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRequests() throws Exception {
        FeatureTypeInfo featureType1 = this.getFeatureTypeInfo(MockData.PRIMITIVEGEOFEATURE);
        List<MapLayerInfo> layers1 = Collections.singletonList(new MapLayerInfo(this.getCatalog().getLayerByName(featureType1.prefixedName())));
        FeatureCollectionType type1 = WfsFactory.eINSTANCE.createFeatureCollectionType();
        type1.getFeature().add((Object)featureType1.getFeatureSource(null, null).getFeatures());
        final FeatureTypeInfo featureType2 = this.getFeatureTypeInfo(MockData.BASIC_POLYGONS);
        List<MapLayerInfo> layers2 = Collections.singletonList(new MapLayerInfo(this.getCatalog().getLayerByName(featureType2.prefixedName())));
        FeatureCollectionType type2 = WfsFactory.eINSTANCE.createFeatureCollectionType();
        type2.getFeature().add((Object)featureType2.getFeatureSource(null, null).getFeatures());
        HTMLFeatureInfoOutputFormat format = new HTMLFeatureInfoOutputFormat(this.getWMS(), (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class));
        format.getTemplateManager().setTemplateLoader(new GeoServerTemplateLoader(((Object)((Object)this)).getClass(), this.getDataDirectory()){

            public Object findTemplateSource(String path) throws IOException {
                String templatePath = "empty.ftl";
                if (path.toLowerCase().contains("content") && this.resource != null && this.resource.prefixedName().equals(featureType2.prefixedName())) {
                    templatePath = "test_content.ftl";
                }
                try {
                    return new File(((Object)((Object)this)).getClass().getResource(HTMLFeatureInfoOutputFormatTest.templateFolder + templatePath).toURI());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        });
        int numRequests = 50;
        ArrayList<Callable<String>> tasks = new ArrayList<Callable<String>>(numRequests);
        for (int i = 0; i < numRequests; ++i) {
            GetFeatureInfoRequest request = new GetFeatureInfoRequest();
            request.setQueryLayers(i % 2 == 0 ? layers1 : layers2);
            FeatureCollectionType type = i % 2 == 0 ? type1 : type2;
            tasks.add(() -> {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                format.write(type, request, (OutputStream)output);
                return new String(output.toByteArray());
            });
        }
        ExecutorService executor = Executors.newFixedThreadPool(8);
        try {
            List futures = executor.invokeAll(tasks);
            for (int i = 0; i < numRequests; ++i) {
                String info = (String)futures.get(i).get();
                if (i % 2 == 0) {
                    Assert.assertEquals((Object)"", (Object)info);
                    continue;
                }
                Assert.assertNotEquals((Object)"", (Object)info);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testStaticMathMethodsAreEvaluatedInTemplate() throws IOException {
        this.currentTemplate = "test_static_content.ftl";
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertEquals((Object)String.valueOf(Math.max(10, 100)), (Object)result);
    }

    @Test
    public void testStaticMethodsUnrestrictedInTemplate() throws IOException {
        this.activateStaticsAccessRules("*");
        this.currentTemplate = "test_custom_static_content.ftl";
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertEquals((Object)String.format("Amount: %.2f \u20ac", 47.11), (Object)result);
    }

    @Test(expected=IOException.class)
    public void testStaticMethodsDisabledInTemplate() throws IOException {
        this.activateStaticsAccessRules(null);
        this.currentTemplate = "test_custom_static_content.ftl";
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
    }

    @Test
    public void testSpecifiedStaticMethodsInTemplateAvailable() throws IOException {
        this.activateStaticsAccessRules(java.util.Locale.class.getName() + "," + Locale.class.getName());
        this.currentTemplate = "test_custom_static_content_specified.ftl";
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertEquals((Object)"Hello world from de", (Object)result);
    }

    @Test
    public void testMultipleFeatureCollectionsPerQueryLayer() throws Exception {
        this.currentTemplate = "test_content_multi_ft.ftl";
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.toName(MockData.WORLD));
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)builder.buildFeatureType(), (Object[])new Double[0], (String)"");
        this.fcType.getFeature().add((Object)DataUtilities.collection((SimpleFeature)feature));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertTrue((boolean)result.contains("Type: PrimitiveGeoFeature"));
        Assert.assertTrue((boolean)result.contains("Type: World"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoEscaping() throws Exception {
        this.currentTemplate = "test_resource_content.ftl";
        String decoded = "<foo>bar</foo>";
        String encoded = "&lt;foo&gt;bar&lt;/foo&gt;";
        FeatureTypeInfo resource = this.getFeatureTypeInfo(MockData.PRIMITIVEGEOFEATURE);
        resource.getKeywords().set(0, new Keyword(decoded));
        this.getCatalog().save((ResourceInfo)resource);
        this.doTestAutoEscaping(null, encoded, decoded);
        this.doTestAutoEscaping("true", encoded, decoded);
        this.doTestAutoEscaping("false", decoded, encoded);
        WMSInfo info = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        info.setAutoEscapeTemplateValues(true);
        this.getGeoServer().save((ServiceInfo)info);
        try {
            this.doTestAutoEscaping(null, encoded, decoded);
            this.doTestAutoEscaping("true", encoded, decoded);
            this.doTestAutoEscaping("false", encoded, decoded);
        }
        finally {
            info.setAutoEscapeTemplateValues(false);
            this.getGeoServer().save((ServiceInfo)info);
        }
    }

    private void doTestAutoEscaping(String property, String contains, String notContains) throws Exception {
        if (property != null) {
            System.setProperty("GEOSERVER_FORCE_FREEMARKER_ESCAPING", property);
        } else {
            System.clearProperty("GEOSERVER_FORCE_FREEMARKER_ESCAPING");
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)notContains)));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)contains));
    }

    @After
    @Before
    public void tearDownStaticAccessKey() {
        this.activateStaticsAccessRules(null);
    }

    private void activateStaticsAccessRules(String aPattern) {
        if (aPattern == null) {
            System.clearProperty("org.geoserver.htmlTemplates.staticMemberAccess");
        } else {
            System.setProperty("org.geoserver.htmlTemplates.staticMemberAccess", aPattern);
        }
        FreeMarkerTemplateManager.initStaticsAccessRule();
    }

    @Test
    public void testBlockSensitive1() throws IOException {
        this.doTestSensitive("test_block_sensitive_1.ftl", true);
    }

    @Test
    public void testBlockSensitive2() throws IOException {
        this.doTestSensitive("test_block_sensitive_2.ftl", true);
    }

    @Test
    public void testBlockSensitive3() throws IOException {
        this.doTestSensitive("test_block_sensitive_3.ftl", true);
    }

    @Test
    public void testCustomBlockList() throws IOException {
        this.doTestSensitive("test_block_custom.ftl", false);
        System.setProperty("GEOSERVER_FREEMARKER_BLOCK_LIST", NamespaceInfo.class.getName());
        this.doTestSensitive("test_block_custom.ftl", true);
    }

    @Test
    public void testBlockApi() throws IOException {
        this.doTestSensitive("test_block_api.ftl", true);
        System.setProperty("GEOSERVER_FREEMARKER_API_EXPOSED", "true");
        this.doTestSensitive("test_block_api.ftl", false);
    }

    private void doTestSensitive(String template, boolean exception) throws IOException {
        FreeMarkerTemplateManager.clearClassIntrospectionCache();
        this.currentTemplate = template;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (exception) {
            IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)out));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Error occurred processing content template content.ftl"));
        } else {
            this.outputFormat.write(this.fcType, this.getFeatureInfoRequest, (OutputStream)out);
        }
    }

    public static final class Locale {
        public static String m() {
            return "Hello world";
        }
    }
}

