/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.featureinfo.GetFeatureInfoKvpReader;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.junit.Assert;
import org.junit.Test;

public class GetFeatureInfoKvpRequestReaderTest
extends KvpRequestReaderTestSupport {
    GetFeatureInfoKvpReader reader;
    Dispatcher dispatcher;
    public static final String STATES_SLD = "<StyledLayerDescriptor version=\"1.0.0\"><UserLayer><Name>sf:states</Name><UserStyle><Name>UserSelection</Name><FeatureTypeStyle><Rule><Filter xmlns:gml=\"http://www.opengis.net/gml\"><PropertyIsEqualTo><PropertyName>STATE_ABBR</PropertyName><Literal>IL</Literal></PropertyIsEqualTo></Filter><PolygonSymbolizer><Fill><CssParameter name=\"fill\">#FF0000</CssParameter></Fill></PolygonSymbolizer></Rule><Rule><LineSymbolizer><Stroke/></LineSymbolizer></Rule></FeatureTypeStyle></UserStyle></UserLayer></StyledLayerDescriptor>";

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        CatalogFactory cf = this.getCatalog().getFactory();
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo gi = cf.createLayerGroup();
        gi.setName("testGroup");
        gi.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi.getStyles().add(this.getCatalog().getStyleByName("polygon"));
        cb.calculateLayerGroupBounds(gi);
        this.getCatalog().add(gi);
        LayerGroupInfo gi2 = cf.createLayerGroup();
        gi2.setName("testGroup2");
        gi2.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi2.getStyles().add(this.getCatalog().getStyleByName("raster"));
        gi2.getLayers().add(this.getCatalog().getLayerByName(MockData.BUILDINGS.getLocalPart()));
        gi2.getStyles().add(this.getCatalog().getStyleByName("raster"));
        cb.calculateLayerGroupBounds(gi2);
        this.getCatalog().add(gi2);
    }

    protected void oneTimeTearDown() throws Exception {
        super.oneTimeTearDown();
        GeoServerLoader.setLegacy((boolean)false);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.dispatcher = (Dispatcher)applicationContext.getBean("dispatcher");
        WMS wms = new WMS(this.getGeoServer());
        this.reader = new GetFeatureInfoKvpReader(wms);
    }

    @Test
    public void testSldDisabled() throws Exception {
        HashMap<String, Object> kvp = new HashMap<String, Object>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setDynamicStylingDisabled(Boolean.TRUE);
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        this.reader = new GetFeatureInfoKvpReader(wms);
        GetFeatureInfoRequest request = (GetFeatureInfoRequest)this.reader.createRequest();
        boolean error = false;
        try {
            request = (GetFeatureInfoRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        }
        catch (ServiceException e) {
            error = true;
        }
        this.getGeoServer().remove((ServiceInfo)info);
        this.getGeoServer().add((ServiceInfo)oldInfo);
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testSldBodyDisabled() throws Exception {
        HashMap<String, Object> kvp = new HashMap<String, Object>();
        kvp.put("sld_body", STATES_SLD);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setDynamicStylingDisabled(Boolean.TRUE);
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        this.reader = new GetFeatureInfoKvpReader(wms);
        GetFeatureInfoRequest request = (GetFeatureInfoRequest)this.reader.createRequest();
        boolean error = false;
        try {
            request = (GetFeatureInfoRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        }
        catch (ServiceException e) {
            error = true;
        }
        this.getGeoServer().remove((ServiceInfo)info);
        this.getGeoServer().add((ServiceInfo)oldInfo);
        Assert.assertTrue((boolean)error);
    }
}

