/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.function.Function;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.MockTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.featureinfo.GeoJSONFeatureInfoResponse;
import org.geoserver.wms.tiffspy.GeoTIFFSpyFormat;
import org.geoserver.wms.tiffspy.GeoTIFFSpyReader;
import org.geoserver.wms.wms_1_1_1.GetFeatureInfoTest;
import org.geotools.api.feature.type.Name;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetFeatureInfoJSONTest
extends GetFeatureInfoTest {
    public static final QName TEMPORAL_DATA = new QName(CiteTestData.CITE_URI, "TemporalData", CiteTestData.CITE_PREFIX);
    public static final String LABEL_IN_FEATURE_INFO_STYLE_DEM = "labelInFeatureInfoTazDem";
    public static final String LABEL_CUSTOM_NAME_STYLE_DEM = "labelCustomNameTazDem";
    public static final String LABEL_IN_FEATURE_INFO_DEM_REPLACE = "labelInFeatureInfoTazDemReplace";
    public static final String LABEL_IN_FEATURE_INFO_DEM_NONE = "labelInFeatureInfoTazDemNone";
    public static final String LABEL_IN_FEATURE_INFO_DEM_VALUES = "labelInFeatureInfoTazDemColorMapValues";
    public static final String LABEL_IN_FEATURE_INFO_MULTIPLE_SYMBOLIZERS = "labelInFeatureInfoTazDemMultipleSymbolizers";
    public static final String LABEL_IN_FEATURE_INFO_STYLE_BM = "labelInFeatureInfoTazBm";
    public static final String LABEL_IN_FEATURE_INFO_STYLE_MULTIPLE_SYMBLOZERS2 = "labelInFeatureInfoTazBmMultipleSymbolizers";
    public static final String RASTER_VECTOR = "rasterVector";
    public static final String FOOTPRINT_RASTER = "footprintsRaster";
    public static final String JIFFLE_CONDITION = "jiffleCondition";
    public static final QName TASMANIA_SPY = new QName(WCS_URI, "BlueMarbleSpy", WCS_PREFIX);
    public static QName RAT = new QName(MockTestData.CITE_URI, "rat", MockTestData.CITE_PREFIX);
    public static final String RAT_STYLE = "rat";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addVectorLayer(TEMPORAL_DATA, Collections.emptyMap(), "TemporalData.properties", SystemTestData.class, catalog);
        testData.addStyle(LABEL_IN_FEATURE_INFO_STYLE_DEM, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(LABEL_CUSTOM_NAME_STYLE_DEM, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(LABEL_IN_FEATURE_INFO_DEM_REPLACE, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(LABEL_IN_FEATURE_INFO_DEM_NONE, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(LABEL_IN_FEATURE_INFO_DEM_VALUES, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(LABEL_IN_FEATURE_INFO_MULTIPLE_SYMBOLIZERS, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(LABEL_IN_FEATURE_INFO_STYLE_BM, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(LABEL_IN_FEATURE_INFO_STYLE_MULTIPLE_SYMBLOZERS2, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(RASTER_VECTOR, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(JIFFLE_CONDITION, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(FOOTPRINT_RASTER, ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(RAT_STYLE, ((Object)((Object)this)).getClass(), catalog);
        HashMap<SystemTestData.LayerProperty, String> propertyMap = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMap.put(SystemTestData.LayerProperty.STYLE, "raster");
        testData.addRasterLayer(MockData.TASMANIA_DEM, "tazdem.tiff", "tiff", propertyMap, SystemTestData.class, catalog);
        testData.addRasterLayer(TASMANIA_SPY, "tazbm.tiff", "tiff", propertyMap, SystemTestData.class, catalog);
        testData.addRasterLayer(RAT, "rat.tiff", "tiff", null, ((Object)((Object)this)).getClass(), this.getCatalog());
        GeoServerDataDirectory dd = this.getDataDirectory();
        Resource aux = dd.get(new String[]{RAT_STYLE, "rat.tiff.aux.xml"});
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("rat.tiff.aux.xml");
             OutputStream os = aux.out();){
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.close();
        }
        this.getCatalog().getResourcePool().clear(this.getCatalog().getCoverageByName(this.getLayerId(RAT)));
    }

    @Test
    public void testSimpleJSONP() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=text/javascript";
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertEquals((Object)"text/javascript", (Object)this.getBaseMimeType(response.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)response.getCharacterEncoding());
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.startsWith("parseResponse"));
        Assert.assertTrue((boolean)result.endsWith(")"));
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        result = result.substring(0, result.length() - 1);
        result = result.substring("parseResponse".length() + 1, result.length());
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testCustomJSONP() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=text/javascript&format_options=callback:custom";
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertEquals((Object)"text/javascript", (Object)this.getBaseMimeType(response.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)response.getCharacterEncoding());
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.startsWith("custom("));
        Assert.assertTrue((boolean)result.endsWith(")"));
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        result = result.substring(0, result.length() - 1);
        result = result.substring("custom".length() + 1, result.length());
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testSimpleJSON() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=application/json";
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        Assert.assertEquals((Object)"application/json", (Object)this.getBaseMimeType(response.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)response.getCharacterEncoding());
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testPropertySelection() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?service=wms&version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=application/json&propertyName=NAME";
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        Assert.assertEquals((Object)"application/json", (Object)this.getBaseMimeType(response.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)response.getCharacterEncoding());
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertTrue((boolean)aFeature.getJSONObject("geometry").isNullObject());
        JSONObject properties = aFeature.getJSONObject("properties");
        Assert.assertTrue((boolean)properties.getJSONObject("FID").isNullObject());
        Assert.assertEquals((Object)"Green Forest", (Object)properties.get("NAME"));
    }

    @Test
    public void testReprojectedLayer() throws Exception {
        String layer = this.getLayerId(MockData.MPOLYGONS);
        String request = "wms?version=1.1.1&bbox=500525,500025,500575,500050&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject feature = (JSONObject)json.getJSONArray("features").get(0);
        JSONObject geom = feature.getJSONObject("geometry");
        JSONArray coords = geom.getJSONArray("coordinates").getJSONArray(0).getJSONArray(0).getJSONArray(0);
        Assert.assertTrue((boolean)new NumberRange(Double.class, (Number)500525.0, (Number)500575.0).contains((Number)coords.getDouble(0)));
        Assert.assertTrue((boolean)new NumberRange(Double.class, (Number)500025.0, (Number)500050.0).contains((Number)coords.getDouble(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCQLFilter() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONArray features = json.getJSONArray("features");
        Assert.assertFalse((boolean)features.isEmpty());
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(layer);
        try {
            info.setCqlFilter("NAME LIKE 'Red%'");
            this.getCatalog().save((ResourceInfo)info);
            json = (JSONObject)this.getAsJSON(request);
            features = json.getJSONArray("features");
            Assert.assertEquals((long)0L, (long)features.size());
        }
        finally {
            info = this.getCatalog().getFeatureTypeByName(layer);
            info.setCqlFilter(null);
            this.getCatalog().save((ResourceInfo)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateTimeFormattingEnabled() throws Exception {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-05:00"));
        try {
            System.getProperties().remove("org.geotools.dateTimeFormatHandling");
            System.setProperty("org.geotools.localDateTimeHandling", "true");
            Hints.scanSystemProperties();
            String layer = this.getLayerId(TEMPORAL_DATA);
            String request = "wms?version=1.1.1&bbox=39.73245,2.00342,39.732451,2.003421&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=10&height=10&x=5&y=5&info_format=application/json";
            MockHttpServletResponse response = this.getAsServletResponse(request, "");
            Assert.assertEquals((Object)"application/json", (Object)this.getBaseMimeType(response.getContentType()));
            Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)response.getCharacterEncoding());
            String result = response.getContentAsString();
            Assert.assertNotNull((Object)result);
            JSONObject rootObject = JSONObject.fromObject((Object)result);
            Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
            JSONArray featureCol = rootObject.getJSONArray("features");
            JSONObject aFeature = featureCol.getJSONObject(0);
            JSONObject properties = aFeature.getJSONObject("properties");
            Assert.assertNotNull((Object)properties);
            Assert.assertEquals((Object)"2006-06-27T22:00:00-05:00", (Object)properties.getString("dateTimeProperty"));
            Assert.assertEquals((Object)"2006-12-12", (Object)properties.getString("dateProperty"));
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
            System.getProperties().remove("org.geotools.localDateTimeHandling");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateTimeFormattingDisabled() throws Exception {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT-05:00"));
            System.setProperty("org.geotools.dateTimeFormatHandling", "false");
            System.setProperty("org.geotools.localDateTimeHandling", "true");
            Hints.scanSystemProperties();
            String layer = this.getLayerId(TEMPORAL_DATA);
            String request = "wms?version=1.1.1&bbox=39.73245,2.00342,39.732451,2.003421&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=10&height=10&x=5&y=5&info_format=application/json";
            MockHttpServletResponse response = this.getAsServletResponse(request, "");
            Assert.assertEquals((Object)"application/json", (Object)this.getBaseMimeType(response.getContentType()));
            Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)response.getCharacterEncoding());
            String result = response.getContentAsString();
            Assert.assertNotNull((Object)result);
            JSONObject rootObject = JSONObject.fromObject((Object)result);
            Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
            JSONArray featureCol = rootObject.getJSONArray("features");
            JSONObject aFeature = featureCol.getJSONObject(0);
            JSONObject properties = aFeature.getJSONObject("properties");
            Assert.assertNotNull((Object)properties);
            Assert.assertEquals((Object)"2006-06-28T03:00:00Z", (Object)properties.getString("dateTimeProperty"));
            Assert.assertEquals((Object)"2006-12-12", (Object)properties.getString("dateProperty"));
        }
        finally {
            System.getProperties().remove("org.geotools.dateTimeFormatHandling");
            System.getProperties().remove("org.geotools.localDateTimeHandling");
            Hints.scanSystemProperties();
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    @Test
    public void testJSONFreeMarkerTemplate() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL headerUrl = ((Object)((Object)this)).getClass().getResource("../header_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource resource = loader.get(Paths.path((String[])new String[]{"workspaces", TEMPORAL_DATA.getPrefix(), "cite", TEMPORAL_DATA.getLocalPart()}));
        Resource workspace = loader.get(Paths.path((String[])new String[]{"workspaces", TEMPORAL_DATA.getPrefix()}));
        File fileHeader = new File(workspace.dir(), "header_json.ftl");
        File fileFooter = new File(workspace.dir(), "footer_json.ftl");
        File fileContent = new File(resource.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)headerUrl, (File)fileHeader);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContent);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(TEMPORAL_DATA.getPrefix(), TEMPORAL_DATA.getLocalPart());
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerInfo layerInfo = this.getCatalog().getLayerByName(TEMPORAL_DATA.getLocalPart());
        MapLayerInfo mapLayerInfo = new MapLayerInfo(layerInfo);
        queryLayers.add(mapLayerInfo);
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", mapLayerInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        FeatureCollection fc = ft.getFeatureSource(null, null).getFeatures();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = this.getFeatureCollectionType(fc);
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        JSONObject response = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)response.get("header"), (Object)"this is the header");
        JSONArray featuresInfo = response.getJSONArray("features");
        JSONObject featureInfo = (JSONObject)featuresInfo.get(0);
        Assert.assertEquals((Object)featureInfo.get("content"), (Object)"this is the content");
        Assert.assertEquals((Object)featureInfo.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)featureInfo.get("id"), (Object)"Points.0");
        Assert.assertNotNull((Object)featureInfo.get("geometry"));
        JSONObject props = featureInfo.getJSONObject("properties");
        Assert.assertEquals((Object)props.get("id"), (Object)"t0000");
        Assert.assertEquals((Object)props.get("altitude"), (Object)"500");
        Assert.assertNotNull((Object)props.get("dateTimeProperty"));
        Assert.assertNotNull((Object)props.get("dateProperty"));
        Assert.assertEquals((Object)response.get("footer"), (Object)"this is the footer");
        fileHeader.delete();
        fileContent.delete();
        fileFooter.delete();
    }

    private FeatureCollectionType getFeatureCollectionType(FeatureCollection fc) {
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fc);
        return fct;
    }

    @Test
    public void testJSONFreeMarkerTemplateLayerGroup() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL headerUrl = ((Object)((Object)this)).getClass().getResource("../header_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource templates = loader.get(Paths.path((String[])new String[]{"templates"}));
        Resource resForest = loader.get(Paths.path((String[])new String[]{"workspaces", MockData.FORESTS.getPrefix(), "cite", MockData.FORESTS.getLocalPart()}));
        Resource resLake = loader.get(Paths.path((String[])new String[]{"workspaces", MockData.LAKES.getPrefix(), "cite", MockData.LAKES.getLocalPart()}));
        File fileHeader = new File(templates.dir(), "header_json.ftl");
        File fileFooter = new File(templates.dir(), "footer_json.ftl");
        File fileContentForest = new File(resForest.dir(), "content_json.ftl");
        File fileContentLake = new File(resLake.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)headerUrl, (File)fileHeader);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContentForest);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContentLake);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerGroupInfo lgInfo = this.getCatalog().getLayerGroupByName("nature");
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        for (PublishedInfo info : lgInfo.getLayers()) {
            layers.add((LayerInfo)info);
            queryLayers.add(new MapLayerInfo((LayerInfo)info));
        }
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", lgInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        for (LayerInfo l : layers) {
            FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(l.getName());
            EList feature = fct.getFeature();
            feature.add((Object)fti.getFeatureSource(null, null).getFeatures());
        }
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        JSONObject response = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)response.get("header"), (Object)"this is the header");
        JSONArray featuresInfo = response.getJSONArray("features");
        JSONObject fiLake = (JSONObject)featuresInfo.get(0);
        Assert.assertEquals((Object)fiLake.get("content"), (Object)"this is the content");
        Assert.assertEquals((Object)fiLake.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)fiLake.get("id"), (Object)"Lakes.1107531835962");
        JSONObject geomLake = fiLake.getJSONObject("geometry");
        Assert.assertEquals((Object)geomLake.get("type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geomLake.getJSONArray("coordinates"));
        JSONObject lakeProps = fiLake.getJSONObject("properties");
        Assert.assertEquals((Object)lakeProps.get("NAME"), (Object)"Blue Lake");
        Assert.assertEquals((Object)lakeProps.get("FID"), (Object)"101");
        JSONObject fiForest = (JSONObject)featuresInfo.get(1);
        Assert.assertEquals((Object)fiForest.get("content"), (Object)"this is the content");
        Assert.assertEquals((Object)fiForest.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)fiForest.get("id"), (Object)"Forests.1107531798144");
        JSONObject geomForest = fiForest.getJSONObject("geometry");
        Assert.assertEquals((Object)geomForest.get("type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geomForest.getJSONArray("coordinates"));
        JSONObject forestProps = fiForest.getJSONObject("properties");
        Assert.assertEquals((Object)forestProps.get("NAME"), (Object)"Green Forest");
        Assert.assertEquals((Object)forestProps.get("FID"), (Object)"109");
        Assert.assertEquals((Object)response.get("footer"), (Object)"this is the footer");
        fileHeader.delete();
        fileContentForest.delete();
        fileContentLake.delete();
        fileFooter.delete();
    }

    @Test
    public void testJSONFreeMarkerTemplateLayerGroupMixed() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL headerUrl = ((Object)((Object)this)).getClass().getResource("../header_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource templates = loader.get(Paths.path((String[])new String[]{"templates"}));
        Resource resource = loader.get(Paths.path((String[])new String[]{"workspaces", MockData.FORESTS.getPrefix(), "cite", MockData.FORESTS.getLocalPart()}));
        File fileHeader = new File(templates.dir(), "header_json.ftl");
        File fileFooter = new File(templates.dir(), "footer_json.ftl");
        File fileContent = new File(resource.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)headerUrl, (File)fileHeader);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContent);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerGroupInfo lgInfo = this.getCatalog().getLayerGroupByName("nature");
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        for (PublishedInfo info : lgInfo.getLayers()) {
            layers.add((LayerInfo)info);
            queryLayers.add(new MapLayerInfo((LayerInfo)info));
        }
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", lgInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        for (LayerInfo l : layers) {
            FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(l.getName());
            EList feature = fct.getFeature();
            feature.add((Object)fti.getFeatureSource(null, null).getFeatures());
        }
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        JSONObject response = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)response.get("header"), (Object)"this is the header");
        JSONArray featuresInfo = response.getJSONArray("features");
        JSONObject fiLake = (JSONObject)featuresInfo.get(0);
        Assert.assertNull((Object)fiLake.get("content"));
        Assert.assertEquals((Object)fiLake.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)fiLake.get("id"), (Object)"Lakes.1107531835962");
        JSONObject geomLake = fiLake.getJSONObject("geometry");
        Assert.assertEquals((Object)geomLake.get("type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geomLake.getJSONArray("coordinates"));
        JSONObject lakeProps = fiLake.getJSONObject("properties");
        Assert.assertEquals((Object)lakeProps.get("NAME"), (Object)"Blue Lake");
        Assert.assertEquals((Object)lakeProps.get("FID"), (Object)"101");
        JSONObject fiForest = (JSONObject)featuresInfo.get(1);
        Assert.assertEquals((Object)fiForest.get("content"), (Object)"this is the content");
        Assert.assertEquals((Object)fiForest.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)fiForest.get("id"), (Object)"Forests.1107531798144");
        JSONObject geomForest = fiForest.getJSONObject("geometry");
        Assert.assertEquals((Object)geomForest.get("type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geomForest.getJSONArray("coordinates"));
        JSONObject forestProps = fiForest.getJSONObject("properties");
        Assert.assertEquals((Object)forestProps.get("NAME"), (Object)"Green Forest");
        Assert.assertEquals((Object)forestProps.get("FID"), (Object)"109");
        Assert.assertEquals((Object)response.get("footer"), (Object)"this is the footer");
        fileHeader.delete();
        fileContent.delete();
        fileFooter.delete();
    }

    @Test
    public void testJSONWithFreeMarkerWithMissingTemplate() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(TEMPORAL_DATA.getPrefix(), TEMPORAL_DATA.getLocalPart());
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource resource = loader.get(Paths.path((String[])new String[]{"workspaces", TEMPORAL_DATA.getPrefix(), "cite", TEMPORAL_DATA.getLocalPart()}));
        Resource workspace = loader.get(Paths.path((String[])new String[]{"workspaces", TEMPORAL_DATA.getPrefix()}));
        File fileFooter = new File(workspace.dir(), "footer_json.ftl");
        File fileContent = new File(resource.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContent);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerInfo layerInfo = this.getCatalog().getLayerByName(TEMPORAL_DATA.getLocalPart());
        MapLayerInfo mapLayerInfo = new MapLayerInfo(layerInfo);
        queryLayers.add(mapLayerInfo);
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", mapLayerInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        FeatureCollection fc = ft.getFeatureSource(null, null).getFeatures();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = this.getFeatureCollectionType(fc);
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        JSONObject response = JSONObject.fromObject((Object)result);
        Assert.assertNull((Object)response.get("header"));
        JSONArray featuresInfo = response.getJSONArray("features");
        JSONObject featureInfo = (JSONObject)featuresInfo.get(0);
        Assert.assertNull((Object)featureInfo.get("content"));
        Assert.assertNotNull((Object)featureInfo.get("id"));
        JSONObject properties = (JSONObject)featureInfo.get("properties");
        Assert.assertNotNull((Object)properties.get("altitude"));
        Assert.assertNotNull((Object)properties.get("dateTimeProperty"));
        Assert.assertNotNull((Object)properties.get("dateProperty"));
        Assert.assertNull((Object)response.get("footer"));
        fileFooter.delete();
        fileContent.delete();
    }

    @Test
    public void testJSONFreeMarkerTemplateMultipleFeatureCollectionsPerQueryLayer() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL headerUrl = ((Object)((Object)this)).getClass().getResource("../header_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource templates = loader.get(Paths.path((String[])new String[]{"templates"}));
        File fileHeader = new File(templates.dir(), "header_json.ftl");
        File fileFooter = new File(templates.dir(), "footer_json.ftl");
        File fileContent = new File(templates.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)headerUrl, (File)fileHeader);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContent);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(TEMPORAL_DATA.getPrefix(), TEMPORAL_DATA.getLocalPart());
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerInfo layerInfo = this.getCatalog().getLayerByName(TEMPORAL_DATA.getLocalPart());
        MapLayerInfo mapLayerInfo = new MapLayerInfo(layerInfo);
        queryLayers.add(mapLayerInfo);
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", mapLayerInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        FeatureCollection fc = ft.getFeatureSource(null, null).getFeatures();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = this.getFeatureCollectionType(fc);
        FeatureTypeInfo squaresTypeInfo = this.getCatalog().getFeatureTypeByName(SQUARES.getPrefix(), SQUARES.getLocalPart());
        FeatureCollection squaresCollection = squaresTypeInfo.getFeatureSource(null, null).getFeatures();
        fct.getFeature().add((Object)squaresCollection);
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        Assert.assertTrue((boolean)result.contains("Points.0"));
        Assert.assertTrue((boolean)result.contains("squares.1"));
        fileHeader.delete();
        fileContent.delete();
        fileFooter.delete();
    }

    @Test
    public void testLabelInFeatureInfoColorMapRamp() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo tazDem = cat.getLayerByName((Name)new NameImpl(MockData.TASMANIA_DEM.getPrefix(), MockData.TASMANIA_DEM.getLocalPart()));
        StyleInfo style = cat.getStyleByName(LABEL_IN_FEATURE_INFO_STYLE_DEM);
        tazDem.getStyles().add(style);
        cat.save(tazDem);
        String layerId = this.getLayerId(MockData.TASMANIA_DEM);
        String request = "wms?version=1.1.1&styles=labelInFeatureInfoTazDem&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=144.9566345277708,-42.23886111751199,145.23403931292705,-41.96145633235574&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
        Assert.assertTrue((boolean)properties.has("Label_GRAY_INDEX"));
        Assert.assertEquals((long)55537L, (long)properties.getInt("GRAY_INDEX"));
        Assert.assertEquals((Object)"55537", (Object)properties.getString("Label_GRAY_INDEX"));
    }

    @Test
    public void testLabelInFeatureInfoWitCustomAttributeName() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo tazDem = cat.getLayerByName((Name)new NameImpl(MockData.TASMANIA_DEM.getPrefix(), MockData.TASMANIA_DEM.getLocalPart()));
        StyleInfo style = cat.getStyleByName(LABEL_CUSTOM_NAME_STYLE_DEM);
        tazDem.getStyles().add(style);
        cat.save(tazDem);
        String layerId = this.getLayerId(MockData.TASMANIA_DEM);
        String request = "wms?version=1.1.1&styles=labelCustomNameTazDem&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=144.9566345277708,-42.23886111751199,145.23403931292705,-41.96145633235574&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
        Assert.assertEquals((long)55537L, (long)properties.getInt("GRAY_INDEX"));
        Assert.assertEquals((Object)"55537", (Object)properties.getString("custom name"));
    }

    @Test
    public void testLabelInFeatureInfoReplaceWithColorMapIntervals() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo tazDem = cat.getLayerByName((Name)new NameImpl(MockData.TASMANIA_DEM.getPrefix(), MockData.TASMANIA_DEM.getLocalPart()));
        StyleInfo style = cat.getStyleByName(LABEL_IN_FEATURE_INFO_DEM_REPLACE);
        tazDem.getStyles().add(style);
        cat.save(tazDem);
        String layerId = this.getLayerId(MockData.TASMANIA_DEM);
        String request = "wms?version=1.1.1&styles=labelInFeatureInfoTazDemReplace&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=145.41806031949818,-42.16195682063699,145.69546510465443,-41.88455203548074&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)">= 308.142116 AND < 752.166285", (Object)properties.getString("Label_GRAY_INDEX"));
    }

    @Test
    public void testLabelInFeatureInfoNone() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo tazDem = cat.getLayerByName((Name)new NameImpl(MockData.TASMANIA_DEM.getPrefix(), MockData.TASMANIA_DEM.getLocalPart()));
        StyleInfo style = cat.getStyleByName(LABEL_IN_FEATURE_INFO_DEM_NONE);
        tazDem.getStyles().add(style);
        cat.save(tazDem);
        String layerId = this.getLayerId(MockData.TASMANIA_DEM);
        String request = "wms?version=1.1.1&styles=labelInFeatureInfoTazDemNone&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=145.41806031949818,-42.16195682063699,145.69546510465443,-41.88455203548074&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
        Assert.assertFalse((boolean)properties.has("Label_GRAY_INDEX"));
        Assert.assertTrue((boolean)properties.has("GRAY_INDEX"));
    }

    @Test
    public void testLabelInFeatureInfoReplaceWithValuesColorMap() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo tazDem = cat.getLayerByName((Name)new NameImpl(MockData.TASMANIA_DEM.getPrefix(), MockData.TASMANIA_DEM.getLocalPart()));
        StyleInfo style = cat.getStyleByName(LABEL_IN_FEATURE_INFO_DEM_VALUES);
        tazDem.getStyles().add(style);
        cat.save(tazDem);
        String layerId = this.getLayerId(MockData.TASMANIA_DEM);
        String request = "wms?version=1.1.1&styles=labelInFeatureInfoTazDemColorMapValues&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=145.11703491210938,-42.28939821012318,145.39443969726562,-42.01199342496693&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)"value is 1", (Object)properties.getString("Label_GRAY_INDEX"));
    }

    @Test
    public void testLabelInFeatureInfoMultipleSymbolizers() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo tazDem = cat.getLayerByName((Name)new NameImpl(MockData.TASMANIA_DEM.getPrefix(), MockData.TASMANIA_DEM.getLocalPart()));
        StyleInfo style = cat.getStyleByName(LABEL_IN_FEATURE_INFO_MULTIPLE_SYMBOLIZERS);
        tazDem.getStyles().add(style);
        cat.save(tazDem);
        String layerId = this.getLayerId(MockData.TASMANIA_DEM);
        String request = "wms?version=1.1.1&styles=labelInFeatureInfoTazDemMultipleSymbolizers&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=145.11703491210938,-42.28939821012318,145.39443969726562,-42.01199342496693&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
        Assert.assertEquals((long)2L, (long)properties.size());
        Assert.assertEquals((Object)">= 1 AND < 124.811736", (Object)properties.getString("first symbolizer"));
        Assert.assertEquals((Object)"value is 1", (Object)properties.getString("Label_GRAY_INDEX"));
    }

    @Test
    public void testLabelInFeatureInfoMultiBandColorMapRamp() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo tazDem = cat.getLayerByName((Name)new NameImpl(MockData.TASMANIA_BM.getPrefix(), MockData.TASMANIA_BM.getLocalPart()));
        StyleInfo style = cat.getStyleByName(LABEL_IN_FEATURE_INFO_STYLE_BM);
        tazDem.getStyles().add(style);
        cat.save(tazDem);
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        String request = "wms?version=1.1.1&styles=labelInFeatureInfoTazBm&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=147.22476194612682,-44.045562744140625,147.50216673128307,-43.768157958984375&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
        Assert.assertTrue((boolean)properties.has("Label_RED_BAND"));
        Assert.assertEquals((long)26L, (long)properties.getInt("RED_BAND"));
        Assert.assertEquals((Object)"21", (Object)properties.getString("Label_RED_BAND"));
    }

    @Test
    public void testLabelInFeatureInfoMultiBandMultipleSymbolizers() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo tazDem = cat.getLayerByName((Name)new NameImpl(MockData.TASMANIA_BM.getPrefix(), MockData.TASMANIA_BM.getLocalPart()));
        StyleInfo style = cat.getStyleByName(LABEL_IN_FEATURE_INFO_STYLE_MULTIPLE_SYMBLOZERS2);
        tazDem.getStyles().add(style);
        cat.save(tazDem);
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        String request = "wms?version=1.1.1&styles=labelInFeatureInfoTazBmMultipleSymbolizers&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=147.14566041715443,-44.49600223917514,147.42306520231068,-44.21859745401889&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
        Assert.assertEquals((Object)"13", (Object)properties.getString("Label1_RED_BAND"));
        Assert.assertEquals((Object)"value is 13", (Object)properties.getString("Label2_RED_BAND"));
    }

    @Test
    public void testRasterAndVectorInfo() throws Exception {
        String layerId = this.getLayerId(MockData.TASMANIA_BM);
        String request = "wms?version=1.1.1&styles=rasterVector&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=100&HEIGHT=100&BBOX=147.14566041715443,-44.49600223917514,147.42306520231068,-44.21859745401889&info_format=application/json&buffer=1";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)2L, (long)features.size());
        JSONObject vector = features.getJSONObject(0);
        Assert.assertNotNull((Object)vector.getString("id"));
        Assert.assertNotNull((Object)vector.getJSONObject("geometry"));
        JSONObject vectorProps = vector.getJSONObject("properties");
        Assert.assertEquals((long)13L, (long)vectorProps.getInt("RED_BAND"));
        Assert.assertEquals((long)36L, (long)vectorProps.getInt("GREEN_BAND"));
        Assert.assertEquals((long)76L, (long)vectorProps.getInt("BLUE_BAND"));
        JSONObject raster = features.getJSONObject(1);
        Assert.assertEquals((Object)"", (Object)raster.getString("id"));
        Assert.assertTrue((boolean)raster.getJSONObject("geometry").isNullObject());
        JSONObject rasterProps = raster.getJSONObject("properties");
        Assert.assertEquals((long)13L, (long)rasterProps.getInt("RED_BAND"));
        Assert.assertEquals((long)36L, (long)rasterProps.getInt("GREEN_BAND"));
        Assert.assertEquals((long)76L, (long)rasterProps.getInt("BLUE_BAND"));
    }

    @Test
    public void testMosaicFootprintRaster() throws Exception {
        String url = "wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=footprintsRaster&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'green%25' + &query_layers=sf:mosaic&x=10&y=10&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(url);
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)2L, (long)features.size());
        JSONObject vector = features.getJSONObject(0);
        Assert.assertNotNull((Object)vector.getString("id"));
        Assert.assertNotNull((Object)vector.getJSONObject("geometry"));
        Assert.assertEquals((Object)"MultiPolygon", (Object)vector.getJSONObject("geometry").getString("type"));
        JSONObject vectorProps = vector.getJSONObject("properties");
        Assert.assertEquals((Object)"green_00000002T0000000Z.tiff", (Object)vectorProps.getString("location"));
        Assert.assertEquals((Object)"0002-12-02T00:00:00Z", (Object)vectorProps.getString("ingestion"));
        JSONObject raster = features.getJSONObject(1);
        Assert.assertEquals((Object)"", (Object)raster.getString("id"));
        Assert.assertTrue((boolean)raster.getJSONObject("geometry").isNullObject());
        JSONObject rasterProps = raster.getJSONObject("properties");
        Assert.assertEquals((long)0L, (long)rasterProps.getInt("RED_BAND"));
        Assert.assertEquals((long)255L, (long)rasterProps.getInt("GREEN_BAND"));
        Assert.assertEquals((long)0L, (long)rasterProps.getInt("BLUE_BAND"));
    }

    @Test
    public void testIAURasterFeatureInfo() throws Exception {
        String layerId = this.getLayerId(SystemTestData.MARS_VIKING);
        String url = "wms?&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&x=10&y=10&LAYERS=" + layerId + "&query_layers=" + layerId + "&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(url);
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
    }

    @Test
    public void testIAUVectorFeatureInfo() throws Exception {
        String layerId = this.getLayerId(SystemTestData.MARS_POI);
        String url = "wms?&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=IAU:49900&BBOX=-180,-90,180,90&WIDTH=20&HEIGHT=20&x=10&y=10&buffer=20&LAYERS=" + layerId + "&query_layers=" + layerId + "&info_format=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(url);
        this.print((JSON)json);
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)"urn:ogc:def:crs:IAU::49900", (Object)json.getJSONObject("crs").getJSONObject("properties").getString("name"));
    }

    @Test
    public void testFeatureInfoRTMultiband() throws Exception {
        this.checkFeatureInfoRTMultiband(r -> r, 25);
        this.checkFeatureInfoRTMultiband(r -> r.replace("&X=50&Y=50", "&X=0&Y=0"), 0);
    }

    @Test
    public void testFeatureInfoRTMultibandSelection() throws Exception {
        this.checkFeatureInfoRTMultiband(r -> r + "&propertyNames=RED_BAND", 25);
        this.checkFeatureInfoRTMultiband(r -> (r + "&propertyNames=RED_BAND").replace("&X=50&Y=50", "&X=0&Y=0"), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFeatureInfoRTMultiband(Function<String, String> requestCustomizer, int expected) throws Exception {
        GeoTIFFSpyFormat.ENABLED = true;
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo spyStore = catalog.getCoverageStoreByName(TASMANIA_SPY.getPrefix(), TASMANIA_SPY.getLocalPart());
        spyStore.setType("GeoTIFFSpy");
        catalog.save((StoreInfo)spyStore);
        catalog.getResourcePool().clear(spyStore);
        try {
            String layerId = this.getLayerId(TASMANIA_SPY);
            Object request = "wms?version=1.1.1&styles=jiffleCondition&format=jpeg&request=GetFeatureInfo&layers=" + layerId + "&query_layers=" + layerId + "&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=146.5,-44.5,148,-43&info_format=application/json";
            request = requestCustomizer.apply((String)request);
            JSONObject json = (JSONObject)this.getAsJSON((String)request);
            JSONObject properties = json.getJSONArray("features").getJSONObject(0).getJSONObject("properties");
            Assert.assertTrue((boolean)properties.has("jiffle"));
            Assert.assertEquals((long)expected, (long)properties.getInt("jiffle"));
            GeneralParameterValue[] params = GeoTIFFSpyReader.getLastParams();
            GeneralParameterValue bands = this.getParameterValue(params, AbstractGridFormat.BANDS);
            Assert.assertNotNull((Object)bands);
            MatcherAssert.assertThat((Object)bands, (Matcher)CoreMatchers.instanceOf(ParameterValue.class));
            MatcherAssert.assertThat((Object)((ParameterValue)bands).intValueList(), (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 2}));
        }
        finally {
            GeoTIFFSpyFormat.ENABLED = false;
        }
    }

    private GeneralParameterValue getParameterValue(GeneralParameterValue[] params, DefaultParameterDescriptor<?> parameter) {
        for (GeneralParameterValue param : params) {
            if (!param.getDescriptor().equals(parameter)) continue;
            return param;
        }
        return null;
    }

    @Test
    public void testRATAttributes() throws Exception {
        JSONObject p00 = this.testRATAttributes(0, 0);
        Assert.assertEquals((double)1.1, (double)p00.getDouble("GRAY_INDEX"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)p00.getDouble("con_min"), (double)0.0);
        Assert.assertEquals((double)1.2, (double)p00.getDouble("con_max"), (double)0.0);
        Assert.assertEquals((Object)"green", (Object)p00.getString("test"));
        JSONObject p31 = this.testRATAttributes(3, 1);
        Assert.assertEquals((double)9.1, (double)p31.getDouble("GRAY_INDEX"), (double)0.0);
        Assert.assertEquals((double)9.0, (double)p31.getDouble("con_min"), (double)0.0);
        Assert.assertEquals((double)9.2, (double)p31.getDouble("con_max"), (double)0.001);
        Assert.assertEquals((Object)"orange", (Object)p31.getString("test"));
    }

    private JSONObject testRATAttributes(int x, int y) throws Exception {
        String layerId = this.getLayerId(RAT);
        String url = "wms?&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:26918&BBOX=737662,4603974,737678,4603982&LAYERS=" + layerId + "&query_layers=" + layerId + "&info_format=application/json&styles=rat&WIDTH=4&HEIGHT=2&x=" + x + "&y=" + y;
        JSONObject json = (JSONObject)this.getAsJSON(url);
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        return features.getJSONObject(0).getJSONObject("properties");
    }
}

