/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import org.geoserver.wms.featureinfo.FeatureTemplate;
import org.geoserver.wms.featureinfo.FreemarkerStaticsAccessRule;
import org.junit.Assert;
import org.junit.Test;

public class FreemarkerStaticsAccessRuleTest {
    @Test
    public void testNullEmpty() {
        FreemarkerStaticsAccessRule tmpRule = FreemarkerStaticsAccessRule.fromPattern(null);
        this.assertDisabled(tmpRule);
        tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)"");
        this.assertDisabled(tmpRule);
        tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)" , ");
        this.assertDisabled(tmpRule);
    }

    @Test
    public void testUnrestricted() {
        FreemarkerStaticsAccessRule tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)"*");
        Assert.assertTrue((boolean)tmpRule.isUnrestricted());
    }

    @Test
    public void testInvalid() {
        FreemarkerStaticsAccessRule tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)"a.b.C");
        this.assertDisabled(tmpRule);
        tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)"a.b.C, ..., .a.b,;");
        this.assertDisabled(tmpRule);
        tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)"true");
        this.assertDisabled(tmpRule);
        tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)"false");
        this.assertDisabled(tmpRule);
    }

    @Test
    public void testValid() {
        FreemarkerStaticsAccessRule tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)"java.lang.String");
        Assert.assertFalse((boolean)tmpRule.isUnrestricted());
        Assert.assertEquals((long)1L, (long)tmpRule.getAllowedItems().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(0)).getClassName());
        tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)(" java.lang.String  ,java.text.DecimalFormat  , " + FeatureTemplate.class.getName()));
        Assert.assertFalse((boolean)tmpRule.isUnrestricted());
        Assert.assertEquals((long)3L, (long)tmpRule.getAllowedItems().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(0)).getClassName());
        Assert.assertEquals((Object)"java.text.DecimalFormat", (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(1)).getClassName());
        Assert.assertEquals((Object)FeatureTemplate.class.getName(), (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(2)).getClassName());
        tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)(this.getClass().getName() + "$" + Dummy.class.getSimpleName()));
        Assert.assertFalse((boolean)tmpRule.isUnrestricted());
        Assert.assertEquals((long)1L, (long)tmpRule.getAllowedItems().size());
        Assert.assertEquals((Object)Dummy.class.getName(), (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(0)).getClassName());
        tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)" java.lang.String, not.existing.Class ,java.text.DecimalFormat");
        Assert.assertFalse((boolean)tmpRule.isUnrestricted());
        Assert.assertEquals((long)2L, (long)tmpRule.getAllowedItems().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(0)).getClassName());
        Assert.assertEquals((Object)"java.text.DecimalFormat", (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(1)).getClassName());
    }

    @Test
    public void testNumberPostfixes() {
        java.lang.String lName1 = String.class.getName();
        java.lang.String lName2 = String.class.getName();
        java.lang.String lName3 = Dummy.String.class.getName();
        this.assertSuffixes(lName1, lName2, lName3);
        lName1 = Dummy.String.class.getName();
        lName2 = String.class.getName();
        lName3 = String.class.getName();
        this.assertSuffixes(lName1, lName2, lName3);
    }

    private void assertSuffixes(java.lang.String aName1, java.lang.String aName2, java.lang.String aName3) {
        FreemarkerStaticsAccessRule tmpRule = FreemarkerStaticsAccessRule.fromPattern((java.lang.String)(aName1 + "," + aName2 + "," + aName3));
        Assert.assertFalse((boolean)tmpRule.isUnrestricted());
        Assert.assertEquals((long)3L, (long)tmpRule.getAllowedItems().size());
        Assert.assertEquals((Object)"String", (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(0)).getAlias());
        Assert.assertEquals((Object)aName1, (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(0)).getClassName());
        Assert.assertEquals((Object)"String2", (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(1)).getAlias());
        Assert.assertEquals((Object)aName2, (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(1)).getClassName());
        Assert.assertEquals((Object)"String3", (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(2)).getAlias());
        Assert.assertEquals((Object)aName3, (Object)((FreemarkerStaticsAccessRule.RuleItem)tmpRule.getAllowedItems().get(2)).getClassName());
    }

    private void assertDisabled(FreemarkerStaticsAccessRule aRule) {
        Assert.assertFalse((boolean)aRule.isUnrestricted());
        Assert.assertTrue((boolean)aRule.getAllowedItems().isEmpty());
    }

    public static final class String {
    }

    public static final class Dummy {

        public static final class String {
        }
    }
}

