/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import org.geoserver.wms.featureinfo.ColorMapLabelMatcher;
import org.geoserver.wms.featureinfo.ColorMapLabelMatcherExtractor;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.xml.styling.SLDParser;
import org.junit.Assert;
import org.junit.Test;

public class ColorMapLabelMatcherTest {
    @Test
    public void testLabelMatchWithColorMapRamp() throws IOException {
        Style style = ColorMapLabelMatcherTest.readSLD("labelInFeatureInfoTazDem.sld", this.getClass());
        ColorMapLabelMatcherExtractor extractor = new ColorMapLabelMatcherExtractor(1091957.546931);
        style.accept((StyleVisitor)extractor);
        ColorMapLabelMatcher lifi = (ColorMapLabelMatcher)extractor.getColorMapLabelMatcherList().get(0);
        String label = lifi.getLabelForPixel(13.0);
        Assert.assertEquals((Object)"1", (Object)label);
        label = lifi.getLabelForPixel(155.98766);
        Assert.assertEquals((Object)"124.811736", (Object)label);
        label = lifi.getLabelForPixel(547.9222);
        Assert.assertEquals((Object)"559.204195", (Object)label);
        label = lifi.getLabelForPixel(46421.765);
        Assert.assertEquals((Object)"55537", (Object)label);
        label = lifi.getLabelForPixel(60000.0);
        Assert.assertEquals((Object)"55537", (Object)label);
    }

    @Test
    public void testLabelMatchWithColorMapTypeIntervals() throws IOException {
        Style style = ColorMapLabelMatcherTest.readSLD("labelInFeatureInfoTazDemReplace.sld", this.getClass());
        ColorMapLabelMatcherExtractor extractor = new ColorMapLabelMatcherExtractor(1091957.546931);
        style.accept((StyleVisitor)extractor);
        ColorMapLabelMatcher lifi = (ColorMapLabelMatcher)extractor.getColorMapLabelMatcherList().get(0);
        String label = lifi.getLabelForPixel(13.0);
        Assert.assertEquals((Object)">= 1 AND < 124.811736", (Object)label);
        label = lifi.getLabelForPixel(155.98766);
        Assert.assertEquals((Object)">= 124.811736 AND < 308.142116", (Object)label);
        label = lifi.getLabelForPixel(547.9222);
        Assert.assertEquals((Object)">= 308.142116 AND < 752.166285", (Object)label);
        label = lifi.getLabelForPixel(46421.765);
        Assert.assertEquals((Object)">= 752.166285 AND <= 55537", (Object)label);
        label = lifi.getLabelForPixel(60000.0);
        Assert.assertNull((Object)label);
    }

    @Test
    public void testLabelMatchColorMapTypeValues() throws IOException {
        Style style = ColorMapLabelMatcherTest.readSLD("labelInFeatureInfoTazDemColorMapValues.sld", this.getClass());
        ColorMapLabelMatcherExtractor extractor = new ColorMapLabelMatcherExtractor(1091957.546931);
        style.accept((StyleVisitor)extractor);
        ColorMapLabelMatcher lifi = (ColorMapLabelMatcher)extractor.getColorMapLabelMatcherList().get(0);
        String label = lifi.getLabelForPixel(1.0);
        Assert.assertEquals((Object)"value is 1", (Object)label);
        label = lifi.getLabelForPixel(124.81173566700335);
        Assert.assertEquals((Object)"value is 124.811736", (Object)label);
        label = lifi.getLabelForPixel(559.2041949413946);
        Assert.assertEquals((Object)"value is 559.204195", (Object)label);
        label = lifi.getLabelForPixel(55537.0);
        Assert.assertEquals((Object)"value is 55537", (Object)label);
        label = lifi.getLabelForPixel(13.0);
        Assert.assertNull((Object)label);
        label = lifi.getLabelForPixel(130.0);
        Assert.assertNull((Object)label);
        label = lifi.getLabelForPixel(601.0);
        Assert.assertNull((Object)label);
        label = lifi.getLabelForPixel(55000.0);
        Assert.assertNull((Object)label);
    }

    static Style readSLD(String sldName, Class<?> context) throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        SLDParser stylereader = new SLDParser(styleFactory, context.getResource(sldName));
        Style[] readStyles = stylereader.readXML();
        Style style = readStyles[0];
        return style;
    }
}

