/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.util.Collections;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.type.DateUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VectorCustomDimensionDefaultValueTest
extends WMSTestSupport {
    private static final QName TIME_ELEVATION_CUSTOM = new QName(MockData.SF_URI, "TimeElevationCustom", MockData.SF_PREFIX);
    private static final String REFERENCE_TIME_DIMENSION = "REFERENCE_TIME";
    private static final String SCANNING_ANGLE_DIMENSION = "SCANNING_ANGLE";
    WMS wms;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @Before
    public void setup() throws Exception {
        this.wms = this.getWMS();
        ((SystemTestData)testData).addVectorLayer(TIME_ELEVATION_CUSTOM, Collections.emptyMap(), "TimeElevationCustom.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testDefaultCustomDimDateValueVectorSelector() throws Exception {
        int fid = 1000;
        this.setupFeatureCustomDimension(REFERENCE_TIME_DIMENSION, "referenceTime", null);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        Date originallySmallest = Date.valueOf("2011-04-20");
        java.util.Date d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the smallest one", (long)d.getTime(), (long)originallySmallest.getTime());
        Date biggest = Date.valueOf("2021-01-01");
        this.addFeatureWithReferenceTime(fid++, biggest);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the smallest one", (long)d.getTime(), (long)originallySmallest.getTime());
        Date smaller = Date.valueOf("2010-01-01");
        this.addFeatureWithReferenceTime(fid++, smaller);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the smallest one", (long)d.getTime(), (long)smaller.getTime());
    }

    @Test
    public void testDefaultCustomDimDoubleValueVectorSelector() throws Exception {
        int fid = 1000;
        this.setupFeatureCustomDimension(SCANNING_ANGLE_DIMENSION, "scanningAngle", null);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        Double originallySmallest = 0.0;
        Double d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - originallySmallest) < 1.0E-4 ? 1 : 0) != 0);
        Double biggest = 2.1;
        this.addFeatureWithScanningAngle(fid++, biggest);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - originallySmallest) < 1.0E-4 ? 1 : 0) != 0);
        Double smaller = -1.0;
        this.addFeatureWithScanningAngle(fid++, smaller);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - smaller) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitMinCustomDimDateValueVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MINIMUM);
        this.setupFeatureCustomDimension(REFERENCE_TIME_DIMENSION, "referenceTime", defaultValueSetting);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        Date originallySmallest = Date.valueOf("2011-04-20");
        java.util.Date d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the smallest one", (long)d.getTime(), (long)originallySmallest.getTime());
        Date biggest = Date.valueOf("2021-01-01");
        this.addFeatureWithReferenceTime(fid++, biggest);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the smallest one", (long)d.getTime(), (long)originallySmallest.getTime());
        Date smaller = Date.valueOf("2010-01-01");
        this.addFeatureWithReferenceTime(fid++, smaller);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the smallest one", (long)d.getTime(), (long)smaller.getTime());
    }

    @Test
    public void testExplicitMinCustomDimDoubleValueVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MINIMUM);
        this.setupFeatureCustomDimension(SCANNING_ANGLE_DIMENSION, "scanningAngle", defaultValueSetting);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        Double originallySmallest = 0.0;
        Double d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - originallySmallest) < 1.0E-4 ? 1 : 0) != 0);
        Double biggest = 2.1;
        this.addFeatureWithScanningAngle(fid++, biggest);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - originallySmallest) < 1.0E-4 ? 1 : 0) != 0);
        Double smaller = -1.0;
        this.addFeatureWithScanningAngle(fid++, smaller);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - smaller) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitMaxCustomDimDateValueVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MAXIMUM);
        this.setupFeatureCustomDimension(REFERENCE_TIME_DIMENSION, "referenceTime", defaultValueSetting);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        Date originallyBiggest = Date.valueOf("2011-04-23");
        java.util.Date d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the biggest one", (long)d.getTime(), (long)originallyBiggest.getTime());
        Date biggest = Date.valueOf("2021-01-01");
        this.addFeatureWithReferenceTime(fid++, biggest);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the biggest one", (long)d.getTime(), (long)biggest.getTime());
        Date smaller = Date.valueOf("2014-01-01");
        this.addFeatureWithReferenceTime(fid++, smaller);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the biggest one", (long)d.getTime(), (long)biggest.getTime());
    }

    @Test
    public void testExplicitMaxCustomDimDoubleValueVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MAXIMUM);
        this.setupFeatureCustomDimension(SCANNING_ANGLE_DIMENSION, "scanningAngle", defaultValueSetting);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        Double originallyBiggest = 1.5;
        Double d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - originallyBiggest) < 1.0E-4 ? 1 : 0) != 0);
        Double biggest = 2.1;
        this.addFeatureWithScanningAngle(fid++, biggest);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - biggest) < 1.0E-4 ? 1 : 0) != 0);
        Double smaller = 1.8;
        this.addFeatureWithScanningAngle(fid++, smaller);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - biggest) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitFixedCustomDimDateValueVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        String fixedStr = "2014-01-20T00:00:00Z";
        defaultValueSetting.setReferenceValue(fixedStr);
        this.setupFeatureCustomDimension(REFERENCE_TIME_DIMENSION, "referenceTime", defaultValueSetting);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        long fixed = DateUtil.parseDateTime((String)fixedStr);
        java.util.Date d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the fixed one", (long)d.getTime(), (long)fixed);
        Date biggest = Date.valueOf("2021-01-01");
        this.addFeatureWithReferenceTime(fid++, biggest);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the fixed one", (long)d.getTime(), (long)fixed);
        Date smaller = Date.valueOf("2010-01-01");
        this.addFeatureWithReferenceTime(fid++, smaller);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the fixed one", (long)d.getTime(), (long)fixed);
    }

    @Test
    public void testExplicitFixedCustomDimDoubleValueVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        String fixedStr = "42.1";
        defaultValueSetting.setReferenceValue(fixedStr);
        double fixed = Double.parseDouble(fixedStr);
        this.setupFeatureCustomDimension(SCANNING_ANGLE_DIMENSION, "scanningAngle", defaultValueSetting);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        Double d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - fixed) < 1.0E-4 ? 1 : 0) != 0);
        Double biggest = 2.1;
        this.addFeatureWithScanningAngle(fid++, biggest);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - fixed) < 1.0E-4 ? 1 : 0) != 0);
        Double smaller = 1.8;
        this.addFeatureWithScanningAngle(fid++, smaller);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the smallest one", (Math.abs(d - fixed) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitNearestToGivenValueCustomDimDateValueVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        String referenceStr = "2014-01-20T00:00:00Z";
        defaultValueSetting.setReferenceValue(referenceStr);
        this.setupFeatureCustomDimension(REFERENCE_TIME_DIMENSION, "referenceTime", defaultValueSetting);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        Date originallyBiggest = Date.valueOf("2011-04-23");
        java.util.Date d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the closest one", (long)d.getTime(), (long)originallyBiggest.getTime());
        Date biggerThanOriginal = Date.valueOf("2012-01-01");
        this.addFeatureWithReferenceTime(fid++, biggerThanOriginal);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the closest one", (long)d.getTime(), (long)biggerThanOriginal.getTime());
        Date biggerThanReference = Date.valueOf("2014-06-01");
        this.addFeatureWithReferenceTime(fid++, biggerThanReference);
        d = (java.util.Date)this.wms.getDefaultCustomDimensionValue(REFERENCE_TIME_DIMENSION, (ResourceInfo)timeElevationCustom, java.util.Date.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertEquals((String)"Default value should be the closest one", (long)d.getTime(), (long)biggerThanReference.getTime());
    }

    @Test
    public void testExplicitNearestToGivenValueCustomDimDoubleValueVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        String referenceStr = "2.3";
        defaultValueSetting.setReferenceValue(referenceStr);
        this.setupFeatureCustomDimension(SCANNING_ANGLE_DIMENSION, "scanningAngle", defaultValueSetting);
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        double originallyBiggest = 1.5;
        Double d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the closest one", (Math.abs(d - originallyBiggest) < 1.0E-4 ? 1 : 0) != 0);
        double biggerThanOriginal = 1.7;
        this.addFeatureWithScanningAngle(fid++, biggerThanOriginal);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the closest one", (Math.abs(d - biggerThanOriginal) < 1.0E-4 ? 1 : 0) != 0);
        double biggerThanReference = 2.45;
        this.addFeatureWithScanningAngle(fid++, biggerThanReference);
        d = (Double)this.wms.getDefaultCustomDimensionValue(SCANNING_ANGLE_DIMENSION, (ResourceInfo)timeElevationCustom, Double.class);
        Assert.assertNotNull((String)"Default value is null", (Object)d);
        Assert.assertTrue((String)"Default value should be the closest one", (Math.abs(d - biggerThanReference) < 1.0E-4 ? 1 : 0) != 0);
    }

    protected void setupFeatureCustomDimension(String dimensionName, String attrName, DimensionDefaultValueSetting defaultValue) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute(attrName);
        di.setDefaultValue(defaultValue);
        di.setPresentation(DimensionPresentation.LIST);
        info.getMetadata().put("custom_dimension_" + dimensionName, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void addFeature(int id, Date time, Double elevation, Date referenceTime, Double scanningAngle) throws IOException {
        FeatureTypeInfo timeElevationCustom = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_CUSTOM.getLocalPart());
        SimpleFeatureStore fs = (SimpleFeatureStore)timeElevationCustom.getFeatureSource(null, null);
        SimpleFeatureType type = (SimpleFeatureType)timeElevationCustom.getFeatureType();
        MemoryFeatureCollection coll = new MemoryFeatureCollection(type);
        StringBuffer content = new StringBuffer();
        content.append(id);
        content.append('|');
        content.append(time.toString());
        content.append('|');
        content.append(elevation);
        content.append('|');
        content.append(referenceTime.toString());
        content.append('|');
        content.append(scanningAngle);
        SimpleFeature f = DataUtilities.createFeature((SimpleFeatureType)type, (String)content.toString());
        coll.add(f);
        try (Transaction tx = fs.getTransaction();){
            fs.addFeatures((FeatureCollection)coll);
            tx.commit();
        }
    }

    private void addFeatureWithReferenceTime(int fid, Date time) throws IOException {
        this.addFeature(fid, Date.valueOf("2013-01-13"), 0.0, time, 0.0);
    }

    private void addFeatureWithScanningAngle(int fid, Double angle) throws IOException {
        this.addFeature(fid, Date.valueOf("2013-01-13"), 0.0, Date.valueOf("2014-01-20"), angle);
    }
}

