/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.decoration.TextDecoration;
import org.geotools.api.filter.expression.Literal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TextDecorationTest {
    @After
    public void clearRequest() {
        Dispatcher.REQUEST.remove();
    }

    @Test
    public void testExpandRequestVariable() throws Exception {
        Request request = new Request();
        CaseInsensitiveMap kvp = new CaseInsensitiveMap(new HashMap());
        kvp.put("time", "2008-10-31T00:00:00.000Z");
        request.setRawKvp((Map)kvp);
        Dispatcher.REQUEST.set(request);
        TextDecoration decoration = new TextDecoration();
        HashMap<String, Literal> options = new HashMap<String, Literal>();
        options.put("message", MapDecorationLayout.FF.literal((Object)"<#setting datetime_format=\"yyyy-MM-dd'T'HH:mm:ss.SSSX\">\n<#setting locale=\"en_US\">\n<#setting time_zone=\"GMT\"><#if time??>\n${time?datetime?string[\"dd.MM.yyyy\"]}</#if>"));
        decoration.loadOptions(options);
        GetMapRequest getMap = new GetMapRequest();
        WMSMapContent wmsMapContent = new WMSMapContent(getMap);
        String message = decoration.evaluateMessage(wmsMapContent);
        Assert.assertEquals((Object)"31.10.2008", (Object)message);
    }
}

