/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.util.Locale;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupStyleImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetCapabilitiesReponseTest
extends WMSTestSupport {
    @Test
    public void testSimple() throws Exception {
        String request = "wms?version=1.1.1&request=GetCapabilities&service=WMS";
        MockHttpServletResponse result = this.getAsServletResponse(request);
        Assert.assertTrue((boolean)result.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline; filename=getcapabilities_1.1.1.xml", (Object)result.getHeader("content-disposition"));
        request = "wms?version=1.3.0&request=GetCapabilities&service=WMS";
        result = this.getAsServletResponse(request);
        Assert.assertTrue((boolean)result.containsHeader("content-disposition"));
        Assert.assertEquals((Object)"inline; filename=getcapabilities_1.3.0.xml", (Object)result.getHeader("content-disposition"));
    }

    @Test
    public void testInternationalContent() throws Exception {
        Catalog catalog = this.getCatalog();
        GeoServer geoServer = this.getGeoServer();
        LayerGroupInfo groupInfo = catalog.getLayerGroupByName("nature");
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for group nature");
        title.add(Locale.ITALIAN, "titolo italiano");
        GrowableInternationalString _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for group nature");
        _abstract.add(Locale.ITALIAN, "abstract italiano");
        groupInfo.setInternationalTitle((InternationalString)title);
        groupInfo.setInternationalAbstract((InternationalString)_abstract);
        Keyword keywordInfo = new Keyword("english keyword");
        keywordInfo.setLanguage(Locale.ENGLISH.getLanguage());
        Keyword keywordInfo2 = new Keyword("parola chiave");
        keywordInfo2.setLanguage(Locale.ITALIAN.getLanguage());
        groupInfo.getKeywords().add(keywordInfo);
        groupInfo.getKeywords().add(keywordInfo2);
        groupInfo.setMode(LayerGroupInfo.Mode.NAMED);
        catalog.save(groupInfo);
        LayerInfo fifteen = catalog.getLayerByName(this.getLayerId(MockData.FIFTEEN));
        title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for layer fifteen");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for layer fifteen");
        fifteen.setInternationalTitle((InternationalString)title);
        fifteen.setInternationalAbstract((InternationalString)_abstract);
        catalog.save(fifteen);
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for layer lakes");
        lakes.setTitle(null);
        lakes.setInternationalTitle((InternationalString)title);
        lakes.setInternationalAbstract((InternationalString)_abstract);
        catalog.save(lakes);
        WMSInfo info = (WMSInfo)geoServer.getService(WMSInfo.class);
        title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for WMS service");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for WMS service");
        info.setInternationalTitle((InternationalString)title);
        info.setInternationalAbstract((InternationalString)_abstract);
        geoServer.save((ServiceInfo)info);
        String request = "wms?version=1.1.1&request=GetCapabilities&service=WMS&AcceptLanguages=" + Locale.ENGLISH.getLanguage();
        Document result = this.getAsDOM(request);
        String service = "/WMT_MS_Capabilities/Service";
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n title for WMS service", (String)(service + "/Title"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n abstract for WMS service", (String)(service + "/Abstract"), (Document)result);
        String fifteenLayer = "/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'cdf:Fifteen']";
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n title for layer fifteen", (String)(fifteenLayer + "/Title"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n abstract for layer fifteen", (String)(fifteenLayer + "/Abstract"), (Document)result);
        String natureGroup = "/WMT_MS_Capabilities/Capability/Layer/Layer/Layer[Name = 'nature']";
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n title for group nature", (String)(natureGroup + "/Title"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"a i18n abstract for group nature", (String)(natureGroup + "/Abstract"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"english keyword", (String)(natureGroup + "/KeywordList/Keyword"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='cite:Lakes'])", (Document)result);
    }

    @Test
    public void testInternationalContentAnyLanguage() throws Exception {
        Catalog catalog = this.getCatalog();
        GeoServer geoServer = this.getGeoServer();
        LayerGroupInfo groupInfo = catalog.getLayerGroupByName("nature");
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ITALIAN, "titolo italiano");
        GrowableInternationalString _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ITALIAN, "abstract italiano");
        groupInfo.setInternationalTitle((InternationalString)title);
        groupInfo.setInternationalAbstract((InternationalString)_abstract);
        Keyword keywordInfo = new Keyword("parola chiave");
        keywordInfo.setLanguage(Locale.ITALIAN.getLanguage());
        groupInfo.getKeywords().add(keywordInfo);
        catalog.save(groupInfo);
        LayerInfo li = catalog.getLayerByName(this.getLayerId(MockData.FIFTEEN));
        title = new GrowableInternationalString();
        title.add(Locale.ITALIAN, "titolo per layer fifteen");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ITALIAN, "abstract per layer fifteen");
        li.setInternationalTitle((InternationalString)title);
        li.setInternationalAbstract((InternationalString)_abstract);
        catalog.save(li);
        WMSInfo info = (WMSInfo)geoServer.getService(WMSInfo.class);
        title = new GrowableInternationalString();
        title.add(Locale.ITALIAN, "Servizio WMS");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ITALIAN, "Abstract del servizio WMS");
        info.setInternationalTitle((InternationalString)title);
        info.setInternationalAbstract((InternationalString)_abstract);
        geoServer.save((ServiceInfo)info);
        String request = "wms?version=1.1.1&request=GetCapabilities&service=WMS&AcceptLanguages=" + Locale.FRENCH.getLanguage() + " *";
        Document result = this.getAsDOM(request);
        String service = "/WMT_MS_Capabilities/Service";
        XMLAssert.assertXpathEvaluatesTo((String)"Servizio WMS", (String)(service + "/Title"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"Abstract del servizio WMS", (String)(service + "/Abstract"), (Document)result);
        String fifteenLayer = "/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'cdf:Fifteen']";
        XMLAssert.assertXpathEvaluatesTo((String)"titolo per layer fifteen", (String)(fifteenLayer + "/Title"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract per layer fifteen", (String)(fifteenLayer + "/Abstract"), (Document)result);
        String natureGroup = "/WMT_MS_Capabilities/Capability/Layer/Layer/Layer[Name = 'nature']";
        XMLAssert.assertXpathEvaluatesTo((String)"titolo italiano", (String)(natureGroup + "/Title"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract italiano", (String)(natureGroup + "/Abstract"), (Document)result);
        XMLAssert.assertXpathEvaluatesTo((String)"parola chiave", (String)(natureGroup + "/KeywordList/Keyword"), (Document)result);
    }

    @Test
    public void testAcceptLanguagesParameter() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.FIFTEEN));
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
        title.add(Locale.ITALIAN, "titolo italiano");
        fti.setInternationalTitle((InternationalString)title);
        catalog.save((ResourceInfo)fti);
        GeoServer geoServer = this.getGeoServer();
        WMSInfo wmsInfo = this.getWMS().getServiceInfo();
        wmsInfo.setOnlineResource("");
        geoServer.save((ServiceInfo)wmsInfo);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setOnlineResource("");
        global.getSettings().getContact().setOnlineResource("");
        geoServer.save(global);
        Document dom = this.getAsDOM("wms?version=1.1.1&request=GetCapabilities&service=WMS&AcceptLanguages=it");
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/?Language=it", (String)"WMT_MS_Capabilities/Service/OnlineResource/@xlink:href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/wms?SERVICE=WMS&Language=it&", (String)"WMT_MS_Capabilities/Capability/Request/GetCapabilities/DCPType/HTTP/Get/OnlineResource/@xlink:href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/wms?request=GetLegendGraphic&version=1.1.1&format=image%2Fpng&width=20&height=20&layer=nature&Language=it", (String)"//Layer[Name='nature']/Style/LegendURL/OnlineResource/@xlink:href", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullLocale() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo old = catalog.getFeatureTypeByName(this.getLayerId(MockData.FIFTEEN));
        try {
            FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.FIFTEEN));
            GrowableInternationalString title = new GrowableInternationalString();
            title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
            title.add(null, "null locale title");
            fti.setInternationalTitle((InternationalString)title);
            GrowableInternationalString abstrct = new GrowableInternationalString();
            abstrct.add(Locale.ENGLISH, "english abstract");
            abstrct.add(null, "null locale abstract");
            fti.setInternationalAbstract((InternationalString)abstrct);
            fti.setTitle(null);
            fti.setAbstract(null);
            catalog.save((ResourceInfo)fti);
            Document dom = this.getAsDOM("wms?version=1.1.1&request=GetCapabilities&service=WMS");
            String fifteenLayer = "/WMT_MS_Capabilities/Capability/Layer/Layer[Name = 'cdf:Fifteen']";
            XMLAssert.assertXpathEvaluatesTo((String)"null locale title", (String)(fifteenLayer + "/Title"), (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"null locale abstract", (String)(fifteenLayer + "/Abstract"), (Document)dom);
        }
        finally {
            catalog.save((ResourceInfo)old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInternationalContentContact() throws Exception {
        ContactInfo old = this.getGeoServer().getSettings().getContact();
        try {
            GrowableInternationalString person = new GrowableInternationalString();
            person.add(Locale.ITALIAN, "I'm an italian person");
            person.add(Locale.ENGLISH, "I'm an english person");
            ContactInfoImpl contactInfo = new ContactInfoImpl();
            contactInfo.setInternationalContactPerson((InternationalString)person);
            GrowableInternationalString org = new GrowableInternationalString();
            org.add(Locale.ITALIAN, "I'm an italian organization");
            org.add(Locale.ENGLISH, "I'm an english organization");
            contactInfo.setInternationalContactOrganization((InternationalString)org);
            GrowableInternationalString email = new GrowableInternationalString();
            email.add(Locale.ITALIAN, "italian@person.it");
            email.add(Locale.ENGLISH, "english@person.com");
            contactInfo.setInternationalContactEmail((InternationalString)email);
            GrowableInternationalString position = new GrowableInternationalString();
            position.add(Locale.ITALIAN, "Cartografo");
            position.add(Locale.ENGLISH, "Cartographer");
            contactInfo.setInternationalContactPosition((InternationalString)position);
            GrowableInternationalString tel = new GrowableInternationalString();
            tel.add(Locale.ITALIAN, "0558077333");
            tel.add(Locale.ENGLISH, "02304566607");
            contactInfo.setInternationalContactVoice((InternationalString)tel);
            GrowableInternationalString fax = new GrowableInternationalString();
            fax.add(Locale.ITALIAN, "0557777333");
            fax.add(Locale.ENGLISH, "0023030948");
            contactInfo.setInternationalContactFacsimile((InternationalString)fax);
            GrowableInternationalString address = new GrowableInternationalString();
            address.add(Locale.ITALIAN, "indirizzo");
            address.add(Locale.ENGLISH, "address");
            contactInfo.setInternationalAddress((InternationalString)address);
            GrowableInternationalString addressType = new GrowableInternationalString();
            addressType.add(Locale.ITALIAN, "lavoro");
            addressType.add(Locale.ENGLISH, "work");
            contactInfo.setInternationalAddressType((InternationalString)addressType);
            GrowableInternationalString country = new GrowableInternationalString();
            country.add(Locale.ITALIAN, "Italia");
            country.add(Locale.ENGLISH, "England");
            contactInfo.setInternationalAddressCountry((InternationalString)country);
            GrowableInternationalString city = new GrowableInternationalString();
            city.add(Locale.ITALIAN, "Roma");
            city.add(Locale.ENGLISH, "London");
            contactInfo.setInternationalAddressCity((InternationalString)city);
            GrowableInternationalString postalCode = new GrowableInternationalString();
            postalCode.add(Locale.ITALIAN, "50021");
            postalCode.add(Locale.ENGLISH, "34234");
            contactInfo.setInternationalAddressPostalCode((InternationalString)postalCode);
            GeoServerInfo global = this.getGeoServer().getGlobal();
            global.getSettings().setContact((ContactInfo)contactInfo);
            this.getGeoServer().save(global);
            Document doc = this.getAsDOM("wms?version=1.1.1&request=GetCapabilities&service=WMS&AcceptLanguages=en");
            String contactInf = "//ContactInformation";
            String primary = contactInf + "/ContactPersonPrimary";
            XMLAssert.assertXpathEvaluatesTo((String)"I'm an english organization", (String)(primary + "/ContactOrganization"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"I'm an english person", (String)(primary + "/ContactPerson"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"Cartographer", (String)(contactInf + "/ContactPosition"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"02304566607", (String)(contactInf + "/ContactVoiceTelephone"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"0023030948", (String)(contactInf + "/ContactFacsimileTelephone"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"english@person.com", (String)(contactInf + "/ContactElectronicMailAddress"), (Document)doc);
            String addrInfo = contactInf + "/ContactAddress";
            XMLAssert.assertXpathEvaluatesTo((String)"work", (String)(addrInfo + "/AddressType"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"address", (String)(addrInfo + "/Address"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"London", (String)(addrInfo + "/City"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"England", (String)(addrInfo + "/Country"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"34234", (String)(addrInfo + "/PostCode"), (Document)doc);
        }
        finally {
            GeoServerInfo global = this.getGeoServer().getGlobal();
            global.getSettings().setContact(old);
            this.getGeoServer().save(global);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLayerGroupStyle() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo groupInfo = null;
        try {
            String layerGroupName = "test_group_style";
            this.createLakesPlacesLayerGroup(catalog, layerGroupName, LayerGroupInfo.Mode.SINGLE, null);
            groupInfo = catalog.getLayerGroupByName(layerGroupName);
            LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
            StyleInfoImpl groupStyleName = new StyleInfoImpl(catalog);
            groupStyleName.setName("group-style-name");
            groupStyle.setName((StyleInfo)groupStyleName);
            groupStyle.getLayers().add(catalog.getLayerByName("cite:Forests"));
            groupStyle.getStyles().add(null);
            groupInfo.getLayerGroupStyles().add(groupStyle);
            catalog.save(groupInfo);
            String request = "wms?version=1.1.1&request=GetCapabilities&service=WMS";
            Document result = this.getAsDOM(request);
            String groupStyleEl = "//Layer[Name = '" + layerGroupName + "']/Style[Name = 'group-style-name']";
            XMLAssert.assertXpathExists((String)groupStyleEl, (Document)result);
            if (groupInfo == null) return;
        }
        catch (Throwable throwable) {
            if (groupInfo == null) throw throwable;
            catalog.remove(groupInfo);
            throw throwable;
        }
        catalog.remove(groupInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLayerGroupStyleOpaque() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo groupInfo = null;
        try {
            String layerGroupName = "test_group_style";
            this.createLakesPlacesLayerGroup(catalog, layerGroupName, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null);
            groupInfo = catalog.getLayerGroupByName(layerGroupName);
            LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
            StyleInfoImpl groupStyleName = new StyleInfoImpl(catalog);
            groupStyleName.setName("group-style-name");
            groupStyle.setName((StyleInfo)groupStyleName);
            groupStyle.getLayers().add(catalog.getLayerByName("cite:Forests"));
            groupStyle.getStyles().add(null);
            groupInfo.getLayerGroupStyles().add(groupStyle);
            catalog.save(groupInfo);
            String request = "wms?version=1.1.1&request=GetCapabilities&service=WMS";
            Document result = this.getAsDOM(request);
            String groupStyleEl = "//Layer[Name = '" + layerGroupName + "']/Style[Name = 'group-style-name']";
            XMLAssert.assertXpathExists((String)groupStyleEl, (Document)result);
            if (groupInfo == null) return;
        }
        catch (Throwable throwable) {
            if (groupInfo == null) throw throwable;
            catalog.remove(groupInfo);
            throw throwable;
        }
        catalog.remove(groupInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLayerGroupStyleSkippedWhenTree() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo groupInfo = null;
        try {
            String layerGroupName = "test_group_style";
            this.createLakesPlacesLayerGroup(catalog, layerGroupName, LayerGroupInfo.Mode.NAMED, null);
            groupInfo = catalog.getLayerGroupByName(layerGroupName);
            LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
            StyleInfoImpl groupStyleName = new StyleInfoImpl(catalog);
            groupStyleName.setName("group-style-name");
            groupStyle.setName((StyleInfo)groupStyleName);
            groupStyle.getLayers().add(catalog.getLayerByName("cite:Forests"));
            groupStyle.getStyles().add(null);
            groupInfo.getLayerGroupStyles().add(groupStyle);
            catalog.save(groupInfo);
            String request = "wms?version=1.1.1&request=GetCapabilities&service=WMS";
            Document result = this.getAsDOM(request);
            String groupStyleEl = "//Layer[Name = '" + layerGroupName + "']/Style[Name = 'group-style-name']";
            XMLAssert.assertXpathNotExists((String)groupStyleEl, (Document)result);
            if (groupInfo == null) return;
        }
        catch (Throwable throwable) {
            if (groupInfo == null) throw throwable;
            catalog.remove(groupInfo);
            throw throwable;
        }
        catalog.remove(groupInfo);
    }

    @Test
    public void testMarsLayers11() throws Exception {
        Document dom = this.getAsDOM("iau/wms?request=GetCapabilities&version=1.1.1&service=WMS");
        XMLAssert.assertXpathExists((String)"//Layer[Name='Viking']/SRS[text()='IAU:49900']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//Layer[Name='Viking']/BoundingBox[@SRS='IAU:49900']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//Layer[Name='MarsPoi']/SRS[text()='IAU:49900']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//Layer[Name='MarsPoi']/BoundingBox[@SRS='IAU:49900']", (Document)dom);
    }

    @Test
    public void testWmtVer() throws Exception {
        Document dom = this.getAsDOM("wms?request=GetCapabilities&wmtver=1.0.0&service=WMS");
        XMLAssert.assertXpathEvaluatesTo((String)"1.0.0", (String)"/WMT_MS_Capabilities/@version", (Document)dom);
    }
}

