/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.locationtech.jts.geom.Envelope;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WMSVectorDimensionValidationTest
extends WMSTestSupport {
    private static final QName TIME_WITH_START_END = new QName(MockData.SF_URI, "TimeWithStartEnd", MockData.SF_PREFIX);
    private static final QName ELEVATION_WITH_START_END = new QName(MockData.SF_URI, "ElevationWithStartEnd", MockData.SF_PREFIX);
    private static final QName CUSTOM_DIM_WITH_START_END = new QName(MockData.SF_URI, "CustomDimensionWithStartEnd", MockData.SF_PREFIX);
    private WMS wms;
    @Captor
    ArgumentCaptor<Query> queryArgumentCaptor;

    @Before
    public void setWMS() {
        this.wms = this.getWMS();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        String testDataFileName = "TimeElevationWithStartEnd.properties";
        testData.addVectorLayer(TIME_WITH_START_END, Collections.emptyMap(), testDataFileName, ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addVectorLayer(ELEVATION_WITH_START_END, Collections.emptyMap(), testDataFileName, ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addVectorLayer(CUSTOM_DIM_WITH_START_END, Collections.emptyMap(), testDataFileName, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void matchingTimeDimensionShouldValidate() throws IOException {
        String dimension = "time";
        Date dimensionValue = Date.from(Instant.parse("2012-02-11T10:15:30.00Z"));
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.singletonList(dimensionValue), Collections.emptyList(), Collections.emptyMap());
        this.setValidationEnabled(true);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), TIME_WITH_START_END, dimension, "startTime", "endTime"), request, dimension, dimensionValue, true);
    }

    @Test
    public void timeQueryShouldHaveOneAttributeAndLimitMaxFeaturesToOne() throws IOException {
        String dimension = "time";
        Date dimensionValue = Date.from(Instant.parse("2012-02-11T10:15:30.00Z"));
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.singletonList(dimensionValue), Collections.emptyList(), Collections.emptyMap());
        WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), TIME_WITH_START_END, dimension, "startTime", "endTime");
        this.assertQueryContent(TIME_WITH_START_END, request, "startTime");
    }

    @Test
    public void mismatchingTimeDimensionShouldNotValidate() throws IOException {
        String dimension = "time";
        Date dimensionValue = Date.from(Instant.parse("2012-02-10T10:15:30.00Z"));
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.singletonList(dimensionValue), Collections.emptyList(), Collections.emptyMap());
        this.setValidationEnabled(true);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), TIME_WITH_START_END, dimension, "startTime", "endTime"), request, dimension, dimensionValue, false);
    }

    @Test
    public void mismatchingTimeDimensionShouldValidateIfValidationDisabled() throws IOException {
        String dimension = "time";
        Date dimensionValue = Date.from(Instant.parse("2012-02-10T10:15:30.00Z"));
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.singletonList(dimensionValue), Collections.emptyList(), Collections.emptyMap());
        this.setValidationEnabled(false);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), TIME_WITH_START_END, dimension, "startTime", "endTime"), request, dimension, dimensionValue, true);
    }

    @Test
    public void matchingElevationDimensionShouldValidate() throws IOException {
        String dimension = "elevation";
        double dimensionValue = 2.0;
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.emptyList(), Collections.singletonList(dimensionValue), Collections.emptyMap());
        this.setValidationEnabled(true);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), ELEVATION_WITH_START_END, dimension, "startElevation", "endElevation"), request, dimension, dimensionValue, true);
    }

    @Test
    public void elevationQueryShouldHaveOneAttributeAndLimitMaxFeaturesToOne() throws IOException {
        String dimension = "elevation";
        double dimensionValue = 2.0;
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.emptyList(), Collections.singletonList(dimensionValue), Collections.emptyMap());
        WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), ELEVATION_WITH_START_END, dimension, "startElevation", "endElevation");
        this.assertQueryContent(ELEVATION_WITH_START_END, request, "startElevation");
    }

    @Test
    public void mismatchingElevationDimensionShouldNotValidate() throws IOException {
        String dimension = "elevation";
        double dimensionValue = 5.0;
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.emptyList(), Collections.singletonList(dimensionValue), Collections.emptyMap());
        this.setValidationEnabled(true);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), ELEVATION_WITH_START_END, dimension, "startElevation", "endElevation"), request, dimension, dimensionValue, false);
    }

    @Test
    public void mismatchingElevationDimensionShouldValidateIfValidationIsDisabled() throws IOException {
        String dimension = "elevation";
        double dimensionValue = 5.0;
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.emptyList(), Collections.singletonList(dimensionValue), Collections.emptyMap());
        this.setValidationEnabled(false);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), ELEVATION_WITH_START_END, dimension, "startElevation", "endElevation"), request, dimension, dimensionValue, true);
    }

    @Test
    public void matchingCustomTimeDimensionShouldValidate() throws IOException {
        String dimension = "dim_reference_time";
        Instant dimensionValue = Instant.parse("2012-02-11T10:15:30.00Z");
        HashMap<String, String> customDimensions = new HashMap<String, String>();
        customDimensions.put(dimension.toUpperCase(), DateTimeFormatter.ISO_INSTANT.format(dimensionValue));
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.emptyList(), Collections.emptyList(), customDimensions);
        this.setValidationEnabled(true);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), CUSTOM_DIM_WITH_START_END, dimension, "startTime", "endTime"), request, dimension, dimensionValue, true);
    }

    @Test
    public void mismatchingCustomTimeDimensionShouldNotValidate() throws IOException {
        String dimension = "dim_reference_time";
        Instant dimensionValue = Instant.parse("2012-02-10T10:15:30.00Z");
        HashMap<String, String> customDimensions = new HashMap<String, String>();
        customDimensions.put(dimension.toUpperCase(), DateTimeFormatter.ISO_INSTANT.format(dimensionValue));
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.emptyList(), Collections.emptyList(), customDimensions);
        this.setValidationEnabled(true);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), CUSTOM_DIM_WITH_START_END, dimension, "startTime", "endTime"), request, dimension, dimensionValue, false);
    }

    @Test
    public void mismatchingCustomTimeDimensionShouldValidateIfDisabled() throws IOException {
        String dimension = "dim_reference_time";
        Instant dimensionValue = Instant.parse("2012-02-10T10:15:30.00Z");
        HashMap<String, String> customDimensions = new HashMap<String, String>();
        customDimensions.put(dimension.toUpperCase(), DateTimeFormatter.ISO_INSTANT.format(dimensionValue));
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.emptyList(), Collections.emptyList(), customDimensions);
        this.setValidationEnabled(false);
        this.assertValidationSuccess(WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), CUSTOM_DIM_WITH_START_END, dimension, "startTime", "endTime"), request, dimension, dimensionValue, true);
    }

    @Test
    public void customDimensionQueryShouldHaveOneAttributeAndLimitMaxFeaturesToOne() throws IOException {
        String dimension = "dim_reference_time";
        Instant dimensionValue = Instant.parse("2012-02-11T10:15:30.00Z");
        HashMap<String, String> customDimensions = new HashMap<String, String>();
        customDimensions.put(dimension.toUpperCase(), DateTimeFormatter.ISO_INSTANT.format(dimensionValue));
        GetMapRequest request = WMSVectorDimensionValidationTest.mapRequest(Collections.emptyList(), Collections.emptyList(), customDimensions);
        WMSVectorDimensionValidationTest.setupStartEndDimension(this.getCatalog(), CUSTOM_DIM_WITH_START_END, dimension, "startTime", "endTime");
        this.assertQueryContent(CUSTOM_DIM_WITH_START_END, request, "startTime");
    }

    private void setValidationEnabled(boolean enabled) {
        WMSInfo wmsServiceInfo = this.wms.getServiceInfo();
        wmsServiceInfo.setExceptionOnInvalidDimension(Boolean.valueOf(enabled));
        this.wms.getGeoServer().save((ServiceInfo)wmsServiceInfo);
    }

    private void assertValidationSuccess(FeatureTypeInfo featureTypeInfo, GetMapRequest request, String dimension, Object dimensionValue, boolean shouldSucceed) throws IOException {
        block3: {
            try {
                this.wms.validateVectorDimensions(request.getTime(), request.getElevation(), featureTypeInfo, request);
                if (!shouldSucceed) {
                    Assert.fail((String)("A validation exception is expected for vector dimension '" + dimension + "' with value: " + dimensionValue));
                }
            }
            catch (ServiceException e) {
                if (!shouldSucceed) break block3;
                e.printStackTrace(System.err);
                Assert.fail((String)("Unexpected exception during validation of vector dimension '" + dimension + "' with value " + dimensionValue));
            }
        }
    }

    private void assertQueryContent(QName featureTypeName, GetMapRequest request, String queryAttribute) throws IOException {
        this.setValidationEnabled(true);
        FeatureTypeInfo featureTypeInfoSpy = (FeatureTypeInfo)Mockito.spy((Object)this.getCatalog().getFeatureTypeByName(featureTypeName.getLocalPart()));
        FeatureSource featureSource = (FeatureSource)Mockito.mock(FeatureSource.class);
        ((FeatureTypeInfo)Mockito.doReturn((Object)featureSource).when((Object)featureTypeInfoSpy)).getFeatureSource((ProgressListener)Mockito.any(), (Hints)Mockito.any());
        try {
            this.wms.validateVectorDimensions(request.getTime(), request.getElevation(), featureTypeInfoSpy, request);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        ((FeatureSource)Mockito.verify((Object)featureSource)).getFeatures((Query)this.queryArgumentCaptor.capture());
        Query query = (Query)this.queryArgumentCaptor.getValue();
        Assert.assertEquals((String)"The query should have the maxFeature attribute set to 1", (long)1L, (long)query.getMaxFeatures());
        Assert.assertEquals((String)"The query properties should have one entry only", (long)1L, (long)query.getProperties().size());
        Assert.assertEquals((String)("The query property should be for attribute: " + queryAttribute), (Object)queryAttribute, (Object)((PropertyName)query.getProperties().get(0)).getPropertyName());
    }

    private static FeatureTypeInfo setupStartEndDimension(Catalog catalog, QName featureTypeName, String dimension, String start, String end) {
        FeatureTypeInfo info = catalog.getFeatureTypeByName(featureTypeName.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute(start);
        di.setEndAttribute(end);
        di.setPresentation(DimensionPresentation.LIST);
        info.getMetadata().put(dimension, (Serializable)di);
        catalog.save((ResourceInfo)info);
        return info;
    }

    private static GetMapRequest mapRequest(List<Object> times, List<Object> elevations, Map<String, String> customDimensions) {
        GetMapRequest request = new GetMapRequest();
        request.setFormat("image/dummy");
        request.setWidth(512);
        request.setHeight(256);
        request.setBbox(new Envelope(-180.0, 180.0, -90.0, 90.0));
        request.setSRS("EPSG:4326");
        request.setCrs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        request.setRawKvp(new HashMap());
        request.setBaseUrl("http://example.geoserver.org/geoserver");
        if (times != null && !times.isEmpty()) {
            request.setTime(times);
        }
        if (elevations != null && !elevations.isEmpty()) {
            request.setElevation(elevations);
        }
        if (customDimensions != null && !customDimensions.isEmpty()) {
            request.getRawKvp().putAll(customDimensions);
        }
        return request;
    }
}

