/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class WMSDisabledTest
extends WMSTestSupport {
    @Test
    public void testDisabledServiceResponse() throws Exception {
        Logging.getLogger((String)"org.geoserver.ows").setLevel(Level.OFF);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setEnabled(false);
        this.getGeoServer().save((ServiceInfo)wms);
        Document doc = this.getAsDOM("wms?service=WMS&version=1.1.1&request=getCapabilities");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testEnabledServiceResponse() throws Exception {
        this.enableWMS();
        Document doc = this.getAsDOM("wms?service=WMS&version=1.1.1&request=getCapabilities");
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testLayerDisabledServiceResponse() throws Exception {
        this.enableWMS();
        String layerName = "cite:RoadSegments";
        FeatureTypeInfo ftinfo = this.getCatalog().getFeatureTypeByName(layerName);
        ftinfo.setServiceConfiguration(true);
        ftinfo.setDisabledServices(new ArrayList<String>(Arrays.asList("WMS")));
        this.getCatalog().save((ResourceInfo)ftinfo);
        Document doc = this.getAsDOM("wms?bbox=-180,-90,180,90&layers=" + layerName + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testLayerEnabledServiceResponse() throws Exception {
        this.enableWMS();
        String layerName = "cite:RoadSegments";
        FeatureTypeInfo ri = this.getCatalog().getFeatureTypeByName(layerName);
        ri.setServiceConfiguration(false);
        ri.setDisabledServices(new ArrayList());
        this.getCatalog().save((ResourceInfo)ri);
        BufferedImage image = this.getAsImage("wms?bbox=-180,-90,180,90&layers=" + layerName + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326", "image/png");
        Assert.assertNotNull((Object)image);
    }

    private void enableWMS() {
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setEnabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
    }
}

