/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapCallback;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.style.Style;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetMapCallbackTest
extends WMSDimensionsTestSupport {
    private GetMap getMap;

    @Before
    public void cleanupCallbacks() {
        this.getMap = (GetMap)applicationContext.getBean(GetMap.class);
        this.getMap.setGetMapCallbacks(Collections.emptyList());
    }

    @Test
    public void testStandardWorkflow() throws Exception {
        TestCallback callback = new TestCallback();
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        Document dom = this.getAsDOM("wms?request=reflect&layers=nature&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Lakes,cite:Forests']", (Document)dom);
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)1L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)2L, (long)callback.layers.size());
        Assert.assertEquals((long)1L, (long)callback.mapContents.size());
        Assert.assertEquals((long)1L, (long)callback.maps.size());
        Assert.assertEquals((long)0L, (long)callback.exceptions.size());
    }

    @Test
    public void testBreakRequest() throws Exception {
        String message = "This layer is not allowed";
        TestCallback callback = new TestCallback(){

            @Override
            public Layer beforeLayer(WMSMapContent content, Layer layer) {
                throw new RuntimeException("This layer is not allowed");
            }
        };
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        Document dom = this.getAsDOM("wms?request=reflect&layers=nature&format=rss&version=1.1.0");
        XMLAssert.assertXpathExists((String)"/ServiceExceptionReport", (Document)dom);
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)1L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)0L, (long)callback.layers.size());
        Assert.assertEquals((long)0L, (long)callback.mapContents.size());
        Assert.assertEquals((long)0L, (long)callback.maps.size());
        Assert.assertEquals((long)1L, (long)callback.exceptions.size());
        Assert.assertEquals((Object)"This layer is not allowed", (Object)callback.exceptions.get(0).getMessage());
    }

    @Test
    public void testAddLayer() throws Exception {
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BRIDGES));
        FeatureSource fs = ft.getFeatureSource(null, null);
        Style style = this.getCatalog().getStyleByName("point").getStyle();
        final FeatureLayer layer = new FeatureLayer(fs, style);
        layer.setTitle("extra");
        TestCallback callback = new TestCallback(){

            @Override
            public WMSMapContent beforeRender(WMSMapContent mapContent) {
                mapContent.addLayer((Layer)layer);
                return super.beforeRender(mapContent);
            }
        };
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        Document dom = this.getAsDOM("wms?request=reflect&layers=nature&format=rss&version=1.1.0");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Lakes,cite:Forests,extra']", (Document)dom);
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)1L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)3L, (long)callback.layers.size());
        Assert.assertEquals((long)1L, (long)callback.mapContents.size());
        Assert.assertEquals((long)1L, (long)callback.maps.size());
        Assert.assertEquals((long)0L, (long)callback.exceptions.size());
        Assert.assertEquals((Object)layer, (Object)callback.layers.get(2));
    }

    @Test
    public void testRemoveLayer() throws Exception {
        TestCallback callback = new TestCallback(){

            @Override
            public Layer beforeLayer(WMSMapContent content, Layer layer) {
                if ("cite:Lakes".equals(layer.getTitle())) {
                    return null;
                }
                return super.beforeLayer(content, layer);
            }
        };
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        Document dom = this.getAsDOM("wms?request=reflect&layers=nature&format=rss&version=1.1.0");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Forests']", (Document)dom);
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)1L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)1L, (long)callback.layers.size());
        Assert.assertEquals((long)1L, (long)callback.mapContents.size());
        Assert.assertEquals((long)1L, (long)callback.maps.size());
        Assert.assertEquals((long)0L, (long)callback.exceptions.size());
        Assert.assertEquals((Object)"cite:Forests", (Object)callback.layers.get(0).getTitle());
    }

    private class TestCallback
    implements GetMapCallback {
        private List<GetMapRequest> requests = new ArrayList<GetMapRequest>();
        private List<WMSMapContent> mapContentsInited = new ArrayList<WMSMapContent>();
        private List<Layer> layers = new ArrayList<Layer>();
        private List<WMSMapContent> mapContents = new ArrayList<WMSMapContent>();
        private List<WebMap> maps = new ArrayList<WebMap>();
        private List<Throwable> exceptions = new ArrayList<Throwable>();

        private TestCallback() {
        }

        public synchronized GetMapRequest initRequest(GetMapRequest request) {
            this.requests.add(request);
            return request;
        }

        public synchronized void initMapContent(WMSMapContent mapContent) {
            this.mapContentsInited.add(mapContent);
        }

        public synchronized Layer beforeLayer(WMSMapContent content, Layer layer) {
            this.layers.add(layer);
            return layer;
        }

        public synchronized WMSMapContent beforeRender(WMSMapContent mapContent) {
            this.mapContents.add(mapContent);
            return mapContent;
        }

        public synchronized WebMap finished(WebMap map) {
            this.maps.add(map);
            return map;
        }

        public synchronized void failed(Throwable t) {
            this.exceptions.add(t);
        }
    }
}

