/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.sld;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.sld.SLDXmlRequestReader;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class SLDXmlRequestReaderTest
extends WMSTestSupport {
    @Test
    public void testExtensionPoint() {
        List xmlReaders = GeoServerExtensions.extensions(XmlRequestReader.class);
        Optional<SLDXmlRequestReader> findExtension = xmlReaders.stream().filter(SLDXmlRequestReader.class::isInstance).map(SLDXmlRequestReader.class::cast).findFirst();
        Assert.assertTrue((boolean)findExtension.isPresent());
    }

    @Test
    public void testGetMapSld() throws Exception {
        String path = "/wms?service=WMS&version=1.1.0&request=GetMap&width=100&height=100&format=image/png&bbox=-180,-90,180,90";
        String body = "    <StyledLayerDescriptor version=\"1.0.0\">\n        <NamedLayer>\n            <Name>wcs:World</Name>\n            <NamedStyle><Name>generic</Name></NamedStyle>\n        </NamedLayer>\n    </StyledLayerDescriptor>\n";
        MockHttpServletResponse response = super.postAsServletResponse(path, body);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testGetMapSldXXE() throws Exception {
        String path = "/wms?service=WMS&version=1.1.0&request=GetMap&width=100&height=100&format=image/png&bbox=-180,-90,180,90";
        String body = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE StyledLayerDescriptor [\n<!ENTITY xxe SYSTEM \"file:///some/file\">]>\n<StyledLayerDescriptor version=\"1.0.0\">\n<NamedLayer><Name>&xxe;</Name></NamedLayer>\n</StyledLayerDescriptor>";
        Logging.getLogger((String)"geoserver.ows").setLevel(Level.OFF);
        MockHttpServletResponse response = super.postAsServletResponse(path, body);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        WMSTestSupport.assertContentType((String)"application/vnd.ogc.se_xml", (MockHttpServletResponse)response);
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed for file"));
    }
}

