/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.io.ImageIOExt;
import org.geotools.util.logging.Logging;

public final class TIFFMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(TIFFMapResponse.class);
    private static final ImageWriterSpi writerSPI = new TIFFImageWriterSpi();
    private static final String MIME_TYPE = "image/tiff";
    private static final String IMAGE_TIFF8 = "image/tiff8";
    private static final String[] OUTPUT_FORMATS = new String[]{"image/tiff", "image/tiff8"};
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(true, true, true);

    public TIFFMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatImageOutputStream(RenderedImage image, OutputStream outStream, WMSMapContent mapContent) throws ServiceException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a writer for tiff");
        }
        ImageWriter writer = writerSPI.createWriterInstance();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image ...");
        }
        image = this.applyPalette(image, mapContent, IMAGE_TIFF8, false);
        try (ImageOutputStream ioutstream = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)outStream);){
            if (ioutstream == null) {
                throw new ServiceException("Unable to create ImageOutputStream.");
            }
            writer.setOutput(ioutstream);
            writer.write(image);
        }
        finally {
            block18: {
                try {
                    writer.dispose();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block18;
                    LOGGER.log(Level.FINEST, "Unable to properly dispose writer", e);
                }
            }
            RasterCleaner.addImage(image);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image done!");
        }
    }

    @Override
    public MapProducerCapabilities getCapabilities(String outputFormat) {
        return CAPABILITIES;
    }

    @Override
    public String getExtension(RenderedImage image, WMSMapContent mapContent) {
        return "tif";
    }
}

