/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geoserver.wms.legendgraphic.ImageQueue;
import org.geoserver.wms.legendgraphic.Tally;

class ImageList
implements Iterable<BufferedImage> {
    private final List<BufferedImage> list = new ArrayList<BufferedImage>();
    private final Tally tally;

    public ImageList(Tally tally) {
        this.tally = tally;
    }

    public ImageList(Tally tally, ImageQueue legendsQueue) {
        this.tally = tally;
        this.list.addAll(legendsQueue.get());
    }

    public void add(BufferedImage image) {
        this.tally.addImage(image);
        this.list.add(image);
    }

    public int size() {
        return this.list.size();
    }

    public BufferedImage get(int index) {
        return this.list.get(index);
    }

    public Tally getTally() {
        return this.tally;
    }

    @Override
    public Iterator<BufferedImage> iterator() {
        return this.list.iterator();
    }
}

