/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension.impl;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.kvp.ElevationParser;
import org.geoserver.ows.kvp.TimeParser;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategy;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategyFactory;
import org.geoserver.wms.dimension.FixedValueStrategyFactory;
import org.geoserver.wms.dimension.NearestValueStrategyFactory;
import org.geotools.feature.type.DateUtil;

public class DimensionDefaultValueSelectionStrategyFactoryImpl
implements DimensionDefaultValueSelectionStrategyFactory {
    private DimensionDefaultValueSelectionStrategy featureTimeMinimumStrategy;
    private DimensionDefaultValueSelectionStrategy featureTimeMaximumStrategy;
    private DimensionDefaultValueSelectionStrategy coverageTimeMinimumStrategy;
    private DimensionDefaultValueSelectionStrategy coverageTimeMaximumStrategy;
    private DimensionDefaultValueSelectionStrategy featureElevationMinimumStrategy;
    private DimensionDefaultValueSelectionStrategy featureElevationMaximumStrategy;
    private DimensionDefaultValueSelectionStrategy coverageElevationMinimumStrategy;
    private DimensionDefaultValueSelectionStrategy coverageElevationMaximumStrategy;
    private DimensionDefaultValueSelectionStrategy featureCustomDimensionMinimumStrategy;
    private DimensionDefaultValueSelectionStrategy featureCustomDimensionMaximumStrategy;
    private DimensionDefaultValueSelectionStrategy coverageCustomDimensionMinimumStrategy;
    private DimensionDefaultValueSelectionStrategy coverageCustomDimensionMaximumStrategy;
    private NearestValueStrategyFactory featureNearestValueStrategyFactory;
    private NearestValueStrategyFactory coverageNearestValueStrategyFactory;
    private FixedValueStrategyFactory fixedValueStrategyFactory;
    private TimeParser timeParser = new TimeParser();
    private ElevationParser elevationParser = new ElevationParser();

    @Override
    public DimensionDefaultValueSelectionStrategy getStrategy(ResourceInfo resource, String dimensionName, DimensionInfo dimensionInfo) {
        DimensionDefaultValueSelectionStrategy retval = this.getStrategyFromSetting(resource, dimensionName, dimensionInfo);
        if (retval != null) {
            return retval;
        }
        if (dimensionName.equals("time")) {
            if (resource instanceof FeatureTypeInfo) {
                retval = this.featureNearestValueStrategyFactory.createNearestValueStrategy(new Date(), DimensionDefaultValueSetting.TIME_CURRENT);
            } else if (resource instanceof CoverageInfo) {
                retval = this.coverageNearestValueStrategyFactory.createNearestValueStrategy(new Date(), DimensionDefaultValueSetting.TIME_CURRENT);
            }
        } else if (dimensionName.equals("elevation")) {
            if (resource instanceof FeatureTypeInfo) {
                retval = this.featureElevationMinimumStrategy;
            } else if (resource instanceof CoverageInfo) {
                retval = this.coverageElevationMinimumStrategy;
            }
        } else if (dimensionName.startsWith("custom_dimension_") || dimensionName.startsWith("dim_")) {
            if (resource instanceof FeatureTypeInfo) {
                retval = this.featureCustomDimensionMinimumStrategy;
            } else if (resource instanceof CoverageInfo) {
                retval = this.coverageCustomDimensionMinimumStrategy;
            }
        }
        return retval;
    }

    public DimensionDefaultValueSelectionStrategy getFeatureTimeMinimumStrategy() {
        return this.featureTimeMinimumStrategy;
    }

    public void setFeatureTimeMinimumStrategy(DimensionDefaultValueSelectionStrategy featureTimeMinimumStrategy) {
        this.featureTimeMinimumStrategy = featureTimeMinimumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getFeatureTimeMaximumStrategy() {
        return this.featureTimeMaximumStrategy;
    }

    public void setFeatureTimeMaximumStrategy(DimensionDefaultValueSelectionStrategy featureTimeMaximumStrategy) {
        this.featureTimeMaximumStrategy = featureTimeMaximumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getCoverageTimeMinimumStrategy() {
        return this.coverageTimeMinimumStrategy;
    }

    public void setCoverageTimeMinimumStrategy(DimensionDefaultValueSelectionStrategy coverageTimeMinimumStrategy) {
        this.coverageTimeMinimumStrategy = coverageTimeMinimumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getCoverageTimeMaximumStrategy() {
        return this.coverageTimeMaximumStrategy;
    }

    public void setCoverageTimeMaximumStrategy(DimensionDefaultValueSelectionStrategy coverageTimeMaximumStrategy) {
        this.coverageTimeMaximumStrategy = coverageTimeMaximumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getFeatureElevationMinimumStrategy() {
        return this.featureElevationMinimumStrategy;
    }

    public void setFeatureElevationMinimumStrategy(DimensionDefaultValueSelectionStrategy featureElevationMinimumStrategy) {
        this.featureElevationMinimumStrategy = featureElevationMinimumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getFeatureElevationMaximumStrategy() {
        return this.featureElevationMaximumStrategy;
    }

    public void setFeatureElevationMaximumStrategy(DimensionDefaultValueSelectionStrategy featureElevationMaximumStrategy) {
        this.featureElevationMaximumStrategy = featureElevationMaximumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getCoverageElevationMinimumStrategy() {
        return this.coverageElevationMinimumStrategy;
    }

    public void setCoverageElevationMinimumStrategy(DimensionDefaultValueSelectionStrategy coverageElevationMinimumStrategy) {
        this.coverageElevationMinimumStrategy = coverageElevationMinimumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getCoverageElevationMaximumStrategy() {
        return this.coverageElevationMaximumStrategy;
    }

    public void setCoverageElevationMaximumStrategy(DimensionDefaultValueSelectionStrategy coverageElevationMaximumStrategy) {
        this.coverageElevationMaximumStrategy = coverageElevationMaximumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getFeatureCustomDimensionMinimumStrategy() {
        return this.featureCustomDimensionMinimumStrategy;
    }

    public void setFeatureCustomDimensionMinimumStrategy(DimensionDefaultValueSelectionStrategy featureCustomDimensionMinimumStrategy) {
        this.featureCustomDimensionMinimumStrategy = featureCustomDimensionMinimumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getFeatureCustomDimensionMaximumStrategy() {
        return this.featureCustomDimensionMaximumStrategy;
    }

    public void setFeatureCustomDimensionMaximumStrategy(DimensionDefaultValueSelectionStrategy featureCustomDimensionMaximumStrategy) {
        this.featureCustomDimensionMaximumStrategy = featureCustomDimensionMaximumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getCoverageCustomDimensionMinimumStrategy() {
        return this.coverageCustomDimensionMinimumStrategy;
    }

    public void setCoverageCustomDimensionMinimumStrategy(DimensionDefaultValueSelectionStrategy coverageCustomDimensionMinimumStrategy) {
        this.coverageCustomDimensionMinimumStrategy = coverageCustomDimensionMinimumStrategy;
    }

    public DimensionDefaultValueSelectionStrategy getCoverageCustomDimensionMaximumStrategy() {
        return this.coverageCustomDimensionMaximumStrategy;
    }

    public void setCoverageCustomDimensionMaximumStrategy(DimensionDefaultValueSelectionStrategy coverageCustomDimensionMaximumStrategy) {
        this.coverageCustomDimensionMaximumStrategy = coverageCustomDimensionMaximumStrategy;
    }

    public NearestValueStrategyFactory getFeatureNearestValueStrategyFactory() {
        return this.featureNearestValueStrategyFactory;
    }

    public void setFeatureNearestValueStrategyFactory(NearestValueStrategyFactory featureNearestValueStrategyFactory) {
        this.featureNearestValueStrategyFactory = featureNearestValueStrategyFactory;
    }

    public NearestValueStrategyFactory getCoverageNearestValueStrategyFactory() {
        return this.coverageNearestValueStrategyFactory;
    }

    public void setCoverageNearestValueStrategyFactory(NearestValueStrategyFactory coverageNearestValueStrategyFactory) {
        this.coverageNearestValueStrategyFactory = coverageNearestValueStrategyFactory;
    }

    public FixedValueStrategyFactory getFixedValueStrategyFactory() {
        return this.fixedValueStrategyFactory;
    }

    public void setFixedValueStrategyFactory(FixedValueStrategyFactory fixedValueStrategyFactory) {
        this.fixedValueStrategyFactory = fixedValueStrategyFactory;
    }

    private DimensionDefaultValueSelectionStrategy getStrategyFromSetting(ResourceInfo resource, String dimensionName, DimensionInfo dimensionInfo) {
        DimensionDefaultValueSelectionStrategy retval = null;
        DimensionDefaultValueSetting setting = dimensionInfo.getDefaultValue();
        if (setting != null && setting.getStrategyType() != null) {
            if (dimensionName.equals("time")) {
                retval = this.getDefaultTimeStrategy(resource, setting);
            } else if (dimensionName.equals("elevation")) {
                retval = this.getDefaultElevationStrategy(resource, setting);
            } else if (dimensionName.startsWith("custom_dimension_") || dimensionName.startsWith("dim_")) {
                retval = this.getDefaultCustomDimensionStrategy(resource, setting);
            }
        }
        return retval;
    }

    private DimensionDefaultValueSelectionStrategy getDefaultTimeStrategy(ResourceInfo resource, DimensionDefaultValueSetting setting) {
        DimensionDefaultValueSelectionStrategy retval = null;
        DimensionDefaultValueSetting.Strategy getStrategyType = setting.getStrategyType();
        switch (getStrategyType) {
            case NEAREST: {
                String capabilitiesValue = null;
                String referenceValue = setting.getReferenceValue();
                if (referenceValue != null) {
                    Date refDate;
                    if (referenceValue.equalsIgnoreCase(DimensionDefaultValueSetting.TIME_CURRENT)) {
                        refDate = new Date();
                        capabilitiesValue = DimensionDefaultValueSetting.TIME_CURRENT;
                    } else {
                        try {
                            refDate = new Date(DateUtil.parseDateTime((String)referenceValue));
                        }
                        catch (IllegalArgumentException e) {
                            throw new ServiceException("Unable to parse time dimension default value reference '" + referenceValue + "' as date, an ISO 8601 datetime format is expected", (Throwable)e);
                        }
                    }
                    if (resource instanceof FeatureTypeInfo) {
                        retval = this.featureNearestValueStrategyFactory.createNearestValueStrategy(refDate, capabilitiesValue);
                        break;
                    }
                    if (!(resource instanceof CoverageInfo)) break;
                    retval = this.coverageNearestValueStrategyFactory.createNearestValueStrategy(refDate, capabilitiesValue);
                    break;
                }
                throw new ServiceException("No reference value given for time dimension default value 'nearest' strategy");
            }
            case MINIMUM: {
                if (resource instanceof FeatureTypeInfo) {
                    retval = this.featureTimeMinimumStrategy;
                    break;
                }
                if (!(resource instanceof CoverageInfo)) break;
                retval = this.coverageTimeMinimumStrategy;
                break;
            }
            case MAXIMUM: {
                if (resource instanceof FeatureTypeInfo) {
                    retval = this.featureTimeMaximumStrategy;
                    break;
                }
                if (!(resource instanceof CoverageInfo)) break;
                retval = this.coverageTimeMaximumStrategy;
                break;
            }
            case FIXED: {
                String referenceValue = setting.getReferenceValue();
                if (referenceValue != null) {
                    Object refDate;
                    try {
                        refDate = this.singleValue(this.timeParser.parse(referenceValue), new Date());
                    }
                    catch (ParseException e) {
                        throw new ServiceException("Unable to parse time dimension default value reference '" + referenceValue + "' as date or a date range, an ISO 8601 datetime format is expected", (Throwable)e);
                    }
                    retval = this.fixedValueStrategyFactory.createFixedValueStrategy(refDate, referenceValue);
                    break;
                }
                throw new ServiceException("No reference value given for time dimension default value 'fixed' strategy");
            }
        }
        return retval;
    }

    private DimensionDefaultValueSelectionStrategy getDefaultElevationStrategy(ResourceInfo resource, DimensionDefaultValueSetting setting) {
        DimensionDefaultValueSelectionStrategy retval = null;
        switch (setting.getStrategyType()) {
            case NEAREST: {
                String referenceValue = setting.getReferenceValue();
                if (referenceValue != null) {
                    Number refNumber;
                    try {
                        refNumber = Long.parseLong(referenceValue);
                    }
                    catch (NumberFormatException fne) {
                        try {
                            refNumber = Double.parseDouble(referenceValue);
                        }
                        catch (NumberFormatException e) {
                            throw new ServiceException("Unable to parse elevation dimension default value reference '" + referenceValue + "' as long or double", (Throwable)e);
                        }
                    }
                    if (resource instanceof FeatureTypeInfo) {
                        retval = this.featureNearestValueStrategyFactory.createNearestValueStrategy(refNumber);
                        break;
                    }
                    if (!(resource instanceof CoverageInfo)) break;
                    retval = this.coverageNearestValueStrategyFactory.createNearestValueStrategy(refNumber);
                    break;
                }
                throw new ServiceException("No reference value given for elevation dimension default value 'nearest' strategy");
            }
            case MINIMUM: {
                if (resource instanceof FeatureTypeInfo) {
                    retval = this.featureElevationMinimumStrategy;
                    break;
                }
                if (!(resource instanceof CoverageInfo)) break;
                retval = this.coverageElevationMinimumStrategy;
                break;
            }
            case MAXIMUM: {
                if (resource instanceof FeatureTypeInfo) {
                    retval = this.featureElevationMaximumStrategy;
                    break;
                }
                if (!(resource instanceof CoverageInfo)) break;
                retval = this.coverageElevationMaximumStrategy;
                break;
            }
            case FIXED: {
                Object refNumber;
                String referenceValue = setting.getReferenceValue();
                if (referenceValue != null) {
                    try {
                        refNumber = this.singleValue(this.elevationParser.parse(referenceValue), new Date());
                    }
                    catch (ParseException e) {
                        throw new ServiceException("Unable to parse elevation dimension default value reference '" + referenceValue + "' as long or double", (Throwable)e);
                    }
                } else {
                    throw new ServiceException("No reference value given for elevation dimension default value 'fixed' strategy");
                }
                retval = this.fixedValueStrategyFactory.createFixedValueStrategy(refNumber, referenceValue);
                break;
            }
        }
        return retval;
    }

    private Object singleValue(Collection parsed, Object defaultValue) {
        Object result = null;
        if (parsed.size() == 1) {
            result = parsed.iterator().next();
        } else if (parsed.size() > 1) {
            throw new IllegalArgumentException("Dimension reference value must be a single value or range");
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DimensionDefaultValueSelectionStrategy getDefaultCustomDimensionStrategy(ResourceInfo resource, DimensionDefaultValueSetting setting) {
        DimensionDefaultValueSelectionStrategy retval = null;
        String referenceValue = null;
        switch (setting.getStrategyType()) {
            case NEAREST: {
                Object refValue;
                referenceValue = setting.getReferenceValue();
                if (referenceValue == null) throw new ServiceException("No reference value given for custom dimension default value 'nearest' strategy");
                try {
                    refValue = new Date(DateUtil.parseDateTime((String)referenceValue));
                }
                catch (IllegalArgumentException e) {
                    try {
                        refValue = Long.parseLong(referenceValue);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            refValue = Double.parseDouble(referenceValue);
                        }
                        catch (NumberFormatException nfe2) {
                            refValue = referenceValue;
                        }
                    }
                }
                if (resource instanceof FeatureTypeInfo) {
                    return this.featureNearestValueStrategyFactory.createNearestValueStrategy(refValue);
                }
                if (!(resource instanceof CoverageInfo)) return retval;
                return this.coverageNearestValueStrategyFactory.createNearestValueStrategy(refValue);
            }
            case MINIMUM: {
                if (resource instanceof FeatureTypeInfo) {
                    return this.featureCustomDimensionMinimumStrategy;
                }
                if (!(resource instanceof CoverageInfo)) return retval;
                return this.coverageCustomDimensionMinimumStrategy;
            }
            case MAXIMUM: {
                if (resource instanceof FeatureTypeInfo) {
                    return this.featureCustomDimensionMaximumStrategy;
                }
                if (!(resource instanceof CoverageInfo)) return retval;
                return this.coverageCustomDimensionMaximumStrategy;
            }
            case FIXED: {
                Object refValue;
                referenceValue = setting.getReferenceValue();
                if (referenceValue == null) throw new ServiceException("No reference value given for custom dimension default value 'fixed' strategy");
                try {
                    refValue = new Date(DateUtil.parseDateTime((String)referenceValue));
                    return this.fixedValueStrategyFactory.createFixedValueStrategy(refValue);
                }
                catch (IllegalArgumentException e) {
                    try {
                        refValue = Long.parseLong(referenceValue);
                        return this.fixedValueStrategyFactory.createFixedValueStrategy(refValue);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            refValue = Double.parseDouble(referenceValue);
                            return this.fixedValueStrategyFactory.createFixedValueStrategy(refValue);
                        }
                        catch (NumberFormatException nfe2) {
                            refValue = referenceValue;
                        }
                    }
                }
                return this.fixedValueStrategyFactory.createFixedValueStrategy(refValue);
            }
        }
        return retval;
    }
}

