/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.DimensionFilterBuilder;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategy;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.util.Converters;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;

class CustomDimensionFilterConverter {
    private static final Logger LOGGER = Logging.getLogger(CustomDimensionFilterConverter.class);
    private final FeatureTypeInfo typeInfo;
    private final DefaultValueStrategyFactory defaultValueStrategyFactory;
    private final Map<String, DimensionInfo> customDimensions;
    private static Collection<ValueConverter> converters;

    CustomDimensionFilterConverter(FeatureTypeInfo typeInfo, DefaultValueStrategyFactory defaultValueStrategyFactory) {
        this.defaultValueStrategyFactory = defaultValueStrategyFactory;
        this.typeInfo = typeInfo;
        this.customDimensions = this.getCustomDimensions();
    }

    public Filter getDimensionsToFilter(Map<String, String> rawKVP, DimensionFilterBuilder filterBuilder) {
        for (Map.Entry<String, DimensionInfo> entry : this.customDimensions.entrySet()) {
            String dimensionName = entry.getKey();
            DimensionInfo dimension = entry.getValue();
            this.buildDimensionFilter(rawKVP, filterBuilder, dimensionName, dimension);
        }
        return filterBuilder.getFilter();
    }

    public void buildDimensionFilter(Map<String, String> rawKVP, DimensionFilterBuilder filterBuilder, String dimensionName, DimensionInfo dimension) {
        try {
            String attributeName = dimension.getAttribute();
            PropertyDescriptor descriptor = this.typeInfo.getFeatureType().getDescriptor(attributeName);
            if (descriptor == null) {
                throw new IllegalArgumentException("Attribute Name '" + attributeName + "' not found.");
            }
            Class binding = descriptor.getType().getBinding();
            if (StringUtils.isBlank((CharSequence)attributeName)) {
                LOGGER.severe("Required attribute name is empty for dimension='" + dimensionName + "'");
                return;
            }
            String endAttributeName = dimension.getEndAttribute();
            String rawValue = rawKVP.get(("dim_" + dimensionName).toUpperCase());
            List<Object> convertedValues = this.convertValues(rawValue, binding, () -> this.getDefaultCustomDimension(this.rollDimPrefix(dimensionName), binding));
            filterBuilder.appendFilters(attributeName, endAttributeName, convertedValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, DimensionInfo> getCustomDimensions() {
        MetadataMap metadataMap = this.typeInfo.getMetadata();
        return metadataMap.entrySet().stream().filter(e -> e.getValue() instanceof DimensionInfo && ((String)e.getKey()).startsWith("dim_")).filter(e -> ((DimensionInfo)e.getValue()).isEnabled()).collect(Collectors.toMap(e -> this.unrollDimPrefix((String)e.getKey()), e -> (DimensionInfo)e.getValue()));
    }

    private List<Object> convertValues(String rawValue, Class<?> binding, Supplier<Object> defaultSupplier) {
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return Arrays.asList(defaultSupplier.get());
        }
        return this.convertValues(this.splitStringValue(rawValue), binding);
    }

    private String unrollDimPrefix(String key) {
        return key.replaceFirst("dim_", "");
    }

    private String rollDimPrefix(String name) {
        return "dim_" + name;
    }

    private List<String> splitStringValue(String value) {
        String[] strings = value.split(",");
        return Arrays.asList(strings);
    }

    private Object getDefaultCustomDimension(String name, Class<?> binding) {
        DimensionInfo dimensionInfo = this.customDimensions.get(this.unrollDimPrefix(name));
        if (dimensionInfo == null || !dimensionInfo.isEnabled()) {
            throw new ServiceException("Layer " + this.typeInfo.prefixedName() + " does not have custom dimension support enabled");
        }
        DimensionDefaultValueSelectionStrategy strategy = this.defaultValueStrategyFactory.getDefaultValueStrategy((ResourceInfo)this.typeInfo, name, dimensionInfo);
        return strategy.getDefaultValue((ResourceInfo)this.typeInfo, name, dimensionInfo, binding);
    }

    private List<Object> convertValues(List<String> rawValues, Class<?> binding) {
        Collection<ValueConverter> valueConverters = CustomDimensionFilterConverter.valueConverters();
        Optional<ValueConverter> converter = valueConverters.stream().filter(c -> c.canProcess(binding)).findFirst();
        if (converter.isPresent()) {
            return converter.get().convert(rawValues, binding);
        }
        throw new ServiceException("Binding unsuported: " + binding);
    }

    static Collection<ValueConverter> valueConverters() {
        if (converters != null) {
            return converters;
        }
        return CustomDimensionFilterConverter.initValueConverters();
    }

    static synchronized Collection<ValueConverter> initValueConverters() {
        if (converters == null) {
            converters = Arrays.asList(new NumberConverter(), new StringConverter(), new BooleanConverter(), new DateConverter());
        }
        return converters;
    }

    static class DateConverter
    extends ValueConverterImpl {
        DateConverter() {
        }

        @Override
        public boolean canProcess(Class<?> binding) {
            return Date.class.isAssignableFrom(binding);
        }

        @Override
        public List<Object> convert(List<String> rawValues, Class<?> binding) {
            Optional<String> rangeValue = this.getRangeValue(rawValues = this.cleanBlankValues(rawValues));
            if (rangeValue.isPresent()) {
                List rangeValues = this.splitRangeValues(rangeValue.get()).stream().map(v -> Converters.convert((Object)v, (Class)binding)).collect(Collectors.toList());
                Range range = new Range(binding, (Comparable)rangeValues.get(0), (Comparable)rangeValues.get(1));
                return Arrays.asList(range);
            }
            return rawValues.stream().map(v -> Converters.convert((Object)v, (Class)binding)).filter(v -> v != null).collect(Collectors.toList());
        }
    }

    static class BooleanConverter
    extends ValueConverterImpl {
        BooleanConverter() {
        }

        @Override
        public boolean canProcess(Class<?> binding) {
            return Boolean.class.isAssignableFrom(binding);
        }

        @Override
        public List<Object> convert(List<String> rawValues, Class<?> binding) {
            rawValues = this.cleanBlankValues(rawValues);
            return rawValues.stream().filter(v -> !this.isRange((String)v) && this.isValidBoolean((String)v)).map(v -> (Boolean)Converters.convert((Object)v.trim(), Boolean.class)).collect(Collectors.toList());
        }

        private boolean isValidBoolean(String value) {
            if (value == null) {
                return false;
            }
            return (value = value.trim().toLowerCase()).equals("true") || value.equals("false");
        }
    }

    static class StringConverter
    extends ValueConverterImpl {
        StringConverter() {
        }

        @Override
        public boolean canProcess(Class<?> binding) {
            return String.class.isAssignableFrom(binding);
        }

        @Override
        public List<Object> convert(List<String> rawValues, Class<?> binding) {
            rawValues = this.cleanBlankValues(rawValues);
            return rawValues;
        }
    }

    static class NumberConverter
    extends ValueConverterImpl {
        NumberConverter() {
        }

        @Override
        public boolean canProcess(Class<?> binding) {
            return Number.class.isAssignableFrom(binding);
        }

        @Override
        public List<Object> convert(List<String> rawValues, Class<?> binding) {
            Optional<String> rangeValue = this.getRangeValue(rawValues = this.cleanBlankValues(rawValues));
            if (rangeValue.isPresent()) {
                List rangeValues = this.splitRangeValues(rangeValue.get()).stream().map(v -> Converters.convert((Object)v, (Class)binding)).collect(Collectors.toList());
                Range range = new Range(binding, (Comparable)rangeValues.get(0), (Comparable)rangeValues.get(1));
                return Arrays.asList(range);
            }
            return rawValues.stream().map(v -> Converters.convert((Object)v, (Class)binding)).filter(v -> v != null).collect(Collectors.toList());
        }
    }

    static abstract class ValueConverterImpl
    implements ValueConverter {
        ValueConverterImpl() {
        }

        protected boolean isRange(String value) {
            return value.contains("/");
        }

        protected Optional<String> getRangeValue(List<String> values) {
            return values.stream().filter(v -> this.isRange((String)v)).findFirst();
        }

        protected Collection<String> splitRangeValues(String values) {
            return Arrays.asList(values.split(Pattern.quote("/")));
        }

        protected List<String> cleanBlankValues(List<String> values) {
            return values.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.toList());
        }
    }

    static interface ValueConverter {
        public boolean canProcess(Class<?> var1);

        public List<Object> convert(List<String> var1, Class<?> var2);
    }

    static interface DefaultValueStrategyFactory {
        public DimensionDefaultValueSelectionStrategy getDefaultValueStrategy(ResourceInfo var1, String var2, DimensionInfo var3);
    }
}

