/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.junit.Test;

public class DimensionsVectorGetMap_1_3Test
extends WMSDimensionsTestSupport {
    @Test
    public void testCustomDimensionNumber() throws Exception {
        this.setupVectorDimension("dim_custom", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.3.0&request=GetMap&bbox=-90,-180,90,180&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=1.0", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionNumberRange() throws Exception {
        this.setupVectorDimension("dim_custom", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.3.0&request=GetMap&bbox=-90,-180,90,180&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=0.5/1.5", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionString() throws Exception {
        this.setupVectorDimension("dim_custom", "shared_key", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.3.0&request=GetMap&bbox=-90,-180,90,180&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=str1", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionBoolean() throws Exception {
        this.setupVectorDimension("dim_custom", "enabled", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.3.0&request=GetMap&bbox=-90,-180,90,180&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=true", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionDate() throws Exception {
        this.setupVectorDimension("dim_custom", "time", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.3.0&request=GetMap&bbox=-90,-180,90,180&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=2011-05-02", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionDateRange() throws Exception {
        this.setupVectorDimension("dim_custom", "time", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.3.0&request=GetMap&bbox=-90,-180,90,180&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=2011-05-01T20:00:00Z/2011-05-02T05:00:00Z", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }
}

