/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geoserver.wms.WMSInfo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class DimensionsVectorGetMapTest
extends WMSDimensionsTestSupport {
    @Test
    public void testNoDimension() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION), "image/png");
        this.assertPixel(image, 20, 10, Color.BLACK);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.BLACK);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testElevationDefault() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION), "image/png");
        this.assertPixel(image, 20, 10, Color.BLACK);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testElevationInvalid() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.getAsDOM("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&elevation=-10");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "elevation");
        Assert.assertEquals((Object)"Could not find a match for 'elevation' value: '-10'", (Object)message.trim());
    }

    @Test
    public void testElevationSingle() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&elevation=1.0", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testElevationListMulti() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&elevation=1.0,3.0", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testElevationListExtra() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&elevation=1.0,3.0,5.0", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testElevationInterval() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&elevation=1.0/3.0", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.BLACK);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testElevationIntervalResolution() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&elevation=0.0/4.0/2.0", "image/png");
        this.assertPixel(image, 20, 10, Color.BLACK);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.BLACK);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testElevationIntervalResolutionTooManyDefault() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&elevation=0.0/4.0/0.01");
        Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)this.getBaseMimeType(response.getContentType()));
        Document dom = this.dom(response, true);
        String text = this.checkLegacyException(dom, "InvalidParameterValue", "elevation");
        MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 100 elevations"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testElevationIntervalResolutionTooManyCustom() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.setMaxRequestedDimensionValues(2);
        gs.save((ServiceInfo)wms);
        try {
            this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
            MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&elevation=0.0/4.0/0.01");
            Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)this.getBaseMimeType(response.getContentType()));
            Document dom = this.dom(response, true);
            String text = this.checkLegacyException(dom, "InvalidParameterValue", "elevation");
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 2 elevations"));
        }
        finally {
            wms.setMaxRequestedDimensionValues(100);
            gs.save((ServiceInfo)wms);
        }
    }

    @Test
    public void testTimeDefault() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION), "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testTimeCurrent() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=CURRENT", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testTimeCurrentForEmptyLayer() throws Exception {
        this.setupVectorDimension("TimeElevationEmpty", "time", "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(false);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION_EMPTY) + "&time=CURRENT", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testTimeCurrentForEmptyLayerException() throws Exception {
        this.setupVectorDimension("TimeElevationEmpty", "time", "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION_EMPTY) + "&time=CURRENT");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
        Assert.assertEquals((Object)"Could not find a match for 'time' value: 'CURRENT'", (Object)message.trim());
    }

    @Test
    public void testTimeSingle() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-02", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testTimeSingleNoNearestEmptyResult() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setExceptionsOnInvalidDimension(false);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-02T01:00:00Z", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testTimeSingleNoNearestException() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-02T01:00:00Z");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
        Assert.assertEquals((Object)"Could not find a match for 'time' value: '2011-05-02T01:00:00Z'", (Object)message.trim());
    }

    @Test
    public void testTimeSingleNearestClose() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-02T01:00:00Z", "image/png");
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-02T00:00:00.000Z");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testTimeSingleNearestAcceptableRange() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        String baseURL = "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true, "P1D");
        this.getAsImage(baseURL + "&time=2011-05-02T01:00:00Z", "image/png");
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-02T00:00:00.000Z");
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true, "PT1M");
        this.getAsImage(baseURL + "&time=2011-05-02T01:00:00Z", "image/png");
        this.assertWarningCount(1);
        this.assertNoNearestWarning(this.getLayerId(this.V_TIME_ELEVATION), "time");
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true, "PT1M", DimensionInfo.NearestFailBehavior.EXCEPTION, false);
        Document dom = this.getAsDOM(baseURL + "&time=2011-05-02T01:00:00Z");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"No nearest match found on sf:TimeElevation for time dimension"));
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true, "PT0M/P1D");
        this.getAsImage(baseURL + "&time=2011-05-02T01:00:00Z", "image/png");
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-03T00:00:00.000Z");
    }

    @Test
    public void testTimeSingleNearestAfter() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2013-05-02", "image/png");
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-04T00:00:00.000Z");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testTimeSingleNearestBefore() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=1990-05-02", "image/png");
        this.assertWarningCount(1);
        this.assertNearestTimeWarning(this.getLayerId(this.V_TIME_ELEVATION), "2011-05-01T00:00:00.000Z");
        this.assertPixel(image, 20, 10, Color.BLACK);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testTimeListMulti() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-02,2011-05-04", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testTimeListExtra() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, "ISO8601", null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-02,2011-05-04,2011-05-10", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testTimeInterval() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-02/2011-05-05", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.BLACK);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testTimeIntervalResolution() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-01/2011-05-04/P2D", "image/png");
        this.assertPixel(image, 20, 10, Color.BLACK);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.BLACK);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testTimeIntervalResolutionTooManyDefault() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-01/2011-06-01/PT1H");
        Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)this.getBaseMimeType(response.getContentType()));
        Document dom = this.dom(response, true);
        String text = this.checkLegacyException(dom, "InvalidParameterValue", "time");
        MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 100 times"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeIntervalResolutionTooManyCustom() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.setMaxRequestedDimensionValues(2);
        gs.save((ServiceInfo)wms);
        try {
            this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
            MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-01/2011-05-04/P1D", "image/png");
            Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)this.getBaseMimeType(response.getContentType()));
            Document dom = this.dom(response, true);
            String text = this.checkLegacyException(dom, "InvalidParameterValue", "time");
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"More than 2 times"));
        }
        finally {
            wms.setMaxRequestedDimensionValues(100);
            gs.save((ServiceInfo)wms);
        }
    }

    @Test
    public void testElevationDefaultAsRange() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("1/3");
        this.setupResourceDimensionDefaultValue(this.V_TIME_ELEVATION, "elevation", defaultValueSetting, "elevation");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION), "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.BLACK);
        this.assertPixel(image, 60, 30, Color.BLACK);
    }

    @Test
    public void testTimeDefaultAsRange() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("2011-05-02/2011-05-03");
        this.setupResourceDimensionDefaultValue(this.V_TIME_ELEVATION, "time", defaultValueSetting, "time");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION), "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.BLACK);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testSortAllAscending() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION_STACKED) + "&sortBy=time, elevation", "image/png");
        this.assertPixel(image, 20, 10, Color.BLUE);
    }

    @Test
    public void testSortTimeAElevationD() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION_STACKED) + "&sortBy=time, elevation D", "image/png");
        this.assertPixel(image, 20, 10, Color.GREEN);
    }

    @Test
    public void testSortTimeDElevationA() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION_STACKED) + "&sortBy=time D, elevation", "image/png");
        this.assertPixel(image, 20, 10, Color.RED);
    }

    @Test
    public void testSortDescending() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION_STACKED) + "&sortBy=time D,elevation D", "image/png");
        this.assertPixel(image, 20, 10, Color.BLACK);
    }

    @Test
    public void testSortInvalidAttribute() throws Exception {
        Document dom = this.getAsDOM("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION_STACKED) + "&sortBy=foo");
        XpathEngine xp = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)xp.evaluate("/ServiceExceptionReport/ServiceException/@code", dom));
        Assert.assertEquals((Object)"sortBy", (Object)xp.evaluate("/ServiceExceptionReport/ServiceException/@locator", dom));
        MatcherAssert.assertThat((Object)xp.evaluate("/ServiceExceptionReport/ServiceException", dom), (Matcher)CoreMatchers.containsString((String)"'foo'"));
    }

    @Test
    public void testSortDescendingMultiLayer() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(SystemTestData.LAKES) + "," + this.getLayerId(this.V_TIME_ELEVATION_STACKED) + "&sortBy=()(time D,elevation D)", "image/png");
        this.assertPixel(image, 20, 10, Color.BLACK);
    }

    @Test
    public void testCustomDimension() throws Exception {
        this.setupVectorDimension("dim_custom", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=1.0", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionRange() throws Exception {
        this.setupVectorDimension("dim_custom", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=0.5/1.5", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionString() throws Exception {
        this.setupVectorDimension("dim_custom", "shared_key", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=str1", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionStringInvalidException() throws Exception {
        this.setupVectorDimension("dim_custom", "shared_key", DimensionPresentation.LIST, null, "foot", "ft");
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=IAmNotThere");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "DIM_CUSTOM");
        Assert.assertEquals((Object)"Could not find a match for 'custom' value: 'IAmNotThere'", (Object)message.trim());
    }

    @Test
    public void testCustomDimensionStringInvalidIgnore() throws Exception {
        this.setupVectorDimension("dim_custom", "shared_key", DimensionPresentation.LIST, null, "foot", "ft");
        this.setExceptionsOnInvalidDimension(false);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=IAmNotThere", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.WHITE);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionBoolean() throws Exception {
        this.setupVectorDimension("dim_custom", "enabled", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=true", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionDate() throws Exception {
        this.setupVectorDimension("dim_custom", "time", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=2011-05-02", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }

    @Test
    public void testCustomDimensionDateRange() throws Exception {
        this.setupVectorDimension("dim_custom", "time", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&dim_custom=2011-05-01T20:00:00Z/2011-05-02T05:00:00Z", "image/png");
        this.assertPixel(image, 20, 10, Color.WHITE);
        this.assertPixel(image, 60, 10, Color.BLACK);
        this.assertPixel(image, 20, 30, Color.WHITE);
        this.assertPixel(image, 60, 30, Color.WHITE);
    }
}

