/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.kvp.TimeParser;
import org.geoserver.util.NearestMatchFinder;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class DimensionsRasterGetMapTest
extends WMSDimensionsTestSupport {
    static final String BASE_URL = "wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326";
    static final String BASE_PNG_URL = "wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png";
    static final String MIME = "image/png";

    @Test
    public void testNoDimension() throws Exception {
        BufferedImage image = this.getAsImage(BASE_PNG_URL, MIME);
        this.assertNotBlank("water temperature", image);
    }

    @Test
    public void testDefaultValues() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage(BASE_PNG_URL, MIME);
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 187, 187));
    }

    @Test
    public void testSortTimeDescending() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&sortBy=ingestion D", MIME);
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 187, 187));
    }

    @Test
    public void testSortTwoAttributes() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&sortBy=ingestion D,elevation", MIME);
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 187, 187));
    }

    @Test
    public void testElevation() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&elevation=100", MIME);
        this.assertPixel(image, 36, 31, new Color(255, 255, 255));
        this.assertPixel(image, 68, 72, new Color(246, 246, 255));
    }

    @Test
    public void testElevationInvalidIgnore() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(false);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&elevation=-100", MIME);
        this.assertPixel(image, 36, 31, Color.WHITE);
        this.assertPixel(image, 68, 72, Color.WHITE);
    }

    @Test
    public void testElevationInvalidException() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&elevation=-100");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "elevation");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Could not find a match for 'elevation' value: '-100'"));
    }

    @Test
    public void testSortElevationDescending() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(WATTEMP));
        ci.getParameters().put(ImageMosaicFormat.MAX_ALLOWED_TILES.getName().getCode(), "1");
        this.getCatalog().save((ResourceInfo)ci);
        try {
            BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&bgcolor=0xFF0000&sortBy=elevation D,ingestion D", MIME);
            this.assertPixel(image, 36, 31, new Color(255, 0, 0));
            this.assertPixel(image, 68, 72, new Color(246, 246, 255));
        }
        finally {
            ci = this.getCatalog().getCoverageByName(this.getLayerId(WATTEMP));
            ci.getParameters().remove(ImageMosaicFormat.MAX_ALLOWED_TILES.getName().getCode());
            this.getCatalog().save((ResourceInfo)ci);
        }
    }

    @Test
    public void testTime() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T00:00:00.000Z", MIME);
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 181, 181));
    }

    @Test
    public void testTimeNoNearestCloseIgnore() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(false);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T08:00:00.000Z", MIME);
        this.assertPixel(image, 36, 31, Color.WHITE);
        this.assertPixel(image, 68, 72, Color.WHITE);
    }

    @Test
    public void testTimeNoNearestCloseException() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T08:00:00.000Z");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Could not find a match for 'time' value: '2008-10-31T08:00:00.000Z'"));
    }

    @Test
    public void testTimeNearestClose() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T08:00:00.000Z", MIME);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-10-31T00:00:00.000Z");
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 181, 181));
    }

    @Test
    public void testTimeNearestCloseNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeNearestClose();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeNearestAcceptableRange() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true, "P1D");
        this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T08:00:00.000Z", MIME);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-10-31T00:00:00.000Z");
        this.setupNearestMatch(WATTEMP, "time", true, "PT4H/P0D");
        this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T08:00:00.000Z", MIME);
        this.assertNoNearestWarning(this.getLayerId(WATTEMP), "time");
        this.setupNearestMatch(WATTEMP, "time", true, "PT4H/P0D", DimensionInfo.NearestFailBehavior.EXCEPTION, false);
        Document dom = this.getAsDOM("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T08:00:00.000Z");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"No nearest match found on sf:watertemp for time dimension"));
        this.setupNearestMatch(WATTEMP, "time", true, "P0D/P10D");
        this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T08:00:00.000Z", MIME);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-11-01T00:00:00.000Z");
    }

    @Test
    public void testTimeNearestAcceptableRangeNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeNearestAcceptableRange();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeNearestBefore() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=1990-10-31", MIME);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-10-31T00:00:00.000Z");
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 181, 181));
    }

    @Test
    public void testTimeNearestBeforeNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeNearestBefore();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeNearestAfter() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2009-10-31", MIME);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-11-01T00:00:00.000Z");
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 187, 187));
    }

    @Test
    public void testTimeNearestAfterNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeNearestAfter();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeTwice() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T00:00:00.000Z", MIME);
        this.assertPixel(image, 36, 31, new Color(246, 246, 255));
        this.assertPixel(image, 68, 72, new Color(255, 181, 181));
    }

    @Test
    public void testTimeElevation() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T00:00:00.000Z&elevation=100&bgcolor=0xFF0000", MIME);
        this.assertPixel(image, 36, 31, new Color(255, 0, 0));
        this.assertPixel(image, 68, 72, new Color(240, 240, 255));
    }

    @Test
    public void testTimeRange() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(TIMERANGES, "wavelength", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "date", DimensionPresentation.LIST, null, null, null);
        String baseUrl = "wms?LAYERS=" + this.getLayerId(TIMERANGES) + "&STYLES=temperature&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=-0.89131513678082,40.246933882167,15.721292974683,44.873229811941&WIDTH=200&HEIGHT=80&bgcolor=0x0000FF";
        BufferedImage image = this.getAsImage(baseUrl + "&TIME=2008-11-05T00:00:00.000Z/2008-11-06T12:00:00.000Z", MIME);
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, new Color(249, 249, 255));
        this.setExceptionsOnInvalidDimension(false);
        image = this.getAsImage(baseUrl + "&TIME=2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z", MIME);
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, Color.BLUE);
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM(baseUrl + "&TIME=2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Could not find a match for 'time' value: '2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z'"));
        image = this.getAsImage(baseUrl + "&TIME=2008-10-31T12:00:00.000Z/2008-10-31T16:00:00.000Z", MIME);
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, new Color(255, 172, 172));
    }

    @Test
    public void testTimeRangeNearestMatch() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(TIMERANGES, "wavelength", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "date", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(TIMERANGES, "time", true);
        String timeRangesId = this.getLayerId(TIMERANGES);
        String baseUrl = "wms?LAYERS=" + timeRangesId + "&STYLES=temperature&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=-0.89131513678082,40.246933882167,15.721292974683,44.873229811941&WIDTH=200&HEIGHT=80&bgcolor=0x0000FF";
        BufferedImage image = this.getAsImage(baseUrl + "&TIME=2018-11-8/2018-11-09", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-07T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, new Color(249, 249, 255));
        image = this.getAsImage(baseUrl + "&TIME=20018-11-05", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-07T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, new Color(249, 249, 255));
        image = this.getAsImage(baseUrl + "&TIME=2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-05T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, new Color(249, 249, 255));
        image = this.getAsImage(baseUrl + "&TIME=2008-11-04T16:00:00.000Z", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-05T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, new Color(249, 249, 255));
        image = this.getAsImage(baseUrl + "&TIME=2000-10-31/2000-10-31", MIME);
        this.assertNearestTimeWarning(timeRangesId, "2008-10-31T00:00:00.000Z");
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, new Color(255, 172, 172));
        image = this.getAsImage(baseUrl + "&TIME=2000-10-31", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-10-31T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertPixel(image, 36, 31, Color.BLUE);
        this.assertPixel(image, 68, 72, new Color(255, 172, 172));
    }

    @Test
    public void testTimeRangeNearestMatchNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeRangeNearestMatch();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeRangeNearestMatchAcceptableRange() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(TIMERANGES, "wavelength", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "date", DimensionPresentation.LIST, null, null, null);
        String timeRangesId = this.getLayerId(TIMERANGES);
        String baseUrl = "wms?LAYERS=" + timeRangesId + "&STYLES=temperature&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=-0.89131513678082,40.246933882167,15.721292974683,44.873229811941&WIDTH=200&HEIGHT=80&bgcolor=0x0000FF";
        this.setupNearestMatch(TIMERANGES, "time", true, "P100Y");
        this.getAsImage(baseUrl + "&TIME=2018-11-8/2018-11-09", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-07T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.getAsImage(baseUrl + "&TIME=2018-11-05", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-07T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.setupNearestMatch(TIMERANGES, "time", true, "P1D");
        this.getAsImage(baseUrl + "&TIME=2018-11-8/2018-11-09", MIME);
        this.assertWarningCount(2);
        this.assertNoNearestWarning(timeRangesId, "time");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.getAsImage(baseUrl + "&TIME=20018-11-05", MIME);
        this.assertWarningCount(2);
        this.assertNoNearestWarning(timeRangesId, "time");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.setupNearestMatch(TIMERANGES, "time", true, "P1D/P0D");
        this.getAsImage(baseUrl + "&TIME=2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-04T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.getAsImage(baseUrl + "&TIME=2008-11-04T16:00:00.000Z", MIME);
        this.assertWarningCount(2);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-04T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.setupNearestMatch(TIMERANGES, "time", true, "P1D");
        this.getAsImage(baseUrl + "&TIME=2000-10-31/2000-10-31", MIME);
        this.assertWarningCount(2);
        this.assertNoNearestWarning(timeRangesId, "time");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.getAsImage(baseUrl + "&TIME=2000-10-31", MIME);
        this.assertWarningCount(2);
        this.assertNoNearestWarning(timeRangesId, "time");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
    }

    @Test
    public void testTimeRangeNearestMatchAcceptableRangeNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeRangeNearestMatchAcceptableRange();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeDefaultAsRange() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("2008-10-30T23:00:00.000Z/2008-10-31T01:00:00.000Z");
        this.setupResourceDimensionDefaultValue(WATTEMP, "time", defaultValueSetting, new String[0]);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&elevation=100", MIME);
        this.assertPixel(image, 36, 31, new Color(255, 255, 255));
        this.assertPixel(image, 68, 72, new Color(240, 240, 255));
    }

    @Test
    public void testElevationDefaultAsRange() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("99/101");
        this.setupResourceDimensionDefaultValue(WATTEMP, "elevation", defaultValueSetting, new String[0]);
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.0&request=GetMap&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&time=2008-10-31T00:00:00.000Z", MIME);
        this.assertPixel(image, 36, 31, new Color(255, 255, 255));
        this.assertPixel(image, 68, 72, new Color(240, 240, 255));
    }

    @Test
    public void testTimeElevationDefaultAsRange() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("2008-10-30T23:00:00.000Z/2008-10-31T01:00:00.000Z");
        this.setupResourceDimensionDefaultValue(WATTEMP, "time", defaultValueSetting, new String[0]);
        defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("99/101");
        this.setupResourceDimensionDefaultValue(WATTEMP, "elevation", defaultValueSetting, new String[0]);
        BufferedImage image = this.getAsImage(BASE_PNG_URL, MIME);
        this.assertPixel(image, 36, 31, new Color(255, 255, 255));
        this.assertPixel(image, 68, 72, new Color(240, 240, 255));
    }

    @Test
    public void testNearestMatchTwoLayers() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(TIMERANGES, "wavelength", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "date", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(TIMERANGES, "time", true);
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true);
        String timeRangesId = this.getLayerId(TIMERANGES);
        String waterTempId = this.getLayerId(WATTEMP);
        String baseUrl = "wms?LAYERS=" + timeRangesId + "," + waterTempId + "&STYLES=,&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=-180,-90,180,90&WIDTH=200&HEIGHT=80&bgcolor=0x0000FF";
        this.getAsImage(baseUrl + "&TIME=2000-01-01", MIME);
        this.assertWarningCount(4);
        this.assertNearestTimeWarning(timeRangesId, "2008-10-31T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertNearestTimeWarning(waterTempId, "2008-10-31T00:00:00.000Z");
        this.assertDefaultDimensionWarning(waterTempId, "elevation", "foot", "0.0");
        this.getAsImage(baseUrl + "&TIME=2100-01-01", MIME);
        this.assertWarningCount(4);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-07T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertNearestTimeWarning(waterTempId, "2008-11-01T00:00:00.000Z");
        this.assertDefaultDimensionWarning(waterTempId, "elevation", "foot", "0.0");
    }

    @Test
    public void testNearestTimes() throws Exception {
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        CoverageInfo info = this.getCatalog().getCoverageByName(TIMESERIES.getLocalPart());
        DimensionInfo dim = (DimensionInfo)info.getMetadata().get((Object)"time");
        dim.setNearestMatchEnabled(true);
        dim.setAcceptableInterval("P2D");
        this.getCatalog().save((ResourceInfo)info);
        TimeParser parser = new TimeParser();
        List queryRanges = (List)parser.parse("2014-01-01/2019-01-01/P1Y");
        Date duplicate = (Date)((List)parser.parse("2014-01-01T00:00:00.000Z")).get(0);
        queryRanges.add(duplicate);
        Assert.assertEquals((long)7L, (long)queryRanges.size());
        WMS wms = new WMS(this.getGeoServer());
        TreeSet times = wms.queryCoverageNearestMatchTimes(info, queryRanges);
        Assert.assertEquals((long)6L, (long)times.size());
        for (int i = 2014; i < 2020; ++i) {
            List list = (List)parser.parse(i + "-01-01T00:00:00.000Z");
            Date date = (Date)list.get(0);
            Assert.assertTrue((boolean)times.contains(date));
        }
    }
}

