/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.io.ByteArrayInputStream;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.util.NearestMatchFinder;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class DimensionsRasterGetFeatureInfoTest
extends WMSDimensionsTestSupport {
    static final String BASE_URL_NO_COUNT = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp";
    static final String BASE_URL = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50";
    static final String BASE_URL_ONE = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=1";
    static final double EPS = 0.001;
    private XpathEngine xpath;

    @Before
    public void setXpathEngine() throws Exception {
        this.xpath = XMLUnit.newXpathEngine();
    }

    Double getFeatureAt(String baseFeatureInfo, int x, int y, String layerName) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(baseFeatureInfo + "&info_format=application/vnd.ogc.gml&x=" + x + "&y=" + y);
        Assert.assertEquals((Object)"application/vnd.ogc.gml", (Object)response.getContentType());
        Document doc = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        String sCount = this.xpath.evaluate("count(//" + layerName + ")", doc);
        int count = Integer.valueOf(sCount);
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return Double.valueOf(this.xpath.evaluate("//" + layerName + "/sf:GRAY_INDEX", doc));
        }
        Assert.fail((String)("Found more than one feature: " + count));
        return null;
    }

    @Test
    public void testDefaultValues() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        Assert.assertEquals((double)14.51, (double)this.getFeatureAt(BASE_URL, 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)19.15, (double)this.getFeatureAt(BASE_URL, 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testSortTime() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Assert.assertEquals((double)14.51, (double)this.getFeatureAt("wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=1&sortBy=ingestion D", 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)19.15, (double)this.getFeatureAt("wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=1&sortBy=ingestion D", 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testSortTimeElevation() throws Exception {
        Assert.assertEquals((double)14.51, (double)this.getFeatureAt("wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=1&sortBy=ingestion D,elevation", 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)19.15, (double)this.getFeatureAt("wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=1&sortBy=ingestion D,elevation", 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testElevation() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&elevation=100";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)14.492, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testElevationInvalidIgnore() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(false);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&elevation=-100";
        Assert.assertNull((Object)this.getFeatureAt(url, 36, 31, "sf:watertemp"));
    }

    @Test
    public void testElevationInvalidException() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(true);
        Document dom = this.getAsDOM(String.format("%s&elevation=%d&info_format=text/plain&x=%d&y=%d", BASE_URL, -100, 36, 31));
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "elevation");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Could not find a match for 'elevation' value: '-100'"));
    }

    @Test
    public void testTime() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&time=2008-10-31T00:00:00.000Z";
        Assert.assertEquals((double)14.592, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)19.371, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testTimeInvalidIgnore() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(false);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&time=2050-10-31T00:00:00.000Z";
        Assert.assertNull((Object)this.getFeatureAt(url, 36, 31, "sf:watertemp"));
        Assert.assertNull((Object)this.getFeatureAt(url, 68, 72, "sf:watertemp"));
    }

    @Test
    public void testTimeNoNearestClose() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setExceptionsOnInvalidDimension(false);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&time=2008-10-31T08:00:00.000Z";
        Assert.assertNull((Object)this.getFeatureAt(url, 36, 31, "sf:watertemp"));
        Assert.assertNull((Object)this.getFeatureAt(url, 68, 72, "sf:watertemp"));
    }

    @Test
    public void testTimeNearestClose() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&time=2008-10-31T08:00:00.000Z";
        Assert.assertEquals((double)14.592, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-10-31T00:00:00.000Z");
        Assert.assertEquals((double)19.371, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-10-31T00:00:00.000Z");
    }

    @Test
    public void testTimeNearestBefore() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&time=1990-10-31";
        Assert.assertEquals((double)14.592, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-10-31T00:00:00.000Z");
        Assert.assertEquals((double)19.371, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-10-31T00:00:00.000Z");
    }

    @Test
    public void testTimeNearestAfter() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&time=2018-10-31";
        Assert.assertEquals((double)14.51, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-11-01T00:00:00.000Z");
        Assert.assertEquals((double)19.15, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(WATTEMP), "2008-11-01T00:00:00.000Z");
    }

    @Test
    public void testTimeNearestCloseNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeNearestClose();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeNearestBeforeNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeNearestBefore();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeNearestAfterNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeNearestAfter();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeElevation() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&time=2008-10-31T00:00:00.000Z&elevation=100";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)14.134, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testTimeRange() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(TIMERANGES, "custom_dimension_wavelength", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "custom_dimension_date", DimensionPresentation.LIST, null, null, null);
        String layer = this.getLayerId(TIMERANGES);
        String baseUrl = "wms?LAYERS=" + layer + "&STYLES=temperature&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=-0.89131513678082,40.246933882167,15.721292974683,44.873229811941&WIDTH=200&HEIGHT=80&query_layers=" + layer;
        String url = baseUrl + "&TIME=2008-11-05T00:00:00.000Z/2008-11-06T12:00:00.000Z";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, layer), (double)0.001);
        Assert.assertEquals((double)14.782, (double)this.getFeatureAt(url, 68, 72, layer), (double)0.001);
        this.setExceptionsOnInvalidDimension(false);
        url = baseUrl + "&TIME=2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z";
        Assert.assertNull((Object)this.getFeatureAt(url, 36, 31, layer));
        this.setExceptionsOnInvalidDimension(true);
        url = baseUrl + "&TIME=2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z";
        Document dom = this.getAsDOM(url + "&info_format=application/vnd.ogc.gml&x=36&y=31");
        String message = this.checkLegacyException(dom, "InvalidDimensionValue", "time");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Could not find a match for 'time' value: '2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z'"));
        url = baseUrl + "&TIME=2008-10-31T12:00:00.000Z/2008-10-31T16:00:00.000Z";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, layer), (double)0.001);
        Assert.assertEquals((double)20.027, (double)this.getFeatureAt(url, 68, 72, layer), (double)0.001);
    }

    @Test
    public void testTimeRangeNearestMatch() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(TIMERANGES, "custom_dimension_wavelength", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "custom_dimension_date", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(TIMERANGES, "time", true);
        String layer = this.getLayerId(TIMERANGES);
        String baseUrl = "wms?LAYERS=" + layer + "&STYLES=temperature&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=-0.89131513678082,40.246933882167,15.721292974683,44.873229811941&WIDTH=200&HEIGHT=80&query_layers=" + layer;
        String url = baseUrl + "&TIME=2018-11-05/2018-11-06";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-11-07T00:00:00.000Z");
        Assert.assertEquals((double)14.782, (double)this.getFeatureAt(url, 68, 72, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-11-07T00:00:00.000Z");
        url = baseUrl + "&TIME=2018-11-05";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-11-07T00:00:00.000Z");
        Assert.assertEquals((double)14.782, (double)this.getFeatureAt(url, 68, 72, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-11-07T00:00:00.000Z");
        url = baseUrl + "&TIME=2008-11-04T12:00:00.000Z/2008-11-04T16:00:00.000Z";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-11-05T00:00:00.000Z");
        Assert.assertEquals((double)14.782, (double)this.getFeatureAt(url, 68, 72, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-11-05T00:00:00.000Z");
        url = baseUrl + "&TIME=2005-10-30/2005-10-31";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-10-31T00:00:00.000Z");
        Assert.assertEquals((double)20.027, (double)this.getFeatureAt(url, 68, 72, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-10-31T00:00:00.000Z");
        url = baseUrl + "&TIME=2005-10-30";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-10-31T00:00:00.000Z");
        Assert.assertEquals((double)20.027, (double)this.getFeatureAt(url, 68, 72, layer), (double)0.001);
        this.assertNearestTimeWarning(this.getLayerId(TIMERANGES), "2008-10-31T00:00:00.000Z");
    }

    @Test
    public void testTimeRangeNearestMatchNonStructured() throws Exception {
        NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = false;
        try {
            this.testTimeRangeNearestMatch();
        }
        finally {
            NearestMatchFinder.ENABLE_STRUCTURED_READER_SUPPORT = true;
        }
    }

    @Test
    public void testTimeDefaultAsRange() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("2008-10-30T23:00:00.000Z/2008-10-31T01:00:00.000Z");
        this.setupResourceDimensionDefaultValue(WATTEMP, "time", defaultValueSetting, new String[0]);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&elevation=100";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)14.134, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testElevationDefaultAsRange() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("99/101");
        this.setupResourceDimensionDefaultValue(WATTEMP, "elevation", defaultValueSetting, new String[0]);
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=watertemp&styles=&bbox=0.237,40.562,14.593,44.558&width=200&height=80&srs=EPSG:4326&format=image/png&query_layers=watertemp&feature_count=50&time=2008-10-31T00:00:00.000Z";
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)14.134, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testTimeElevationDefaultAsRange() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("2008-10-30T23:00:00.000Z/2008-10-31T01:00:00.000Z");
        this.setupResourceDimensionDefaultValue(WATTEMP, "time", defaultValueSetting, new String[0]);
        defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("99/101");
        this.setupResourceDimensionDefaultValue(WATTEMP, "elevation", defaultValueSetting, new String[0]);
        String url = BASE_URL;
        Assert.assertEquals((double)-30000.0, (double)this.getFeatureAt(url, 36, 31, "sf:watertemp"), (double)0.001);
        Assert.assertEquals((double)14.134, (double)this.getFeatureAt(url, 68, 72, "sf:watertemp"), (double)0.001);
    }

    @Test
    public void testNearestMatchTwoLayers() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(TIMERANGES, "custom_dimension_wavelength", DimensionPresentation.LIST, null, null, null);
        this.setupRasterDimension(TIMERANGES, "custom_dimension_date", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(TIMERANGES, "time", true);
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, "ISO8601", null);
        this.setupNearestMatch(WATTEMP, "time", true);
        String timeRangesId = this.getLayerId(TIMERANGES);
        String waterTempId = this.getLayerId(WATTEMP);
        String layers = timeRangesId + "," + waterTempId;
        String baseUrl = "wms?LAYERS=" + layers + "&STYLES=,&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=-0.89131513678082,40.246933882167,15.721292974683,44.873229811941&WIDTH=200&HEIGHT=80&query_layers=" + layers + "&FEATURE_COUNT=50";
        String url = baseUrl + "&TIME=2000-01-01";
        this.getFeatureAt(url, 68, 72, timeRangesId);
        this.assertWarningCount(4);
        this.assertNearestTimeWarning(timeRangesId, "2008-10-31T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertNearestTimeWarning(waterTempId, "2008-10-31T00:00:00.000Z");
        this.assertDefaultDimensionWarning(waterTempId, "elevation", "foot", "0.0");
        url = baseUrl + "&TIME=2100-01-01";
        this.getFeatureAt(url, 68, 72, timeRangesId);
        this.assertWarningCount(4);
        this.assertNearestTimeWarning(timeRangesId, "2008-11-07T00:00:00.000Z");
        this.assertDefaultDimensionWarning(timeRangesId, "elevation", "foot", "20.0");
        this.assertNearestTimeWarning(waterTempId, "2008-11-01T00:00:00.000Z");
        this.assertDefaultDimensionWarning(waterTempId, "elevation", "foot", "0.0");
    }
}

