/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DimensionsRasterCapabilitiesTest
extends WMSDimensionsTestSupport {
    @Test
    public void testNoDimension() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        Element e = dom.getDocumentElement();
        Assert.assertEquals((Object)"WMT_MS_Capabilities", (Object)e.getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='sf:watertemp'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Layer/Extent)", (Document)dom);
    }

    @Test
    public void testDefaultElevationUnits() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:5030", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"m", (String)"//Layer/Dimension/@unitSymbol", (Document)dom);
    }

    @Test
    public void testElevationList() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//Layer/Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0,100.0", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testElevationContinuous() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//Layer/Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/100.0/0", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testElevationDiscreteNoResolution() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.DISCRETE_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//Layer/Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/100.0/100.0", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testElevationDiscreteManualResolution() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.DISCRETE_INTERVAL, 10.0, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//Layer/Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/100.0/10.0", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testDefaultTimeRangeFixed() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("P1M/PRESENT");
        this.setupResourceDimensionDefaultValue(WATTEMP, "time", defaultValueSetting, new String[0]);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"P1M/PRESENT", (String)"//Layer/Extent/@default", (Document)dom);
    }

    @Test
    public void testTimeList() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//Layer/Extent/@nearestValue", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testTimeNearestMatch() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(WATTEMP, "time", true);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//Layer/Extent/@nearestValue", (Document)dom);
    }

    @Test
    public void testTimeContinuous() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT1S", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testTimeResolution() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.DISCRETE_INTERVAL, 4.32E7, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT12H", (String)"//Layer/Extent", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeContinuousInEarthObservationRootLayer() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        LayerInfo rootLayer = this.getCatalog().getLayerByName("watertemp");
        LayerGroupInfoImpl eoProduct = new LayerGroupInfoImpl();
        eoProduct.setName("EO Sample");
        eoProduct.setMode(LayerGroupInfo.Mode.EO);
        eoProduct.setRootLayer(rootLayer);
        eoProduct.setRootLayerStyle(rootLayer.getDefaultStyle());
        CatalogBuilder catBuilder = new CatalogBuilder(this.getCatalog());
        catBuilder.calculateLayerGroupBounds((LayerGroupInfo)eoProduct);
        eoProduct.getLayers().add(rootLayer);
        eoProduct.getStyles().add(null);
        this.getCatalog().add((LayerGroupInfo)eoProduct);
        try {
            Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name[text() = 'EO Sample']]/Dimension)", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer[Name[text() = 'EO Sample']]/Dimension/@name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//Layer[Name[text() = 'EO Sample']]/Dimension/@units", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name[text() = 'EO Sample']]/Extent)", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer[Name[text() = 'EO Sample']]/Extent/@name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//Layer[Name[text() = 'EO Sample']]/Extent/@default", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z/2008-11-01T00:00:00.000Z/PT1S", (String)"//Layer[Name[text() = 'EO Sample']]/Extent", (Document)dom);
        }
        finally {
            this.getCatalog().remove((LayerGroupInfo)eoProduct);
        }
    }

    @Test
    public void testTimeRangeList() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z/2008-11-04T00:00:00.000Z/PT1S,2008-11-05T00:00:00.000Z/2008-11-07T00:00:00.000Z/PT1S", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testElevationRangeList() throws Exception {
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//Layer/Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0/99.0/0,100.0/150.0/0", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testElevationRangeContinousInterval() throws Exception {
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//Layer/Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//Layer/Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Extent)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Extent/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0", (String)"//Layer/Extent/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"20.0/150.0/0", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testStaticTimeRange() throws Exception {
        String startValue = "2014-01-24T13:25:00.000Z";
        String endValue = "2021";
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.DISCRETE_INTERVAL, 4.32E7, null, null);
        this.setupRasterStartAndEndValues(TIMERANGES, "time", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2014-01-24T13:25:00.000Z/2021-01-01T00:00:00.000Z/PT12H", (String)"//Layer/Extent", (Document)dom);
    }

    @Test
    public void testStaticTimeRangeContinuous() throws Exception {
        String startValue = "2014-01-24T13:25:00.000Z";
        String endValue = "2021";
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        this.setupRasterStartAndEndValues(TIMERANGES, "time", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2014-01-24T13:25:00.000Z/2021-01-01T00:00:00.000Z/PT1S", (String)"//Layer[Name='sf:timeranges']/Extent", (Document)dom);
    }

    @Test
    public void testStaticElevationRange() throws Exception {
        String startValue = "-11034.0";
        String endValue = "8848.86";
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.DISCRETE_INTERVAL, 1.1, "foot", "ft");
        this.setupRasterStartAndEndValues(TIMERANGES, "elevation", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-11034.0/8848.86/1.1", (String)"//Layer[Name='sf:timeranges']/Extent", (Document)dom);
    }

    @Test
    public void testStaticElevationRangeContinuous() throws Exception {
        String startValue = "-11034.0";
        String endValue = "8848.86";
        this.setupRasterDimension(TIMERANGES, "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        this.setupRasterStartAndEndValues(TIMERANGES, "elevation", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer/Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//Layer/Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-11034.0/8848.86/0", (String)"//Layer[Name='sf:timeranges']/Extent", (Document)dom);
    }
}

