/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.impl.AuthorityURL;
import org.geoserver.catalog.impl.LayerIdentifier;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class CapabilitiesAuthorityURLAndIdentifierTest
extends WMSTestSupport {
    private void addAuthUrl(String name, String url, List<AuthorityURLInfo> target) {
        AuthorityURL auth = new AuthorityURL();
        auth.setName(name);
        auth.setHref(url);
        target.add((AuthorityURLInfo)auth);
    }

    private void addIdentifier(String authName, String id, List<LayerIdentifierInfo> target) {
        LayerIdentifier identifier = new LayerIdentifier();
        identifier.setAuthority(authName);
        identifier.setIdentifier(id);
        target.add((LayerIdentifierInfo)identifier);
    }

    @Test
    public void testRootLayer() throws Exception {
        WMSInfo serviceInfo = this.getWMS().getServiceInfo();
        this.addAuthUrl("rootAuth1", "http://geoserver/wms/auth1", serviceInfo.getAuthorityURLs());
        this.addAuthUrl("rootAuth2", "http://geoserver/wms/auth2", serviceInfo.getAuthorityURLs());
        this.addIdentifier("rootAuth1", "rootId1", serviceInfo.getIdentifiers());
        this.addIdentifier("rootAuth2", "rootId2", serviceInfo.getIdentifiers());
        this.getGeoServer().save((ServiceInfo)serviceInfo);
        Document doc = this.getAsDOM("/wms?service=WMS&request=getCapabilities&version=1.1.1", true);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/AuthorityURL[@name = 'rootAuth1']", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver/wms/auth1", (String)"/WMT_MS_Capabilities/Capability/Layer/AuthorityURL[@name = 'rootAuth1']/OnlineResource/@xlink:href", (Document)doc);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/AuthorityURL[@name = 'rootAuth2']", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver/wms/auth2", (String)"/WMT_MS_Capabilities/Capability/Layer/AuthorityURL[@name = 'rootAuth2']/OnlineResource/@xlink:href", (Document)doc);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Identifier[@authority = 'rootAuth1']", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"rootId1", (String)"/WMT_MS_Capabilities/Capability/Layer/Identifier[@authority = 'rootAuth1']", (Document)doc);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/Identifier[@authority = 'rootAuth2']", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"rootId2", (String)"/WMT_MS_Capabilities/Capability/Layer/Identifier[@authority = 'rootAuth2']", (Document)doc);
    }

    @Test
    public void testLayer() throws Exception {
        String layerId = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        this.addAuthUrl("layerAuth1", "http://geoserver/wms/auth1", layer.getAuthorityURLs());
        this.addIdentifier("layerAuth1", "layerId1", layer.getIdentifiers());
        this.getCatalog().save(layer);
        String layerName = MockData.PRIMITIVEGEOFEATURE.getLocalPart();
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layerName + "']/AuthorityURL[@name = 'layerAuth1']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver/wms/auth1", (String)("//Layer[Name='" + layerName + "']/AuthorityURL[@name = 'layerAuth1']/OnlineResource/@xlink:href"), (Document)doc);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layerName + "']/Identifier[@authority = 'layerAuth1']"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"layerId1", (String)("//Layer[Name='" + layerName + "']/Identifier[@authority = 'layerAuth1']"), (Document)doc);
    }
}

