/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.tiffspy;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.tiffspy.GeoTIFFSpyReader;
import org.geotools.api.data.DataSourceException;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class GeoTIFFSpyFormat
extends GeoTiffFormat {
    public static boolean ENABLED = false;
    static final Logger LOGGER = Logging.getLogger(GeoTIFFSpyFormat.class);
    public static final String NAME = "GeoTIFFSpy";

    public String getName() {
        return NAME;
    }

    public boolean accepts(Object source) {
        return ENABLED && super.accepts(source);
    }

    public boolean accepts(Object o, Hints hints) {
        return ENABLED && super.accepts(o);
    }

    public GeoTiffReader getReader(Object source) {
        try {
            return new GeoTIFFSpyReader(source);
        }
        catch (DataSourceException e) {
            LOGGER.log(Level.INFO, "Failed to create GeoTIFFSpyReader", e);
            return null;
        }
    }

    public GeoTiffReader getReader(Object source, Hints hints) {
        try {
            return new GeoTIFFSpyReader(source, hints);
        }
        catch (DataSourceException e) {
            LOGGER.log(Level.INFO, "Failed to create GeoTIFFSpyReader", e);
            return null;
        }
    }
}

