/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.decoration.TextDecoration;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.function.EnvFunction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MapDecorationLayoutTest {
    private static final String DYNAMIC_TEXT_DECORATION = "<layout>\n  <decoration type=\"text\" affinity=\"bottom,right\" offset=\"${env('offset', '6,6')}\" size=\"auto\">\n    <option name=\"message\">${expression}</option>\n    <option name=\"font-family\" value=\"Bitstream Vera Sans\"/>\n    <option name=\"font-size\" value=\"${env('fs', 12)}\"/>\n    <option name=\"halo-radius\" value=\"2\"/>\n  </decoration>\n</layout>\n";

    private Graphics2D createMockGraphics(int x, int y) {
        BufferedImage b = new BufferedImage(x, y, 1);
        return (Graphics2D)b.getGraphics();
    }

    @Test
    public void testStaticSize() throws Exception {
        Graphics2D g2d = this.createMockGraphics(256, 256);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(100, 100), new Rectangle(156, 78, 100, 100)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(100, 100), new Rectangle(206, 103, 50, 50)), MapDecorationLayout.Block.Position.CR, new Dimension(50, 50), new Point(0, 0)));
        dl.paint(g2d, new Rectangle(0, 0, 256, 256), null);
    }

    @Test
    public void testSquished() throws Exception {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 100), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(100, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, new Dimension(100, 150), new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, new Dimension(150, 100), new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(150, 150), new Rectangle(0, 0, 100, 100)), MapDecorationLayout.Block.Position.CR, new Dimension(150, 150), new Point(0, 0)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    @Test
    public void testPosition() {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(0, 0, 10, 10)), MapDecorationLayout.Block.Position.UL, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 0, 10, 10)), MapDecorationLayout.Block.Position.UC, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(90, 0, 10, 10)), MapDecorationLayout.Block.Position.UR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(0, 45, 10, 10)), MapDecorationLayout.Block.Position.CL, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 45, 10, 10)), MapDecorationLayout.Block.Position.CC, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(90, 45, 10, 10)), MapDecorationLayout.Block.Position.CR, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(0, 90, 10, 10)), MapDecorationLayout.Block.Position.LL, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 90, 10, 10)), MapDecorationLayout.Block.Position.LC, null, new Point(0, 0)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(90, 90, 10, 10)), MapDecorationLayout.Block.Position.LR, null, new Point(0, 0)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    @Test
    public void testOffset() {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(10, 10, 10, 10)), MapDecorationLayout.Block.Position.UL, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 10, 10, 10)), MapDecorationLayout.Block.Position.UC, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(80, 10, 10, 10)), MapDecorationLayout.Block.Position.UR, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(10, 45, 10, 10)), MapDecorationLayout.Block.Position.CL, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 45, 10, 10)), MapDecorationLayout.Block.Position.CC, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(80, 45, 10, 10)), MapDecorationLayout.Block.Position.CR, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(10, 80, 10, 10)), MapDecorationLayout.Block.Position.LL, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(45, 80, 10, 10)), MapDecorationLayout.Block.Position.LC, null, new Point(10, 10)));
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(10, 10), new Rectangle(80, 80, 10, 10)), MapDecorationLayout.Block.Position.LR, null, new Point(10, 10)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    @Test
    public void testTopCenter() {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block((MapDecoration)new MockMapDecoration(new Dimension(50, 10), new Rectangle(25, 10, 50, 10)), MapDecorationLayout.Block.Position.UC, null, new Point(0, 10)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    @Test
    public void testResetGraphics() {
        Graphics2D g2d = this.createMockGraphics(100, 100);
        MapDecorationLayout dl = new MapDecorationLayout();
        dl.addBlock(new MapDecorationLayout.Block(new MapDecoration(){

            public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent context) throws Exception {
            }

            public void loadOptions(Map<String, Expression> options) throws Exception {
            }

            public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) throws Exception {
                return new Dimension(10, 10);
            }
        }, MapDecorationLayout.Block.Position.UC, null, new Point(0, 10)));
        dl.paint(g2d, new Rectangle(0, 0, 100, 100), null);
    }

    @Test
    public void testLoadLargeValue() throws Exception {
        String messageTemplate = "<#setting datetime_format=\"yyyy-MM-dd'T'HH:mm:ss.SSSX\">\n<#setting locale=\"en_US\">\n<#if time??>\n${time?datetime?string[\"dd-MM-yyyy\"]}\n</#if>";
        String definition = "<layout>\n  <decoration type=\"text\" affinity=\"bottom,right\" offset=\"6,6\" size=\"auto\">\n    <option name=\"message\"><![CDATA[" + messageTemplate + "]]></option>\n    <option name=\"font-family\" value=\"Bitstream Vera Sans\"/>\n    <option name=\"font-size\" value=\"12\"/>\n    <option name=\"halo-radius\" value=\"2\"/>\n  </decoration>\n</layout>\n";
        GeoServerExtensionsHelper.singleton((String)"text", (Object)new TextDecoration(), (Class[])new Class[0]);
        MapDecorationLayout layout = MapDecorationLayout.fromString((String)definition, (boolean)false);
        List blocks = layout.blocks;
        Assert.assertEquals((long)1L, (long)blocks.size());
        MatcherAssert.assertThat((Object)((MapDecorationLayout.Block)blocks.get((int)0)).decoration, (Matcher)CoreMatchers.instanceOf(TextDecoration.class));
        TextDecoration text = (TextDecoration)((MapDecorationLayout.Block)blocks.get((int)0)).decoration;
        Assert.assertEquals((Object)messageTemplate, (Object)text.message.evaluate(null));
    }

    @Test
    public void testLoadWithExpressionsDefaults() throws Exception {
        MapDecorationLayout.Block block = this.loadDynamicDecoration();
        Assert.assertEquals((Object)new Point(6, 6), (Object)block.offset);
        MatcherAssert.assertThat((Object)block.decoration, (Matcher)CoreMatchers.instanceOf(TextDecoration.class));
        TextDecoration text = (TextDecoration)block.decoration;
        Assert.assertEquals((Object)"${expression}", (Object)text.message.evaluate(null));
        Assert.assertEquals((float)12.0f, (float)text.fontSize, (float)0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadWithExpressionsEnv() throws Exception {
        HashMap<String, String> locals = new HashMap<String, String>();
        locals.put("offset", "12,12");
        locals.put("fs", "14");
        EnvFunction.setLocalValues(locals);
        try {
            MapDecorationLayout.Block block = this.loadDynamicDecoration();
            Assert.assertEquals((Object)new Point(12, 12), (Object)block.offset);
            MatcherAssert.assertThat((Object)block.decoration, (Matcher)CoreMatchers.instanceOf(TextDecoration.class));
            TextDecoration text = (TextDecoration)block.decoration;
            Assert.assertEquals((float)14.0f, (float)text.fontSize, (float)0.0f);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    private MapDecorationLayout.Block loadDynamicDecoration() throws Exception {
        GeoServerExtensionsHelper.singleton((String)"text", (Object)new TextDecoration(), (Class[])new Class[0]);
        MapDecorationLayout layout = MapDecorationLayout.fromString((String)DYNAMIC_TEXT_DECORATION, (boolean)false);
        List blocks = layout.blocks;
        Assert.assertEquals((long)1L, (long)blocks.size());
        MapDecorationLayout.Block block = (MapDecorationLayout.Block)blocks.get(0);
        return block;
    }

    private class MockMapDecoration
    implements MapDecoration {
        Dimension request;
        Rectangle expect;

        public MockMapDecoration(Dimension toRequest, Rectangle toExpect) {
            this.request = toRequest;
            this.expect = toExpect;
        }

        public void loadOptions(Map<String, Expression> options) {
        }

        public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) {
            return this.request;
        }

        public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent mapContent) throws Exception {
            Assert.assertEquals((String)"Calculated width matches expected", (long)this.expect.width, (long)paintArea.width);
            Assert.assertEquals((String)"Calculated height matches expected", (long)this.expect.height, (long)paintArea.height);
            Assert.assertEquals((String)"Calculated x matches expected", (long)this.expect.x, (long)paintArea.x);
            Assert.assertEquals((String)"Calculated y matches expected", (long)this.expect.y, (long)paintArea.y);
        }
    }
}

