/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.DimensionFilterBuilder;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.filter.Filter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.ImageGraphicFactory;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WMSTest
extends WMSTestSupport {
    static final QName TIME_WITH_START_END = new QName(MockData.SF_URI, "TimeWithStartEnd", MockData.SF_PREFIX);
    WMS wms;
    private static final String CUSTOM_DIMENSION_NAME = "dim_reference_time";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(TIME_WITH_START_END, Collections.emptyMap(), "TimeElevationWithStartEnd.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    protected void setupStartEndTimeDimension(String featureTypeName, String dimension, String start, String end) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(featureTypeName);
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute(start);
        di.setEndAttribute(end);
        di.setPresentation(DimensionPresentation.LIST);
        info.getMetadata().put(dimension, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void setupStartEndTimeDimension(String featureTypeName, String dimensionName, String start, String end, DimensionDefaultValueSetting defaultValue) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(featureTypeName);
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute(start);
        di.setEndAttribute(end);
        di.setDefaultValue(defaultValue);
        di.setPresentation(DimensionPresentation.LIST);
        info.getMetadata().put(dimensionName, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    @Before
    public void setWMS() {
        this.wms = this.getWMS();
    }

    @Test
    public void testGetTimeElevationToFilterStartEndDate() throws Exception {
        this.setupStartEndTimeDimension(TIME_WITH_START_END.getLocalPart(), "time", "startTime", "endTime");
        this.setupStartEndTimeDimension(TIME_WITH_START_END.getLocalPart(), "elevation", "startElevation", "endElevation");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.doTimeElevationFilter(format.parse("2012-02-10"), null, new Integer[0]);
        this.doTimeElevationFilter(format.parse("2012-02-11"), null, 0, 2);
        this.doTimeElevationFilter(format.parse("2012-02-12"), null, 0, 1, 2);
        this.doTimeElevationFilter(format.parse("2012-02-13"), null, 1, 2);
        this.doTimeElevationFilter(format.parse("2012-02-15"), null, new Integer[0]);
        this.doTimeElevationFilter(new DateRange(format.parse("2012-02-09"), format.parse("2012-02-10")), null, new Integer[0]);
        this.doTimeElevationFilter(new DateRange(format.parse("2012-02-09"), format.parse("2012-02-11")), null, 0, 2);
        this.doTimeElevationFilter(new DateRange(format.parse("2012-02-11"), format.parse("2012-02-13")), null, 0, 1, 2);
        this.doTimeElevationFilter(new DateRange(format.parse("2012-02-09"), format.parse("2012-02-14")), null, 0, 1, 2);
        this.doTimeElevationFilter(new DateRange(format.parse("2012-02-13"), format.parse("2012-02-14")), null, 1, 2);
        this.doTimeElevationFilter(new DateRange(format.parse("2012-02-12"), format.parse("2012-02-13")), null, 0, 1, 2);
        this.doTimeElevationFilter(new DateRange(format.parse("2012-02-15"), format.parse("2012-02-16")), null, new Integer[0]);
        this.doTimeElevationFilter(null, 0, new Integer[0]);
        this.doTimeElevationFilter(null, 1, 0, 2);
        this.doTimeElevationFilter(null, 2, 0, 1, 2);
        this.doTimeElevationFilter(null, 3, 1, 2);
        this.doTimeElevationFilter(null, 4, new Integer[0]);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)-1, (Number)0), new Integer[0]);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)-1, (Number)1), 0, 2);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)1, (Number)3), 0, 1, 2);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)-1, (Number)4), 0, 1, 2);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)3, (Number)4), 1, 2);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)4, (Number)5), new Integer[0]);
        this.doTimeElevationFilter(format.parse("2012-02-12"), 2, 0, 1, 2);
        this.doTimeElevationFilter(format.parse("2012-02-11"), 3, 2);
    }

    public void doTimeElevationFilter(Object time, Object elevation, Integer ... expectedIds) throws Exception {
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        this.setupStartEndTimeDimension(TIME_WITH_START_END.getLocalPart(), "elevation", "startElevation", "endElevation");
        FeatureSource fs = timeWithStartEnd.getFeatureSource(null, null);
        List<Object> times = time == null ? null : Arrays.asList(time);
        List<Object> elevations = elevation == null ? null : Arrays.asList(elevation);
        DimensionFilterBuilder builder = new DimensionFilterBuilder(CommonFactoryFinder.getFilterFactory());
        this.wms.getTimeFilter(times, timeWithStartEnd, builder);
        this.wms.getElevationFilter(elevations, timeWithStartEnd, builder);
        Filter filter = builder.getFilter();
        FeatureCollection features = fs.getFeatures(filter);
        HashSet<Integer> results = new HashSet<Integer>();
        try (FeatureIterator it = features.features();){
            while (it.hasNext()) {
                results.add((Integer)it.next().getProperty("id").getValue());
            }
        }
        Assert.assertTrue((String)("expected " + Arrays.toString((Object[])expectedIds) + " but got " + results), (boolean)results.containsAll(Arrays.asList(expectedIds)));
        Assert.assertTrue((String)("expected " + Arrays.toString((Object[])expectedIds) + " but got " + results), (boolean)Arrays.asList(expectedIds).containsAll(results));
    }

    @Test
    public void customDimensionFilterWithoutCustomDimensions() throws IOException {
        FeatureTypeInfo featureTypeInfo = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        featureTypeInfo.getMetadata().remove((Object)CUSTOM_DIMENSION_NAME);
        this.getCatalog().save((ResourceInfo)featureTypeInfo);
        DimensionFilterBuilder filterBuilder = new DimensionFilterBuilder(CommonFactoryFinder.getFilterFactory(null));
        Assert.assertEquals((String)"Custom dimension filter should return 'Filter.INCLUDE' when no custom dimensions are defined.", (Object)Filter.INCLUDE, (Object)this.wms.getCustomDimensionFilter(new HashMap(), featureTypeInfo, filterBuilder));
        HashMap<String, String> rawKvp = new HashMap<String, String>();
        rawKvp.put(CUSTOM_DIMENSION_NAME.toUpperCase(), DateTimeFormatter.ISO_INSTANT.format(Instant.parse("2012-02-12T09:05:00Z")));
        Assert.assertEquals((String)"Custom dimension filter should return 'Filter.INCLUDE' when no custom dimensions are defined.", (Object)Filter.INCLUDE, (Object)this.wms.getCustomDimensionFilter(rawKvp, featureTypeInfo, filterBuilder));
        this.doCustomDimensionFilter(rawKvp, null, List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), false);
    }

    @Test
    public void customDimensionFilterFeaturesMatchingRequest() throws Exception {
        HashMap<String, String> rawKvp = new HashMap<String, String>();
        rawKvp.put(CUSTOM_DIMENSION_NAME.toUpperCase(), DateTimeFormatter.ISO_INSTANT.format(Instant.parse("2012-02-12T09:05:00Z")));
        this.doCustomDimensionFilter(rawKvp, null, List.of(Integer.valueOf(1), Integer.valueOf(2)), true);
        rawKvp.put(CUSTOM_DIMENSION_NAME.toUpperCase(), DateTimeFormatter.ISO_INSTANT.format(Instant.parse("2012-02-10T09:05:00Z")));
        this.doCustomDimensionFilter(rawKvp, null, Collections.emptyList(), true);
        rawKvp.put(CUSTOM_DIMENSION_NAME.toUpperCase(), DateTimeFormatter.ISO_INSTANT.format(Instant.parse("2012-02-20T09:05:00Z")));
        this.doCustomDimensionFilter(rawKvp, null, Collections.emptyList(), true);
    }

    @Test
    public void customDimensionFilterMinimumDefaultStrategy() throws Exception {
        this.doCustomDimensionFilter(new HashMap<String, String>(), null, List.of(Integer.valueOf(0), Integer.valueOf(2)), true);
    }

    @Test
    public void customDimensionFilterDefaultStrategyWhenDimensionMissing() throws IOException {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MINIMUM);
        this.doCustomDimensionFilter(new HashMap<String, String>(), defaultValueSetting, List.of(Integer.valueOf(0), Integer.valueOf(2)), true);
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MAXIMUM);
        this.doCustomDimensionFilter(new HashMap<String, String>(), defaultValueSetting, List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), true);
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue("2012-02-14Z");
        this.doCustomDimensionFilter(new HashMap<String, String>(), defaultValueSetting, List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), true);
    }

    @Test
    public void customDimensionFilterDefaultStrategyWhenDimensionValueMissing() throws IOException {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("2012-02-14Z");
        HashMap<String, String> rawKvp = new HashMap<String, String>();
        rawKvp.put(CUSTOM_DIMENSION_NAME.toUpperCase(), null);
        this.doCustomDimensionFilter(rawKvp, defaultValueSetting, List.of(Integer.valueOf(2)), true);
    }

    public void doCustomDimensionFilter(Map<String, String> rawKvp, DimensionDefaultValueSetting defaultValueSetting, List<Integer> expectedFeatureIds, boolean setupDimension) throws IOException {
        FeatureTypeInfo typeInfo = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        FeatureSource fs = typeInfo.getFeatureSource(null, null);
        if (setupDimension) {
            this.setupStartEndTimeDimension(TIME_WITH_START_END.getLocalPart(), CUSTOM_DIMENSION_NAME, "startTime", "endTime", defaultValueSetting);
        }
        DimensionFilterBuilder filterBuilder = new DimensionFilterBuilder(CommonFactoryFinder.getFilterFactory(null));
        Filter filter = this.wms.getCustomDimensionFilter(rawKvp, typeInfo, filterBuilder);
        FeatureCollection features = fs.getFeatures(filter);
        HashSet<Integer> results = new HashSet<Integer>();
        try (FeatureIterator it = features.features();){
            while (it.hasNext()) {
                results.add((Integer)it.next().getProperty("id").getValue());
            }
        }
        Assert.assertEquals((String)("We are expecting " + expectedFeatureIds.size() + " features but got " + results.size()), (long)expectedFeatureIds.size(), (long)results.size());
        Assert.assertTrue((String)("We are expecting feature ids " + expectedFeatureIds + " but got " + results), (boolean)results.containsAll(expectedFeatureIds));
    }

    @Test
    public void testWMSLifecycleHandlerGraphicCacheReset() throws Exception {
        Iterator it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
        Map imageCache = null;
        while (it.hasNext()) {
            Map cast;
            ExternalGraphicFactory egf = (ExternalGraphicFactory)it.next();
            if (!(egf instanceof ImageGraphicFactory)) continue;
            Field cache = egf.getClass().getDeclaredField("imageCache");
            cache.setAccessible(true);
            imageCache = cast = (Map)cache.get(egf);
            URL u = new URL("http://boundless.org");
            BufferedImage b = new BufferedImage(6, 6, 8);
            imageCache.put(u, b);
        }
        Assert.assertNotEquals((long)0L, (long)imageCache.size());
        this.getGeoServer().reload();
        Assert.assertEquals((long)0L, (long)imageCache.size());
    }

    @Test
    public void testCacheConfiguration() {
        Assert.assertFalse((boolean)this.wms.isRemoteStylesCacheEnabled());
        WMSInfo info = this.wms.getServiceInfo();
        info.setCacheConfiguration(new CacheConfiguration(true));
        this.getGeoServer().save((ServiceInfo)info);
        Assert.assertTrue((boolean)this.wms.isRemoteStylesCacheEnabled());
    }

    @Test(expected=ServiceException.class)
    public void testCheckMaxDimensionsTime() throws Exception {
        WMSInfo info = this.wms.getServiceInfo();
        info.setMaxRequestedDimensionValues(1);
        this.getGeoServer().save((ServiceInfo)info);
        this.setupStartEndTimeDimension(TIME_WITH_START_END.getLocalPart(), "time", "startTime", "endTime");
        String name = TIME_WITH_START_END.getLocalPart();
        MapLayerInfo mapLayerInfo = new MapLayerInfo(this.getCatalog().getLayerByName(name));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateRange dateRange = new DateRange(formatter.parse("2012-02-09"), formatter.parse("2012-02-20"));
        List<Object> times = Arrays.asList(dateRange);
        this.wms.checkMaxDimensions(mapLayerInfo, times, null, false);
    }

    @Test(expected=ServiceException.class)
    public void testCheckMaxDimensionsElevation() throws Exception {
        WMSInfo info = this.wms.getServiceInfo();
        info.setMaxRequestedDimensionValues(1);
        this.getGeoServer().save((ServiceInfo)info);
        this.setupStartEndTimeDimension(TIME_WITH_START_END.getLocalPart(), "elevation", "startElevation", "endElevation");
        String name = TIME_WITH_START_END.getLocalPart();
        MapLayerInfo mapLayerInfo = new MapLayerInfo(this.getCatalog().getLayerByName(name));
        NumberRange elevationRange = NumberRange.create((int)0, (int)99);
        List<Object> elevations = Arrays.asList(elevationRange);
        this.wms.checkMaxDimensions(mapLayerInfo, null, elevations, false);
    }

    @Test
    public void testProjectionDensification() {
        Assert.assertFalse((boolean)this.wms.isAdvancedProjectionDensificationEnabled());
        WMSInfo info = this.wms.getServiceInfo();
        info.getMetadata().put(WMS.ADVANCED_PROJECTION_DENSIFICATION_KEY, (Serializable)Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)info);
        Assert.assertTrue((boolean)this.wms.isAdvancedProjectionDensificationEnabled());
    }

    @Test
    public void testWrappingHeuristic() {
        Assert.assertFalse((boolean)this.wms.isDateLineWrappingHeuristicDisabled());
        WMSInfo info = this.wms.getServiceInfo();
        info.getMetadata().put(WMS.DATELINE_WRAPPING_HEURISTIC_KEY, (Serializable)Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)info);
        Assert.assertTrue((boolean)this.wms.isDateLineWrappingHeuristicDisabled());
    }

    @Test
    public void testRootLayerInCapabilitiesEanbled() {
        Assert.assertTrue((boolean)this.wms.isRootLayerInCapabilitesEnabled());
        WMSInfo info = this.wms.getServiceInfo();
        info.getMetadata().put(WMS.ROOT_LAYER_IN_CAPABILITIES_KEY, (Serializable)Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)info);
        Assert.assertFalse((boolean)this.wms.isRootLayerInCapabilitesEnabled());
    }
}

