/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.HashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.wms.MapLayerInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MapLayerInfoTest {
    public static final int MAX_AGE_VALUE = 100;

    @Before
    public void setUp() throws Exception {
    }

    private MetadataMap getEnabledCacheMetadata(int maxAgeValue, Boolean cachingEnabled) {
        HashMap<String, Comparable<Boolean>> mapItems = new HashMap<String, Comparable<Boolean>>();
        mapItems.put("cachingEnabled", cachingEnabled);
        mapItems.put("cacheAgeMax", Integer.valueOf(maxAgeValue));
        return new MetadataMap(mapItems);
    }

    private LayerInfo getLayerInfo(PublishedType type) {
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        CatalogImpl catalog = new CatalogImpl();
        FeatureTypeInfoImpl resource = new FeatureTypeInfoImpl((Catalog)catalog);
        resource.setName("name");
        NamespaceInfoImpl namespaceInfo = new NamespaceInfoImpl();
        namespaceInfo.setPrefix("prefix");
        resource.setNamespace((NamespaceInfo)namespaceInfo);
        layerInfo.setResource((ResourceInfo)resource);
        layerInfo.setType(type);
        return layerInfo;
    }

    @Test
    public void isCachingDisabledRemoteWFSLayer() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.REMOTE), this.getEnabledCacheMetadata(100, Boolean.TRUE));
        Assert.assertFalse((boolean)info.isCachingEnabled());
    }

    @Test
    public void isCachingDisabledRemoteWFSLayerNoOverridden() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.REMOTE));
        Assert.assertFalse((boolean)info.isCachingEnabled());
    }

    @Test
    public void isCachingDisabled() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.VECTOR));
        Assert.assertFalse((boolean)info.isCachingEnabled());
    }

    @Test
    public void isCachingLayerInfoEnabled() {
        LayerInfo layerInfo = this.getLayerInfo(PublishedType.VECTOR);
        ResourceInfoImpl resource = (ResourceInfoImpl)layerInfo.getResource();
        resource.setMetadata(this.getEnabledCacheMetadata(100, Boolean.TRUE));
        MapLayerInfo info = new MapLayerInfo(layerInfo);
        Assert.assertTrue((boolean)info.isCachingEnabled());
    }

    @Test
    public void isCachingEnabledWithOverrideMetadata() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.VECTOR), this.getEnabledCacheMetadata(100, Boolean.TRUE));
        Assert.assertTrue((boolean)info.isCachingEnabled());
    }

    @Test
    public void isCachingLayerInfoEnabledBothDefined() {
        LayerInfo layerInfo = this.getLayerInfo(PublishedType.VECTOR);
        ResourceInfoImpl resource = (ResourceInfoImpl)layerInfo.getResource();
        resource.setMetadata(this.getEnabledCacheMetadata(100, Boolean.TRUE));
        MapLayerInfo info = new MapLayerInfo(layerInfo, this.getEnabledCacheMetadata(100, Boolean.TRUE));
        Assert.assertTrue((boolean)info.isCachingEnabled());
    }

    @Test
    public void getCacheMaxAgeIfDisabled() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.VECTOR));
        Assert.assertEquals((long)0L, (long)info.getCacheMaxAge());
    }

    @Test
    public void getCacheMaxAgeLayerInfo() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.VECTOR));
        ResourceInfoImpl resource = (ResourceInfoImpl)info.getResource();
        resource.setMetadata(this.getEnabledCacheMetadata(100, Boolean.TRUE));
        Assert.assertEquals((long)100L, (long)info.getCacheMaxAge());
    }

    @Test
    public void getCacheMaxAgeLayerInfoOverridden() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.VECTOR), this.getEnabledCacheMetadata(100, Boolean.TRUE));
        Assert.assertEquals((long)100L, (long)info.getCacheMaxAge());
    }

    @Test
    public void getCacheMaxAgeLayerInfoBothDefined() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.VECTOR), this.getEnabledCacheMetadata(100, Boolean.TRUE));
        ResourceInfoImpl resource = (ResourceInfoImpl)info.getResource();
        resource.setMetadata(this.getEnabledCacheMetadata(99, Boolean.TRUE));
        Assert.assertEquals((long)100L, (long)info.getCacheMaxAge());
    }

    @Test
    public void getCacheMaxAgeLayerInfoBothDefinedOverridenLower() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.VECTOR), this.getEnabledCacheMetadata(100, Boolean.TRUE));
        ResourceInfoImpl resource = (ResourceInfoImpl)info.getResource();
        resource.setMetadata(this.getEnabledCacheMetadata(101, Boolean.TRUE));
        Assert.assertEquals((long)100L, (long)info.getCacheMaxAge());
    }

    @Test
    public void getCacheMaxAgeGroupDisabledButDefined() {
        MapLayerInfo info = new MapLayerInfo(this.getLayerInfo(PublishedType.VECTOR), this.getEnabledCacheMetadata(100, Boolean.FALSE));
        ResourceInfoImpl resource = (ResourceInfoImpl)info.getResource();
        resource.setMetadata(this.getEnabledCacheMetadata(101, Boolean.TRUE));
        Assert.assertEquals((long)101L, (long)info.getCacheMaxAge());
    }
}

