/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.impl.WMTSStoreInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSMockData;
import org.geoserver.wms.WebMap;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.function.EnvFunction;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.map.WMTSMapLayer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Point;

public class GetMapTest {
    private WMSMockData mockData;
    private GetMapRequest request;
    private GetMap getMapOp;

    @Before
    public void setUp() throws Exception {
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        this.request = this.mockData.createRequest();
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("testType", Point.class);
        this.request.setLayers(Arrays.asList(layer));
        this.getMapOp = new GetMap(this.mockData.getWMS());
    }

    @Test
    public void testExecuteNoExtent() {
        this.request.setBbox(null);
        this.assertInvalidMandatoryParam("MissingBBox");
    }

    @Test
    public void testExecuteEmptyExtent() {
        this.request.setBbox(new Envelope());
        this.assertInvalidMandatoryParam("InvalidBBox");
    }

    @Test
    public void testSingleVectorLayer() throws IOException {
        this.request.setFormat("image/dummy");
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("testSingleVectorLayer", Point.class);
        this.request.setLayers(Arrays.asList(layer));
        final WMSMockData.DummyRasterMapProducer producer = new WMSMockData.DummyRasterMapProducer();
        WMS wms = new WMS(this.mockData.getGeoServer()){

            public GetMapOutputFormat getMapOutputFormat(String mimeType) {
                if ("image/dummy".equals(mimeType)) {
                    return producer;
                }
                return null;
            }
        };
        this.getMapOp = new GetMap(wms);
        this.getMapOp.run(this.request);
        Assert.assertTrue((boolean)producer.produceMapCalled);
    }

    @Test
    public void testExecuteNoLayers() throws Exception {
        this.request.setLayers(null);
        this.assertInvalidMandatoryParam("LayerNotDefined");
    }

    @Test
    public void testExecuteNoWidth() {
        this.request.setWidth(0);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
        this.request.setWidth(-1);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
    }

    @Test
    public void testExecuteNoHeight() {
        this.request.setHeight(0);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
        this.request.setHeight(-1);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
    }

    @Test
    public void testExecuteInvalidFormat() {
        this.request.setFormat("non-existent-output-format");
        this.assertInvalidMandatoryParam("InvalidFormat");
    }

    @Test
    public void testExecuteNoFormat() {
        this.request.setFormat(null);
        this.assertInvalidMandatoryParam("InvalidFormat");
    }

    @Test
    public void testExecuteNoStyles() {
        this.request.setStyles(null);
        this.assertInvalidMandatoryParam("StyleNotDefined");
    }

    @Test
    public void testEnviroment() {
        final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        EnvFunction.setLocalValues(Collections.singletonMap("myParam", 23));
        final WMSMockData.DummyRasterMapProducer producer = new WMSMockData.DummyRasterMapProducer(){

            @Override
            public WebMap produceMap(WMSMapContent ctx) throws ServiceException, IOException {
                Assert.assertEquals((Object)23, (Object)ff.function("env", new Expression[]{ff.literal((Object)"myParam")}).evaluate(null));
                Assert.assertEquals((Object)10, (Object)ff.function("env", new Expression[]{ff.literal((Object)"otherParam"), ff.literal(10)}).evaluate(null));
                this.produceMapCalled = true;
                return null;
            }
        };
        WMS wms = new WMS(this.mockData.getGeoServer()){

            public GetMapOutputFormat getMapOutputFormat(String mimeType) {
                if ("image/dummy".equals(mimeType)) {
                    return producer;
                }
                return null;
            }
        };
        this.getMapOp = new GetMap(wms);
        this.getMapOp.run(this.request);
        Assert.assertTrue((boolean)producer.produceMapCalled);
    }

    private void assertInvalidMandatoryParam(String expectedExceptionCode) {
        try {
            this.getMapOp.run(this.request);
            Assert.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            Assert.assertEquals((Object)expectedExceptionCode, (Object)e.getCode());
        }
    }

    @Test
    public void addWMTSLayerIsAddingNativeCRSAsSource() throws IOException, FactoryException {
        Request request = new Request();
        request.setRawKvp(new HashMap());
        Dispatcher.REQUEST.set(request);
        String baseURL = "http://mock.test.geoserver.org";
        MockHttpClient client = new MockHttpClient();
        Catalog catalog = this.mockData.getGeoServer().getCatalog();
        URL descURL = new URL(baseURL + "/wmts?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS");
        client.expectGet(descURL, (HTTPResponse)new MockHttpResponse(this.getClass().getResource("wmts_getCaps.xml"), "text/xml", new String[0]));
        TestHttpClientProvider.bind((HTTPClient)client, (URL)descURL);
        MockWMTSStoreInfo storeInfo = new MockWMTSStoreInfo(catalog);
        storeInfo.setName("Another Mock WMTS Store");
        storeInfo.setCapabilitiesURL(descURL.toString());
        storeInfo.setConnectTimeout(60);
        storeInfo.setMaxConnections(10);
        storeInfo.setDateCreated(new Date());
        storeInfo.setDateModified(new Date());
        catalog.add((StoreInfo)storeInfo);
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        WMTSLayerInfo wmtsInfo = (WMTSLayerInfo)xp.load(this.getClass().getResourceAsStream("wmtsLayerInfo.xml"), WMTSLayerInfo.class);
        wmtsInfo.setStore((StoreInfo)storeInfo);
        catalog.add((ResourceInfo)wmtsInfo);
        LayerInfo layerInfo = (LayerInfo)xp.load(this.getClass().getResourceAsStream("wmtsLayer.xml"), LayerInfo.class);
        layerInfo.setResource((ResourceInfo)wmtsInfo);
        GetMap op = new GetMap(this.mockData.getWMS());
        WMSMapContent mapContent = new WMSMapContent();
        MapLayerInfo mli = new MapLayerInfo(layerInfo);
        op.addWMTSLayer(mapContent, mli);
        WMTSMapLayer layer = (WMTSMapLayer)mapContent.layers().get(0);
        SimpleFeature sf = (SimpleFeature)layer.toFeatureCollection().features().next();
        GeneralParameterValue[] params = (GeneralParameterValue[])new AttributeExpressionImpl("params").evaluate((Object)sf, GeneralParameterValue[].class);
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)((ParameterValue)params[0]).getValue();
        Assert.assertEquals((Object)wmtsInfo.getNativeCRS(), (Object)crs);
    }

    class MockWMTSStoreInfo
    extends WMTSStoreInfoImpl {
        MockWMTSStoreInfo(Catalog catalog) {
            super(catalog);
        }

        public WebMapTileServer getWebMapTileServer(ProgressListener listener) throws IOException {
            try {
                return new WebMapTileServer(((Object)((Object)this)).getClass().getResource("wmts_getCaps.xml").toURI().toURL());
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

